/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.botaunomy.item;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import one.flexo.botaunomy.api.IElvenAvatarTile;
import one.flexo.botaunomy.api.IElvenAvatarWieldable;
import one.flexo.botaunomy.nibbler.ItemBase;
import one.flexo.nibbler.util.NibblerUtil;
import vazkii.botania.api.item.IAvatarTile;

public class WillRodItem
extends ItemBase
implements IElvenAvatarWieldable {
    static final ResourceLocation avatarOverlay = new ResourceLocation("botaunomy:textures/model/avatar_will.png");
    private static final int MANA_COST = 200;
    protected boolean useRightClick;

    public WillRodItem(String name, boolean useRightClick) {
        super(name);
        this.useRightClick = useRightClick;
    }

    public ResourceLocation getOverlayResource(IAvatarTile tileAvatar, ItemStack stack) {
        return avatarOverlay;
    }

    @Override
    public void onAvatarUpdate(IAvatarTile tileAvatar, ItemStack stack) {
    }

    @Override
    public void onElvenAvatarUpdate(IElvenAvatarTile avatar, ItemStack stack) {
        if (!avatar.isEnabled()) {
            return;
        }
        if (avatar.getCurrentMana() >= 200 && avatar.getElapsedFunctionalTicks() % 20 == 0) {
            boolean interactedWithBlock = false;
            boolean interactedWithEntities = false;
            TileEntity tile = avatar.asTileEntity();
            WeakReference<FakePlayer> avatarPlayer = avatar.getAvatarPlayer();
            if (avatarPlayer == null) {
                return;
            }
            ((FakePlayer)avatarPlayer.get()).field_70177_z = NibblerUtil.Entity.getYaw((EnumFacing)avatar.getAvatarFacing());
            boolean rightClick = this.useRightClick();
            try {
                BlockPos targetPos = tile.func_174877_v().func_177972_a(avatar.getAvatarFacing());
                interactedWithBlock = this.interactBlock(avatar, avatarPlayer, targetPos, this.useRightClick);
                interactedWithEntities = this.interactEntities(avatar, avatarPlayer, targetPos, this.useRightClick);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (interactedWithBlock || interactedWithEntities) {
                avatar.recieveMana(-200);
            }
        }
    }

    protected boolean useRightClick() {
        return true;
    }

    private boolean interactBlock(IElvenAvatarTile tileElvenAvatar, WeakReference<FakePlayer> fakePlayer, BlockPos targetPos, boolean rightClick) {
        if (this.interactFluid(tileElvenAvatar, fakePlayer, targetPos, true)) {
            return true;
        }
        if (Block.func_149634_a((Item)((FakePlayer)fakePlayer.get()).func_184614_ca().func_77973_b()) != Blocks.field_150350_a) {
            return false;
        }
        World world = tileElvenAvatar.getAvatarWorld();
        EnumActionResult r = ((FakePlayer)fakePlayer.get()).field_71134_c.func_187251_a((EntityPlayer)fakePlayer.get(), world, ((FakePlayer)fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND, targetPos, EnumFacing.UP, 0.5f, 0.5f, 0.5f);
        if (r == EnumActionResult.SUCCESS) {
            return true;
        }
        r = ((FakePlayer)fakePlayer.get()).field_71134_c.func_187250_a((EntityPlayer)fakePlayer.get(), world, ((FakePlayer)fakePlayer.get()).func_184614_ca(), EnumHand.MAIN_HAND);
        if (r == EnumActionResult.SUCCESS) {
            return true;
        }
        ActionResult res = ((FakePlayer)fakePlayer.get()).func_184614_ca().func_77973_b().func_77659_a(world, (EntityPlayer)fakePlayer.get(), EnumHand.MAIN_HAND);
        return res != null || res.func_188397_a() == EnumActionResult.SUCCESS;
    }

    private boolean interactFluid(IElvenAvatarTile tileElvenAvatar, WeakReference<FakePlayer> avatarPlayer, BlockPos targetPos, boolean rightClick) {
        return false;
    }

    private boolean interactEntities(IElvenAvatarTile tileElvenAvatar, WeakReference<FakePlayer> avatarPlayer, BlockPos targetPos, boolean rightClick) {
        boolean interacted;
        block2: {
            List living;
            block3: {
                interacted = true;
                AxisAlignedBB entityRange = new AxisAlignedBB(targetPos).func_72317_d(0.5, 0.0, 0.5);
                World world = tileElvenAvatar.getAvatarWorld();
                living = world.func_72872_a(EntityLivingBase.class, entityRange);
                List carts = world.func_72872_a(EntityMinecart.class, entityRange);
                ArrayList all = new ArrayList(living);
                all.addAll(carts);
                if (!rightClick) break block3;
                world.func_175646_b(targetPos, tileElvenAvatar.asTileEntity());
                if (world.field_72995_K) break block2;
                for (Entity entity : all) {
                    if (entity == null || entity.field_70128_L || EnumActionResult.FAIL == ((FakePlayer)avatarPlayer.get()).func_190775_a(entity, EnumHand.MAIN_HAND)) continue;
                    this.dropInventory(world, avatarPlayer, targetPos);
                    interacted = true;
                    break block2;
                }
                break block2;
            }
            ItemStack mainHand = ((FakePlayer)avatarPlayer.get()).func_184614_ca();
            ((FakePlayer)avatarPlayer.get()).field_70122_E = true;
            for (EntityLivingBase entity : living) {
                interacted = true;
                ((FakePlayer)avatarPlayer.get()).func_71059_n((Entity)entity);
                float damage = NibblerUtil.Entity.getAttackDamage((ItemStack)mainHand, (EntityLivingBase)entity);
                entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)avatarPlayer.get())), damage);
            }
        }
        return interacted;
    }

    private void dropInventory(World world, WeakReference<FakePlayer> avatarPlayer, BlockPos pos) {
        ItemStack mainHand = ((FakePlayer)avatarPlayer.get()).func_184614_ca();
        for (ItemStack s : ((FakePlayer)avatarPlayer.get()).field_71071_by.field_70462_a) {
            if (s.func_190926_b() || s.equals(mainHand)) continue;
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, s.func_77946_l());
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)entityItem);
            }
            s.func_190920_e(0);
        }
    }
}

