/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.botaunomy.block.tile;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import one.flexo.botaunomy.Botaunomy;
import one.flexo.botaunomy.api.IElvenAvatarTile;
import one.flexo.botaunomy.api.IElvenAvatarWieldable;
import vazkii.botania.api.item.IAvatarTile;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.TileSimpleInventory;

public class TileElvenAvatar
extends TileSimpleInventory
implements IElvenAvatarTile {
    private static final int MAX_MANA = 25600;
    protected static final String TAG_ENABLED = "enabled";
    protected static final String TAG_TICKS_ELAPSED = "ticksElapsed";
    protected static final String TAG_MANA = "ticksElapsed";
    protected boolean enabled;
    protected int ticksElapsed;
    protected int mana;
    public final UUID uuid = UUID.randomUUID();
    protected WeakReference<FakePlayer> avatarPlayer;

    public void func_73660_a() {
        ItemStack stack;
        this.enabled = true;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            int redstoneSide = this.field_145850_b.func_175651_c(this.field_174879_c.func_177972_a(dir), dir);
            if (redstoneSide <= 0) continue;
            this.enabled = false;
            break;
        }
        if (!(stack = this.itemHandler.getStackInSlot(0)).func_190926_b()) {
            if (stack.func_77973_b() instanceof IElvenAvatarWieldable) {
                IElvenAvatarWieldable wieldable = (IElvenAvatarWieldable)stack.func_77973_b();
                wieldable.onElvenAvatarUpdate(this, stack);
            }
            if (stack.func_77973_b() instanceof IAvatarWieldable) {
                IAvatarWieldable wieldable = (IAvatarWieldable)stack.func_77973_b();
                wieldable.onAvatarUpdate((IAvatarTile)this, stack);
            }
        }
        if (this.enabled) {
            ++this.ticksElapsed;
        }
    }

    @Override
    public TileEntity asTileEntity() {
        return this;
    }

    @Override
    public World getAvatarWorld() {
        return this.field_145850_b;
    }

    @Override
    public WeakReference<FakePlayer> getAvatarPlayer() {
        if (this.field_145850_b instanceof WorldServer && this.avatarPlayer == null) {
            this.avatarPlayer = TileElvenAvatar.initFakePlayer((WorldServer)this.field_145850_b, this.uuid);
            if (this.avatarPlayer == null) {
                return null;
            }
        }
        return this.avatarPlayer;
    }

    private static WeakReference<FakePlayer> initFakePlayer(WorldServer ws, UUID uname) {
        GameProfile profile = new GameProfile(uname, uname.toString());
        try {
            WeakReference<FakePlayer> fakePlayer = new WeakReference<FakePlayer>(FakePlayerFactory.get((WorldServer)ws, (GameProfile)profile));
            if (fakePlayer == null || fakePlayer.get() == null) {
                return null;
            }
            ((FakePlayer)fakePlayer.get()).field_70122_E = true;
            ((FakePlayer)fakePlayer.get()).field_71135_a = new NetHandlerPlayServer(FMLCommonHandler.instance().getMinecraftServerInstance(), new NetworkManager(EnumPacketDirection.SERVERBOUND), (EntityPlayerMP)fakePlayer.get()){

                public void func_147359_a(Packet packetIn) {
                }
            };
            ((FakePlayer)fakePlayer.get()).func_174810_b(true);
            return fakePlayer;
        }
        catch (Exception e) {
            Botaunomy.logger.error("Exception thrown trying to create fake player : " + e.getMessage());
            return null;
        }
    }

    public void writePacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.writePacketNBT(par1nbtTagCompound);
        par1nbtTagCompound.func_74757_a(TAG_ENABLED, this.enabled);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.ticksElapsed);
        par1nbtTagCompound.func_74768_a("ticksElapsed", this.mana);
    }

    public void readPacketNBT(NBTTagCompound par1nbtTagCompound) {
        super.readPacketNBT(par1nbtTagCompound);
        this.enabled = par1nbtTagCompound.func_74767_n(TAG_ENABLED);
        this.ticksElapsed = par1nbtTagCompound.func_74762_e("ticksElapsed");
        this.mana = par1nbtTagCompound.func_74762_e("ticksElapsed");
    }

    public int getSizeInventory() {
        return 1;
    }

    protected TileSimpleInventory.SimpleItemStackHandler createItemHandler() {
        return new TileSimpleInventory.SimpleItemStackHandler(this, false){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }
        };
    }

    public boolean isFull() {
        return this.mana >= 25600;
    }

    public void recieveMana(int mana) {
        this.mana = Math.max(0, Math.min(25600, this.mana + mana));
    }

    public boolean canRecieveManaFromBursts() {
        return !this.itemHandler.getStackInSlot(0).func_190926_b();
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public IItemHandler getInventory() {
        return this.getItemHandler();
    }

    public EnumFacing getAvatarFacing() {
        return (EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BotaniaStateProps.CARDINALS);
    }

    public int getElapsedFunctionalTicks() {
        return this.ticksElapsed;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

