/*
 * Decompiled with CFR 0.152.
 */
package one.flexo.botaunomy.block;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import one.flexo.botaunomy.api.IElvenAvatarWieldable;
import one.flexo.botaunomy.block.tile.TileElvenAvatar;
import one.flexo.botaunomy.nibbler.BlockBase;
import one.flexo.nibbler.block.NibblerBlock;
import vazkii.botania.api.item.IAvatarWieldable;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.core.helper.InventoryHelper;
import vazkii.botania.common.lexicon.LexiconData;

public class ElvenAvatarBlock
extends BlockBase
implements ILexiconable {
    public static final String NAME = "elven_avatar";
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.3125, 0.0, 0.21875, 0.6875, 1.0625, 0.78125);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.21875, 0.0, 0.3125, 0.78125, 1.0625, 0.6875);

    public ElvenAvatarBlock() {
        super(Material.field_151575_d, NAME);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.NORTH));
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((EnumFacing)state.func_177229_b((IProperty)BotaniaStateProps.CARDINALS)).func_176740_k() == EnumFacing.Axis.X) {
            return X_AABB;
        }
        return Z_AABB;
    }

    @Nonnull
    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BotaniaStateProps.CARDINALS});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BotaniaStateProps.CARDINALS)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        if (meta < 2 || meta > 5) {
            meta = 2;
        }
        return this.func_176223_P().func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing s, float xs, float ys, float zs) {
        TileElvenAvatar avatar = (TileElvenAvatar)world.func_175625_s(pos);
        ItemStack stackOnAvatar = avatar.getItemHandler().getStackInSlot(0);
        ItemStack stackOnPlayer = player.func_184586_b(hand);
        if (!stackOnAvatar.func_190926_b()) {
            avatar.getItemHandler().setStackInSlot(0, ItemStack.field_190927_a);
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stackOnAvatar);
            return true;
        }
        if (!stackOnPlayer.func_190926_b() && (stackOnPlayer.func_77973_b() instanceof IAvatarWieldable || stackOnPlayer.func_77973_b() instanceof IElvenAvatarWieldable)) {
            avatar.getItemHandler().setStackInSlot(0, stackOnPlayer.func_77979_a(1));
            return true;
        }
        return false;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileSimpleInventory inv = (TileSimpleInventory)world.func_175625_s(pos);
        InventoryHelper.dropInventory((TileSimpleInventory)inv, (World)world, (IBlockState)state, (BlockPos)pos);
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)BotaniaStateProps.CARDINALS, (Comparable)placer.func_174811_aO().func_176734_d()));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileElvenAvatar();
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.avatar;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BotaniaStateProps.CARDINALS}).func_178441_a());
        ForgeHooksClient.registerTESRItemStack((Item)Item.func_150898_a((Block)this), (int)0, TileElvenAvatar.class);
        ElvenAvatarBlock.registerCustomItemblock((NibblerBlock)this, (int)1);
    }
}

