/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako.packets;

import alexiy.satako.PrivateProperty;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetPropertyUUID
implements IMessage {
    UUID uuid;
    BlockPos pos;
    boolean lock;

    public SetPropertyUUID() {
    }

    public SetPropertyUUID(BlockPos blockPos, UUID uuid_, boolean setLocked) {
        this.pos = blockPos;
        this.uuid = uuid_;
        this.lock = setLocked;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.lock = buf.readBoolean();
        if (buf.isReadable()) {
            this.uuid = UUID.fromString(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.lock);
        if (this.uuid != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid.toString());
        }
    }

    public static class Handler
    implements IMessageHandler<SetPropertyUUID, IMessage> {
        public IMessage onMessage(SetPropertyUUID message, MessageContext ctx) {
            WorldServer worldServer = ctx.getServerHandler().field_147369_b.func_71121_q();
            worldServer.func_152344_a(() -> {
                TileEntity privateProperty = worldServer.func_175625_s(message.pos);
                if (privateProperty instanceof PrivateProperty) {
                    PrivateProperty pp = (PrivateProperty)privateProperty;
                    pp.setOwnerIdentifier(message.uuid);
                    pp.setLocked(message.lock);
                    privateProperty.func_70296_d();
                    IBlockState blockState = worldServer.func_180495_p(message.pos);
                    worldServer.func_184138_a(message.pos, blockState, blockState, 2);
                }
            });
            return null;
        }
    }
}

