/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako.gui;

import alexiy.satako.General;
import alexiy.satako.Tools;
import alexiy.satako.UniqueList;
import alexiy.satako.gui.Clickable;
import alexiy.satako.gui.Hideable;
import alexiy.satako.gui.Label;
import alexiy.satako.gui.Positionable;
import alexiy.satako.gui.Scrollable;

public class ScrollList
implements Clickable,
Scrollable,
Hideable {
    public UniqueList<Object> items = new UniqueList(2);
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean visible = true;

    public ScrollList(int x, int y, int width_, int height_, Object ... entries) {
        this.x = x;
        this.y = y;
        this.width = width_;
        this.height = height_;
        if (entries != null) {
            for (Object object : entries) {
                this.addItem(object);
            }
        }
    }

    public void addItem(Object o) {
        Positionable positionable;
        if (o instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)o;
            scrollable.setScrollable(true, true);
        }
        if (o instanceof Positionable && o instanceof Hideable && ((positionable = (Positionable)o).getY() < this.y || positionable.getY() + positionable.getHeight() > this.y + this.height)) {
            ((Hideable)o).setHidden();
        }
        this.items.add(o);
    }

    public void draw() {
        if (this.visible) {
            Tools.drawHorizontalLine(this.x, this.x + this.width, this.y, General.LIGHTGREEN);
            Tools.drawHorizontalLine(this.x, this.x + this.width, this.y + this.height, General.LIGHTGREEN);
            Tools.drawVerticalLine(this.x, this.y, this.y + this.height, General.LIGHTGREEN);
            Tools.drawVerticalLine(this.x + this.width, this.y, this.y + this.height, General.LIGHTGREEN);
        }
        for (Object e : this.items) {
            if (!(e instanceof Label)) continue;
            ((Label)e).draw();
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (this.visible) {
            for (Object e : this.items) {
                if (!(e instanceof Positionable) || !(e instanceof Hideable)) continue;
                Positionable p = (Positionable)e;
                Hideable h = (Hideable)e;
                if (p.getY() + p.getHeight() > this.y + this.height || p.getY() < this.y) {
                    h.setHidden();
                    continue;
                }
                h.setVisible();
            }
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void setEnabled() {
    }

    @Override
    public void setDisabled() {
    }

    @Override
    public void setHidden() {
        this.visible = false;
    }

    @Override
    public void setVisible() {
        this.visible = true;
        for (Object e : this.items) {
            if (!(e instanceof Hideable)) continue;
            if (this.isElementInside(e)) {
                ((Hideable)e).setVisible();
                continue;
            }
            ((Hideable)e).setHidden();
        }
    }

    private boolean isElementInside(Object o) {
        if (o instanceof Positionable) {
            Positionable positionable = (Positionable)o;
            return positionable.getY() + positionable.getHeight() <= this.y + this.height && positionable.getY() >= this.y;
        }
        return false;
    }
}

