/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako.gui;

import alexiy.satako.Tools;
import alexiy.satako.gui.Hideable;
import alexiy.satako.gui.Positionable;
import alexiy.satako.gui.Scrollable;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class Label
implements Scrollable,
Positionable,
Hideable {
    protected String text;
    private Color textColor;
    private int width;
    private int x;
    private int y;
    private final int height = 13;
    private final int leftmargin = 5;
    private final int topmargin = 5;
    public int customXScroll;
    public int customYScroll;
    public Color backgroundcolor;
    public boolean enabled = true;
    public boolean visible = true;
    public boolean backgroundEnabled = true;
    public boolean horizontalScroll;
    public boolean verticalScroll;

    protected Label(String text, Color textColor, int width, @Nullable Color backgroundcolor, int x_, int y_, boolean enabled, boolean verticalScroll, boolean horizontalScroll) {
        this.text = text;
        this.textColor = textColor;
        this.width = backgroundcolor == null ? width : width + 6;
        this.x = backgroundcolor == null ? x_ : x_ + 5;
        this.y = backgroundcolor == null ? y_ : y_ + 5;
        this.backgroundcolor = backgroundcolor;
        this.enabled = enabled;
        this.horizontalScroll = horizontalScroll;
        this.verticalScroll = verticalScroll;
    }

    public static Label getLabelForLayoutManager(String caption, Color textColor, @Nullable Color backgroundcolor, boolean verticalScroll) {
        return Label.getFittedLabel(caption, textColor, backgroundcolor, 0, 0, verticalScroll);
    }

    public static Label getFittedLabel(String text_, Color textColor_, @Nullable Color backgroundColor_, int x_, int y_, boolean verticalScroll) {
        return new Label(text_, textColor_, Tools.calculateStringWidth(text_), backgroundColor_, x_, y_, true, verticalScroll, false);
    }

    public static Label getDefaultLabel(Color textColor_, String text_, int x_, int y_, boolean verticalScroll) {
        return new Label(text_, textColor_, Tools.calculateStringWidth(text_), new Color(0), x_, y_, true, verticalScroll, false);
    }

    public static Label getLabelWithoutBackGround(String text, Color textColor, int x, int y, boolean verticalScroll) {
        return new Label(text, textColor, Tools.calculateStringWidth(text), null, x, y, true, verticalScroll, false);
    }

    public Label(String text_, Color textColor_, int x_, int y_, boolean scrollable_) {
        this(text_, textColor_, Tools.calculateStringWidth(text_), null, x_, y_, true, scrollable_, false);
    }

    public static Label getCenteredLabel(String text_, Color textColor_, int x_, int y_, boolean verticalscroll) {
        return new Label(text_, textColor_, Tools.calculateStringWidth(text_), Color.BLACK, x_ - (Tools.calculateStringWidth(text_) + 8) / 2, y_, true, verticalscroll, false);
    }

    @Override
    public void scroll(int amount, boolean vertical) {
        if (this.isEnabled()) {
            if (vertical && this.verticalScroll) {
                this.y = this.customYScroll > 0 ? (this.y += amount > 0 ? this.customYScroll : -this.customYScroll) : (this.y += amount > 0 ? this.getHeight() : -this.getHeight());
            } else if (this.horizontalScroll) {
                this.x += amount > 0 ? this.getwidth() : -this.getwidth();
            }
        }
    }

    @Override
    public void setScrollable(boolean vertical, boolean b) {
        if (b) {
            if (vertical) {
                this.verticalScroll = true;
            } else {
                this.horizontalScroll = true;
            }
        } else if (vertical) {
            this.verticalScroll = false;
        } else {
            this.horizontalScroll = false;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled() {
        this.enabled = true;
    }

    @Override
    public void setDisabled() {
        this.enabled = false;
    }

    public void setText(String string) {
        this.text = string;
        this.width = Minecraft.func_71410_x().field_71466_p.func_78256_a(string) + 8;
    }

    public String getText() {
        return this.text;
    }

    public void draw() {
        if (this.visible) {
            try {
                if (this.backgroundEnabled && this.backgroundcolor != null) {
                    GlStateManager.func_179090_x();
                    Tessellator t = Tessellator.func_178181_a();
                    BufferBuilder vertexBuffer = t.func_178180_c();
                    GlStateManager.func_179124_c((float)((float)this.backgroundcolor.getRed() / 255.0f), (float)((float)this.backgroundcolor.getGreen() / 255.0f), (float)((float)this.backgroundcolor.getBlue() / 255.0f));
                    vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                    vertexBuffer.func_181662_b((double)(this.x - 4), (double)(this.y - 5), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x - 4), (double)(this.y + 13), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x + this.width - 3), (double)(this.y + 13), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x + this.width - 3), (double)(this.y - 5), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x - 5), (double)(this.y - 4), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x - 5), (double)(this.y + 13 - 1), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x + this.width - 2), (double)(this.y + 13 - 1), 0.0).func_181675_d();
                    vertexBuffer.func_181662_b((double)(this.x + this.width - 2), (double)(this.y - 4), 0.0).func_181675_d();
                    t.func_78381_a();
                    GlStateManager.func_179098_w();
                }
                Tools.drawString(this.text, this.x, this.y, this.textColor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getwidth() {
        if (this.backgroundcolor != null) {
            return this.width + 4;
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.backgroundcolor != null) {
            return 19;
        }
        return 13;
    }

    @Override
    public void setX(int x_) {
        this.x = this.backgroundcolor != null ? x_ + 5 : x_;
    }

    @Override
    public void setY(int y_) {
        this.y = this.backgroundcolor != null ? y_ + 5 : y_;
    }

    @Override
    public int getX() {
        if (this.backgroundcolor != null) {
            return this.x - 5;
        }
        return this.x;
    }

    @Override
    public int getY() {
        if (this.backgroundcolor != null) {
            return this.y - 6;
        }
        return this.y;
    }

    @Override
    public void setHidden() {
        this.visible = false;
    }

    @Override
    public void setVisible() {
        this.visible = true;
    }
}

