/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako;

import alexiy.satako.ItemHandler;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class Tools {
    public static final Random randomgenerator = new Random();
    private static final String replacementToken = "$$";

    public static boolean isPlayerInSurvival(EntityPlayer player) {
        return !player.func_184812_l_() && !player.func_175149_v();
    }

    public static boolean isSuperClass(Class subject, Object of) {
        if (of.getClass() == Class.class) {
            return subject.isAssignableFrom((Class)of);
        }
        return subject.isInstance(of);
    }

    public static List<BlockPos> boundingBoxToPositions(AxisAlignedBB axisAlignedBB) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (double X = axisAlignedBB.field_72340_a; X <= axisAlignedBB.field_72336_d; X += 1.0) {
            for (double Y = axisAlignedBB.field_72338_b; Y <= axisAlignedBB.field_72337_e; Y += 1.0) {
                for (double Z = axisAlignedBB.field_72339_c; Z <= axisAlignedBB.field_72334_f; Z += 1.0) {
                    positions.add(new BlockPos(X, Y, Z));
                }
            }
        }
        return positions;
    }

    public static void openContainerUI(EntityPlayer player, BlockPos blockPos, int guiID, Object mod) {
        if (!player.field_70170_p.field_72995_K) {
            player.openGui(mod, guiID, player.field_70170_p, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
    }

    public static void sendBlockUpdate(WorldServer worldServer, BlockPos blockPos) {
        IBlockState blockState = worldServer.func_180495_p(blockPos);
        worldServer.func_184138_a(blockPos, blockState, blockState, 2);
    }

    public static void openClientGui(World world, EntityPlayer player, int guiID, BlockPos position, Object mod) {
        if (world.field_72995_K) {
            player.openGui(mod, guiID, world, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
        }
    }

    public static String mapToString(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        String s = map.toString();
        Object key = map.keySet().iterator().next();
        Object value = map.values().iterator().next();
        String valueclass = value.getClass().getCanonicalName();
        String keyclass = key.getClass().getCanonicalName();
        Class<?> keyc = key.getClass();
        if (Enum.class.isAssignableFrom(keyc)) {
            try {
                TreeMap enumObjectTreeMap = new TreeMap();
                for (Object o : map.keySet()) {
                    enumObjectTreeMap.put((Enum)o, map.get(o));
                }
                Field[] fields = keyc.getDeclaredFields();
                ArrayList<String> exactNames = new ArrayList<String>(map.size());
                for (Field field : fields) {
                    field.setAccessible(true);
                    if (!field.isEnumConstant()) continue;
                    String enumfield = field.getName();
                    exactNames.add(enumfield);
                }
                HashMap stringObjectHashMap = new HashMap();
                block4: for (Enum anEnum : enumObjectTreeMap.keySet()) {
                    Object v = enumObjectTreeMap.get(anEnum);
                    for (String exactName : exactNames) {
                        if (!exactName.equals(anEnum.name())) continue;
                        stringObjectHashMap.put(exactName, v);
                        continue block4;
                    }
                }
                return keyclass + "##" + valueclass + "##" + stringObjectHashMap.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String string = keyclass + "##" + valueclass + "##" + s;
        return string;
    }

    @Deprecated
    public static HashMap stringToMap(String s) {
        if (!s.isEmpty()) {
            String[] strings = s.split("##");
            String keyclass = strings[0];
            String valueclass = strings[1];
            String map = strings[2];
            try {
                Class<?> key = Class.forName(keyclass);
                Class<?> value = Class.forName(valueclass);
                map = map.replace("{", "").replace("}", "").replace(" ", "");
                String[] mappings = map.split(",");
                HashMap<String, String> stringHashMap = new HashMap<String, String>(mappings.length, 1.0f);
                for (String mapping : mappings) {
                    String k = mapping.substring(0, mapping.indexOf(61));
                    String v = mapping.substring(mapping.indexOf(61) + 1);
                    stringHashMap.put(k, v);
                }
                if (Enum.class.isAssignableFrom(key)) {
                    HashMap enumObjectHashMap = new HashMap(stringHashMap.size(), 1.0f);
                    try {
                        for (String s1 : stringHashMap.keySet()) {
                            Object en = Enum.valueOf(key, s1);
                            enumObjectHashMap.put(en, stringHashMap.get(((Enum)en).name()));
                        }
                        return enumObjectHashMap;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return new HashMap();
            }
        }
        return new HashMap();
    }

    @Deprecated
    public static Block registerBlock(Block block, String modidentifier, String blockidentifier, @Nullable CreativeTabs creativeTab, @Nullable Class<? extends TileEntity> tileEntity, RegistryEvent.Register<Block> registryEvent) {
        ((Block)block.setRegistryName(modidentifier + ":" + blockidentifier)).func_149663_c(blockidentifier);
        if (creativeTab != null) {
            block.func_149647_a(creativeTab);
        }
        if (tileEntity != null) {
            GameRegistry.registerTileEntity(tileEntity, (String)(modidentifier + "-" + blockidentifier));
        }
        registryEvent.getRegistry().register((IForgeRegistryEntry)block);
        return block;
    }

    public static Block registerBlock(Block block, String modidentifier, String identifier, IForgeRegistry<Block> registry, @Nullable CreativeTabs creativeTab, @Nullable Class<? extends TileEntity> tileEntity) {
        ((Block)block.setRegistryName(modidentifier, identifier)).func_149663_c(identifier);
        registry.register((IForgeRegistryEntry)block);
        if (creativeTab != null) {
            block.func_149647_a(creativeTab);
        }
        if (tileEntity != null) {
            GameRegistry.registerTileEntity(tileEntity, (String)(modidentifier + ":" + identifier));
        }
        return block;
    }

    public static EntityPlayerMP getMPplayer(MessageContext messageContext) {
        return messageContext.getServerHandler().field_147369_b;
    }

    public static void sendToPlayersAround(IMessage message, World world, BlockPos blockPos, SimpleNetworkWrapper networkWrapper) {
        Tools.sendToPlayersAround(message, world, blockPos, 7, networkWrapper);
    }

    public static void sendToPlayersAround(IMessage message, World world, BlockPos blockPos, int range, SimpleNetworkWrapper networkWrapper) {
        networkWrapper.sendToAllAround(message, new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), (double)range));
    }

    public static EnumFacing randomHorizontalFacing() {
        return EnumFacing.field_176754_o[randomgenerator.nextInt(EnumFacing.field_176754_o.length)];
    }

    public static Item registerBlockItem(Block block, String ID, String identifier, RegistryEvent.Register<Item> registryEvent) {
        Item b1 = (Item)new ItemBlock(block).setRegistryName(ID, identifier);
        registryEvent.getRegistry().register((IForgeRegistryEntry)b1);
        return b1;
    }

    public static void playSound(World world, BlockPos blockPos, SoundEvent sound, float volume, float pitch) {
        world.func_184134_a((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), sound, null, volume, pitch, false);
    }

    public static boolean canReplaceBlock(BlockPos blockPos, World world) {
        IBlockState iBlockState = world.func_180495_p(blockPos);
        if (world.func_175625_s(blockPos) != null) {
            return false;
        }
        return iBlockState.func_185887_b(world, blockPos) != -1.0f;
    }

    public static EntityItem spawnItemInWorld(ItemStack itemStack, World world, BlockPos pos) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Don't spawn items in client world");
        }
        EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, itemStack);
        world.func_72838_d((Entity)entityItem);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        entityItem.field_70181_x = 0.0;
        return entityItem;
    }

    public static BlockPos getPosAboveSolidBlock(World world, BlockPos blockPos) {
        blockPos = blockPos.func_177981_b(world.func_72940_L());
        IBlockState blockState = world.func_180495_p(blockPos);
        while (blockState.func_185904_a().func_76222_j() || blockState.func_185904_a() == Material.field_151584_j) {
            blockPos = blockPos.func_177977_b();
            blockState = world.func_180495_p(blockPos);
        }
        blockPos = blockPos.func_177984_a();
        return blockPos;
    }

    public static Item registerItem(Item item, String mod, String ID, RegistryEvent.Register<Item> registryEvent) {
        ((Item)item.setRegistryName(mod, ID)).func_77655_b(ID);
        registryEvent.getRegistry().register((IForgeRegistryEntry)item);
        return item;
    }

    public static void registerInventoryModel(Item item, int metadata, String modid, String identifier) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(modid + ":" + identifier, "inventory"));
    }

    public static ArrayList<EnumFacing> getSideDirections(EnumFacing of) {
        ArrayList<EnumFacing> sidedirections = new ArrayList<EnumFacing>(5);
        switch (of) {
            case DOWN: {
                Collections.addAll(sidedirections, EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.NORTH);
                break;
            }
            case UP: {
                Collections.addAll(sidedirections, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.NORTH);
                break;
            }
            case EAST: {
                Collections.addAll(sidedirections, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.NORTH);
                break;
            }
            case WEST: {
                Collections.addAll(sidedirections, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.NORTH);
                break;
            }
            case SOUTH: {
                Collections.addAll(sidedirections, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST);
                break;
            }
            case NORTH: {
                Collections.addAll(sidedirections, EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST);
            }
        }
        return sidedirections;
    }

    @Deprecated
    public static EnumFacing getDirectionFromPositions(BlockPos one, BlockPos two) {
        for (EnumFacing facing : EnumFacing.values()) {
            if (!one.func_177972_a(facing).equals((Object)two)) continue;
            return facing;
        }
        return null;
    }

    public static boolean areItemTypesEqual(ItemStack one, ItemStack two) {
        return !one.func_190926_b() && !two.func_190926_b() && one.func_77973_b() == two.func_77973_b() && one.func_77952_i() == two.func_77952_i() && one.func_77973_b().getRegistryName().equals((Object)two.func_77973_b().getRegistryName()) && ItemStack.func_77970_a((ItemStack)one, (ItemStack)two);
    }

    public static boolean areItemsEqualInDictionary(ItemStack one, ItemStack two) {
        if (!one.func_190926_b() && !two.func_190926_b()) {
            int[] firstIDs = OreDictionary.getOreIDs((ItemStack)one);
            int[] secondIDs = OreDictionary.getOreIDs((ItemStack)two);
            for (int f : firstIDs) {
                for (int s : secondIDs) {
                    if (f != s) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void drawVerticalLine(int x, int startY, int endY, Color color) {
        Gui.func_73734_a((int)x, (int)startY, (int)(x + 1), (int)endY, (int)color.getRGB());
    }

    public static void drawHorizontalLine(int startX, int endX, int y, Color color) {
        Gui.func_73734_a((int)startX, (int)y, (int)(endX + 1), (int)(y + 1), (int)color.getRGB());
    }

    public static Object getKey(Map map, Object value) {
        Set keys = map.keySet();
        for (Object key : keys) {
            Object value2 = map.get(key);
            if (!value2.equals(value)) continue;
            return key;
        }
        return null;
    }

    public static int getFuelValue(@Nonnull ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public static EnumFacing isBlockDirectlyPowered(World worldIn, BlockPos pos) {
        for (EnumFacing from : EnumFacing.field_82609_l) {
            int p;
            BlockPos sidepos = pos.func_177972_a(from);
            IBlockState sidestate = worldIn.func_180495_p(sidepos);
            Block sideblock = sidestate.func_177230_c();
            if (!sideblock.func_149744_f(sidestate) || (p = sidestate.func_185911_a((IBlockAccess)worldIn, sidepos, from)) <= 0) continue;
            return from;
        }
        return null;
    }

    public static EnumFacing isPoweredExceptSide(EnumFacing side, World world, BlockPos position) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            int p;
            BlockPos sidepos;
            IBlockState sidestate;
            Block sideblock;
            if (side == facing || !(sideblock = (sidestate = world.func_180495_p(sidepos = position.func_177972_a(facing))).func_177230_c()).func_149744_f(sidestate) || (p = sidestate.func_185911_a((IBlockAccess)world, sidepos, facing)) <= 0) continue;
            return facing;
        }
        return null;
    }

    public static int calculateStringWidth(String string) {
        if (string != null) {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(string);
        }
        return 0;
    }

    public static int calculateLongestStringWidth(Collection<String> objects) {
        int width = 0;
        for (String s : objects) {
            int nextwidth = Tools.calculateStringWidth(s);
            if (nextwidth <= width) continue;
            width = nextwidth;
        }
        return width;
    }

    @Deprecated
    public static String getTranslation(String key) {
        return I18n.func_135052_a((String)key, (Object[])new Object[0]);
    }

    public static String getBlockName(IBlockState blockState) {
        if (blockState.func_177230_c() == Blocks.field_150350_a) {
            return "Air";
        }
        ItemStack itemStack = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_176201_c(blockState));
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() != Items.field_190931_a) {
            return itemStack.func_82833_r();
        }
        return blockState.func_177230_c().func_149732_F();
    }

    public static boolean removeHeldItem(EntityPlayer player, Item item) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == item) {
            player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
            return true;
        }
        if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() == item) {
            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            return true;
        }
        return false;
    }

    public static ItemStack createDisplayStack(IBlockState blockState) {
        ItemStack ds = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_180651_a(blockState));
        if (ds.func_190926_b()) {
            Item b = Item.func_150898_a((Block)blockState.func_177230_c());
            ds = b == Items.field_190931_a ? new ItemStack(blockState.func_177230_c().func_180660_a(blockState, randomgenerator, 0), blockState.func_177230_c().quantityDropped(blockState, 0, randomgenerator)) : new ItemStack(b);
        }
        if (ds.func_190926_b()) {
            throw new RuntimeException("The stack is empty - " + ds.func_77973_b() + " for blockstate " + blockState);
        }
        return ds;
    }

    public static ItemStack getStackFromBlockState(IBlockState blockState) {
        ItemStack ds = new ItemStack(blockState.func_177230_c(), 1, blockState.func_177230_c().func_180651_a(blockState));
        if (ds.func_190926_b()) {
            Item b = Item.func_150898_a((Block)blockState.func_177230_c());
            ds = b == Items.field_190931_a ? new ItemStack(blockState.func_177230_c().func_180660_a(blockState, randomgenerator, 0), blockState.func_177230_c().quantityDropped(blockState, 0, randomgenerator)) : new ItemStack(b);
        }
        return ds;
    }

    public static Field getSecureField(Class owner, int number) {
        Field[] fields = owner.getDeclaredFields();
        if (number < fields.length) {
            Field f = fields[number];
            if (f.getType() != owner.getEnclosingClass()) {
                f.setAccessible(true);
                return f;
            }
            return Tools.getSecureField(owner.getSuperclass(), number);
        }
        return null;
    }

    public static void sendMessageToPlayer(EntityPlayer player, String message) {
        player.func_145747_a((ITextComponent)new TextComponentString(message));
    }

    public static String interpolateString(String message, Object ... insertions) {
        for (Object ob : insertions) {
            message = StringUtils.replaceOnce((String)message, (String)replacementToken, (String)(ob == null ? "null" : ob.toString()));
        }
        return message;
    }

    public static void drawCenteredString(Object o, int X, int Y, Color color) {
        Tools.drawString(o, X - Tools.calculateStringWidth(o.toString()) / 2, Y, color);
    }

    public static void drawCenteredStringWithShadow(Object o, int X, int Y, Color color) {
        Tools.drawStringWithShadow(o, X - Tools.calculateStringWidth(o.toString()) / 2, Y, color);
    }

    public static void drawString(Object o, int X, int Y, Color color) {
        Minecraft.func_71410_x().field_71466_p.func_78276_b(o.toString(), X, Y, color.getRGB());
    }

    public static void drawStringWithShadow(Object o, int X, int Y, Color color) {
        Minecraft.func_71410_x().field_71466_p.func_175063_a(o.toString(), (float)X, (float)Y, color.getRGB());
    }

    public static boolean isObfuscatedEnvironment() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
    }

    public static Field getSecureField(Class owningClass, String field) {
        Field f = null;
        try {
            f = owningClass.getDeclaredField(field);
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            if (owningClass.getSuperclass() != null) {
                return Tools.getSecureField(owningClass.getSuperclass(), field);
            }
            System.err.println("Searched all super classes - field " + field + " not found");
        }
        return f;
    }

    public static void show(Object object) {
        System.out.println(object);
    }

    public static void show(Object[] objects) {
        System.out.println(Arrays.toString(objects));
    }

    public static Method getAnyMethod(Class<?> owner, String name, Class ... parameterTypes) {
        Method m = null;
        try {
            m = owner.getDeclaredMethod(name, parameterTypes);
            m.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Field getPublicField(Class owner, String fieldName) {
        Field f = null;
        try {
            f = owner.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        return f;
    }

    public static ItemStack tryExtractItems(IItemHandler itemHandler, ItemStack itemStack, boolean simulate) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack presentstack = itemHandler.getStackInSlot(slot);
            if (!Tools.areItemTypesEqual(itemStack, presentstack)) continue;
            return itemHandler.extractItem(slot, itemStack.func_190916_E(), simulate);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemHandler copyStacks(IItemHandler from) {
        ItemHandler itemHandler = new ItemHandler(from.getSlots());
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack stack = from.extractItem(i, 64, true);
            if (stack.func_190926_b() || Tools.tryInsertItem((IItemHandler)itemHandler, stack.func_77946_l())) continue;
            System.out.println("Couldn't insert " + stack);
            return itemHandler;
        }
        return itemHandler;
    }

    public static boolean tryInsertItem(IItemHandler iItemHandler, ItemStack itemStack) {
        if (!itemStack.func_190926_b()) {
            int i;
            int slots = iItemHandler.getSlots();
            for (i = 0; i < slots; ++i) {
                ItemStack result;
                ItemStack pressent = iItemHandler.getStackInSlot(i);
                if (!Tools.areItemTypesEqual(itemStack, pressent) || !(result = iItemHandler.insertItem(i, itemStack, true)).func_190926_b()) continue;
                iItemHandler.insertItem(i, itemStack, false);
                return true;
            }
            for (i = 0; i < slots; ++i) {
                ItemStack stack;
                ItemStack next = iItemHandler.getStackInSlot(i);
                if (!next.func_190926_b() || !(stack = iItemHandler.insertItem(i, itemStack, false)).func_190926_b()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canInsertItem(IItemHandler into, ItemStack stack) {
        int i;
        if (stack.func_190926_b()) {
            return false;
        }
        int slots = into.getSlots();
        for (i = 0; i < slots; ++i) {
            ItemStack result;
            ItemStack pressent = into.getStackInSlot(i);
            if (!Tools.areItemTypesEqual(stack, pressent) || !(result = into.insertItem(i, stack, true)).func_190926_b()) continue;
            return true;
        }
        for (i = 0; i < slots; ++i) {
            ItemStack rem;
            ItemStack next = into.getStackInSlot(i);
            if (!next.func_190926_b() || !(rem = into.insertItem(i, stack, true)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public static boolean isHoldingItem(Item item, EntityPlayer player) {
        return player.func_184592_cb().func_77973_b() == item || player.func_184614_ca().func_77973_b() == item;
    }

    public static int ticksToSeconds(int ticks) {
        return ticks / 20;
    }

    public static int ticksToMinutes(int ticks) {
        return Tools.ticksToSeconds(ticks) / 60;
    }

    public static int ticksToHours(int ticks) {
        return Tools.ticksToMinutes(ticks) / 60;
    }

    public static int secondsToTicks(int seconds) {
        return seconds * 20;
    }

    public static int minutesToTicks(int minutes) {
        return Tools.secondsToTicks(minutes * 60);
    }

    public static int hoursToTicks(int hours) {
        return Tools.minutesToTicks(hours * 60);
    }

    public static void addPotionEffectNoParticles(EntityLivingBase entityLivingBase, Potion potion, int duration, int strength) {
        entityLivingBase.func_70690_d(new PotionEffect(potion, duration, strength, false, false));
    }
}

