/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako;

import alexiy.satako.BlockData;
import alexiy.satako.Options;
import alexiy.satako.Tools;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathWorldListener;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.ServerWorldEventHandler;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.BlockSnapshot;

public final class Methods {
    public static void setBlocks(BlockPos from, BlockPos to, IBlockState state, World world) {
        Iterable poss = BlockPos.func_177980_a((BlockPos)from, (BlockPos)to);
        for (BlockPos blockPos : poss) {
            world.func_175656_a(blockPos, state);
        }
    }

    public static void drawSingleBlockSelection(EntityPlayer player, float partialTicks, IBlockState blockState, BlockPos pos) {
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        RenderGlobal.func_189697_a((AxisAlignedBB)blockState.func_185918_c(player.field_70170_p, pos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)0.58215684f, (float)0.294118f, (float)1.0f);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawBlockSelection(EntityPlayer player, float partialTicks, BlockPos start, BlockPos end) {
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(start, end);
        for (double X = axisAlignedBB.field_72340_a; X <= axisAlignedBB.field_72336_d; X += 1.0) {
            for (double Y = axisAlignedBB.field_72338_b; Y <= axisAlignedBB.field_72337_e; Y += 1.0) {
                for (double Z = axisAlignedBB.field_72339_c; Z <= axisAlignedBB.field_72334_f; Z += 1.0) {
                    BlockPos nextpos = new BlockPos(X, Y, Z);
                    IBlockState blockState = player.field_70170_p.func_180495_p(nextpos);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    GlStateManager.func_187441_d((float)2.0f);
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179132_a((boolean)false);
                    RenderGlobal.func_189697_a((AxisAlignedBB)blockState.func_185918_c(player.field_70170_p, nextpos).func_72314_b(0.001, 0.001, 0.001).func_72317_d(-d0, -d1, -d2), (float)1.0f, (float)0.58215684f, (float)0.294118f, (float)1.0f);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179084_k();
                }
            }
        }
    }

    public static void removeTileEntitySilently(BlockPos pos, World world) {
        TileEntity tileentity = world.func_175625_s(pos);
        try {
            Field processingLoadedTiles = Tools.isObfuscatedEnvironment() ? Tools.getSecureField(World.class, Options.processingLoadedTiles) : Tools.getSecureField(world.getClass(), "processingLoadedTiles");
            Field addedTileEntityList = Tools.isObfuscatedEnvironment() ? Tools.getSecureField(World.class, Options.addedTileEntityList) : Tools.getSecureField(world.getClass(), "addedTileEntityList");
            List atl = (List)addedTileEntityList.get(world);
            if (tileentity != null && processingLoadedTiles.getBoolean(world)) {
                tileentity.func_145843_s();
                atl.remove(tileentity);
                world.field_147482_g.remove(tileentity);
            } else {
                if (tileentity != null) {
                    atl.remove(tileentity);
                    world.field_147482_g.remove(tileentity);
                    world.field_175730_i.remove(tileentity);
                }
                Chunk chunk = world.func_175726_f(pos);
                chunk.func_177434_r().remove(pos);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static void setTileEntitySilently(World world, BlockData blockData) {
        BlockPos pos = blockData.position.func_185334_h();
        TileEntity tileEntityIn = blockData.tile;
        if (tileEntityIn != null) {
            try {
                Field processingLoadedTiles = Tools.isObfuscatedEnvironment() ? Tools.getSecureField(World.class, Options.processingLoadedTiles) : Tools.getSecureField(World.class, "processingLoadedTiles");
                boolean iplt = processingLoadedTiles.getBoolean(world);
                List addedTileEntityList = Tools.isObfuscatedEnvironment() ? (List)Tools.getSecureField(World.class, Options.addedTileEntityList).get(world) : (List)Tools.getSecureField(World.class, "addedTileEntityList").get(world);
                if (iplt) {
                    tileEntityIn.func_174878_a(pos);
                    if (tileEntityIn.func_145831_w() != world) {
                        tileEntityIn.func_145834_a(world);
                    }
                    addedTileEntityList.removeIf(tileentity -> tileentity.func_174877_v().equals((Object)pos));
                    addedTileEntityList.add(tileEntityIn);
                } else {
                    List dest = iplt ? addedTileEntityList : world.field_147482_g;
                    boolean flag = dest.add(tileEntityIn);
                    if (flag && tileEntityIn instanceof ITickable) {
                        world.field_175730_i.add(tileEntityIn);
                    }
                    Chunk chunk = world.func_175726_f(pos);
                    tileEntityIn.func_145834_a(world);
                    tileEntityIn.func_174878_a(pos);
                    chunk.func_177434_r().put(pos, tileEntityIn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean setBlockStateSilently(World world, BlockPos targetPos, IBlockState newState) {
        if (targetPos.func_177956_o() < 0 || targetPos.func_177956_o() > 255) {
            return false;
        }
        Chunk chunk = world.func_175726_f(targetPos);
        BlockSnapshot blockSnapshot = null;
        if (world.captureBlockSnapshots) {
            blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)targetPos, (int)2);
            world.capturedBlockSnapshots.add(blockSnapshot);
        }
        IBlockState oldState = world.func_180495_p(targetPos);
        int oldLight = oldState.getLightValue((IBlockAccess)world, targetPos);
        int oldOpacity = oldState.getLightOpacity((IBlockAccess)world, targetPos);
        int i = targetPos.func_177958_n() & 0xF;
        int j = targetPos.func_177956_o();
        int k = targetPos.func_177952_p() & 0xF;
        int l = k << 4 | i;
        int i1 = chunk.func_177445_q()[l];
        IBlockState iblockstate = chunk.func_177435_g(targetPos);
        Block block = newState.func_177230_c();
        ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[j >> 4];
        boolean flag = false;
        if (extendedblockstorage == Chunk.field_186036_a) {
            chunk.func_76587_i()[j >> 4] = extendedblockstorage = new ExtendedBlockStorage(j >> 4 << 4, !world.field_73011_w.func_177495_o());
            flag = j >= i1;
        }
        extendedblockstorage.func_177484_a(i, j & 0xF, k, newState);
        if (extendedblockstorage.func_177485_a(i, j & 0xF, k).func_177230_c() == block) {
            if (flag) {
                chunk.func_76603_b();
            }
            chunk.func_177427_f(true);
        }
        if (blockSnapshot != null) {
            world.capturedBlockSnapshots.remove(blockSnapshot);
        }
        if (newState.getLightOpacity((IBlockAccess)world, targetPos) != oldOpacity || newState.getLightValue((IBlockAccess)world, targetPos) != oldLight) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(targetPos);
            world.field_72984_F.func_76319_b();
        }
        if (blockSnapshot == null && chunk.func_150802_k()) {
            try {
                Field eventListeners = Tools.isObfuscatedEnvironment() ? Tools.getSecureField(World.class, Options.eventlisteners) : Tools.getSecureField(World.class, "eventListeners");
                List listeners = (List)eventListeners.get(world);
                for (IWorldEventListener listener : listeners) {
                    if (listener instanceof ServerWorldEventHandler) {
                        WorldServer server = (WorldServer)world;
                        PlayerChunkMap chunkMap = server.func_184164_w();
                        chunkMap.func_180244_a(targetPos);
                    }
                    if (!(listener instanceof PathWorldListener)) continue;
                    listener.func_184376_a(world, targetPos, iblockstate, newState, 2);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public static void drawStringWithBackground(Object obj, int x, int y, Color background, Color text) {
        String string = obj.toString();
        int width = Tools.calculateStringWidth(string);
        Gui.func_73734_a((int)x, (int)y, (int)(x + width + 3), (int)(y + 16), (int)background.getRGB());
        Minecraft.func_71410_x().field_71466_p.func_78276_b(string, x + 2, y + 4, text.getRGB());
    }

    public static void sendMessage(ICommandSender commandSender, String transkey) {
        commandSender.func_145747_a((ITextComponent)new TextComponentTranslation(transkey, new Object[0]));
    }

    public static void writeEnum(NBTTagCompound compound, String key, Enum enumerator) {
        compound.func_74774_a(key, (byte)enumerator.ordinal());
    }
}

