/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako;

import alexiy.satako.PrivateProperty;
import alexiy.satako.Tools;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemStackHandler;

public class ItemHandler
extends ItemStackHandler {
    private TileEntity owner;

    public ItemHandler(int size) {
        super(size);
    }

    public ItemHandler(int size, @Nullable TileEntity tileEntity) {
        this(size);
        this.owner = tileEntity;
        this.stacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public ItemHandler(NonNullList<ItemStack> itemStacks) {
        super(itemStacks);
    }

    public NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.func_190916_E() == stack.func_77976_d() && simulate) {
            return super.insertItem(slot, stack, true);
        }
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack present = this.getStackInSlot(i);
            if (present.func_190916_E() == present.func_77976_d() || !Tools.areItemTypesEqual(stack, present)) continue;
            return super.insertItem(i, stack, simulate);
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        PrivateProperty privateProperty;
        if (this.owner instanceof PrivateProperty && simulate && (privateProperty = (PrivateProperty)this.owner).isLocked()) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public TileEntity getOwner() {
        return this.owner;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.stacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected void onContentsChanged(int slot) {
        if (this.owner != null) {
            this.owner.func_70296_d();
        }
    }
}

