/*
 * Decompiled with CFR 0.152.
 */
package alexiy.satako;

import alexiy.satako.General;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public final class Functions {
    public static RayTraceResult performLookRayTrace(Entity entity, double length, World world, boolean stopOnLiquid, boolean skipBlocksWithoutCollision) {
        Vec3d eyePosition = entity.func_174824_e(1.0f);
        Vec3d entityLook = entity.func_70676_i(1.0f);
        Vec3d vec3d2 = eyePosition.func_72441_c(entityLook.field_72450_a * length, entityLook.field_72448_b * length, entityLook.field_72449_c * length);
        return world.func_147447_a(eyePosition, vec3d2, stopOnLiquid, skipBlocksWithoutCollision, true);
    }

    public static boolean isThereSpaceInAHandler(IItemHandler iItemHandler, boolean allowPartialStack) {
        for (int i = 0; i < iItemHandler.getSlots(); ++i) {
            ItemStack itemStack = iItemHandler.getStackInSlot(i);
            if (!itemStack.func_190926_b() && (!allowPartialStack || itemStack.func_190916_E() >= itemStack.func_77976_d())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDirectionalBlockPowered(EnumFacing blockDirection, BlockPos blockPosition, BlockPos pulsePosition, World world) {
        IBlockState backstate;
        EnumFacing back = blockDirection.func_176734_d();
        BlockPos backPosition = blockPosition.func_177972_a(back);
        return pulsePosition.equals((Object)backPosition) && (backstate = world.func_180495_p(backPosition)).func_185897_m() && world.func_175709_b(backPosition, back);
    }

    public static EnumFacing getPowerIncomingDirection(BlockPos pulsePosition, BlockPos target, Block notifier, World world) {
        IBlockState source = world.func_180495_p(pulsePosition);
        for (EnumFacing value : EnumFacing.values()) {
            IBlockState sidestate;
            BlockPos sidepos = target.func_177972_a(value);
            if (!sidepos.equals((Object)pulsePosition) || (sidestate = world.func_180495_p(sidepos)) != source || notifier != sidestate.func_177230_c() || sidestate.func_185911_a((IBlockAccess)world, sidepos, value) <= 0) continue;
            return value;
        }
        return null;
    }

    public static int getDirectPower(BlockPos source, BlockPos target, Block notifier, World world) {
        IBlockState sourceState = world.func_180495_p(source);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            IBlockState sidestate;
            BlockPos sidepos = target.func_177972_a(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.func_180495_p(sidepos)) != sourceState || notifier != sidestate.func_177230_c()) continue;
            return sidestate.func_185911_a((IBlockAccess)world, sidepos, enumFacing);
        }
        return 0;
    }

    public static boolean isNotifierAdjacent(BlockPos source, BlockPos target, Block notifier, World world) {
        IBlockState sourceState = world.func_180495_p(source);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            IBlockState sidestate;
            BlockPos sidepos = target.func_177972_a(enumFacing);
            if (!sidepos.equals((Object)source) || (sidestate = world.func_180495_p(sidepos)) != sourceState || notifier != sidestate.func_177230_c()) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getBlockPositionFrom(ChunkPos chunkPos) {
        return new BlockPos(chunkPos.field_77276_a << 4, 0, chunkPos.field_77275_b << 4);
    }

    public static float degreesToRadians(float degrees) {
        return (float)((double)degrees * Math.PI / 180.0);
    }

    public static float translateToXcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 0.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return -1.0f;
        }
        return MathHelper.func_76134_b((float)Functions.degreesToRadians(degrees));
    }

    public static float translateToZcoord(float degrees) {
        if (degrees == 90.0f || degrees == -90.0f) {
            return 1.0f;
        }
        if (degrees == 180.0f || degrees == -180.0f) {
            return 0.0f;
        }
        return MathHelper.func_76126_a((float)Functions.degreesToRadians(degrees));
    }

    public static boolean canGenerateWithoutCascade(World world, BlockPos blockPos) {
        ChunkPos chunkPos = new ChunkPos(blockPos);
        return world.func_190526_b(chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    public static BlockPos getTopBlockPosition(BlockPos pos, World world) {
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), world.func_72940_L() - 16, pos.func_177952_p());
        IBlockState nextstate = world.func_180495_p(blockpos);
        while (nextstate == Blocks.field_150350_a.func_176223_P()) {
            blockpos = blockpos.func_177977_b();
            nextstate = world.func_180495_p(blockpos);
        }
        return blockpos;
    }

    @Nullable
    public static Entity findEntityOnPath(World world, Entity entityPlayer) {
        Entity entity = null;
        Vec3d position = entityPlayer.func_174824_e(1.0f);
        Vec3d look = entityPlayer.func_70040_Z();
        AxisAlignedBB axisAlignedBB = new AxisAlignedBB(entityPlayer.func_180425_c()).func_186662_g(7.0);
        List entities = world.func_72839_b(entityPlayer, axisAlignedBB);
        int counter = 0;
        block0: while (true) {
            position = position.func_178787_e(look);
            for (Entity entity1 : entities) {
                if (!entity1.func_174813_aQ().func_72318_a(position)) continue;
                entity = entity1;
                break block0;
            }
            if (counter > 10) break;
            ++counter;
        }
        return entity;
    }

    public static boolean writeUUID(NBTTagCompound nbtTagCompound, String key, UUID uuid) {
        if (uuid != null && !uuid.equals(General.NULL_UUID)) {
            nbtTagCompound.func_186854_a(key, uuid);
            return true;
        }
        return false;
    }

    public static UUID readUUID(NBTTagCompound nbtTagCompound, String key) {
        UUID uuid = nbtTagCompound.func_186857_a(key);
        return uuid.equals(General.NULL_UUID) ? null : uuid;
    }
}

