/*
 * Decompiled with CFR 0.152.
 */
package cn.davidma.tinymobfarm.common.block;

import cn.davidma.tinymobfarm.common.TinyMobFarm;
import cn.davidma.tinymobfarm.common.tileentity.TileEntityMobFarm;
import cn.davidma.tinymobfarm.core.EnumMobFarm;
import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMobFarm
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    private EnumMobFarm mobFarmData;

    public BlockMobFarm(EnumMobFarm mobFarmData) {
        super(mobFarmData.getMaterial());
        this.func_149711_c(mobFarmData.getHardness());
        this.setHarvestLevel("pickaxe", 2);
        this.func_149752_b(300.0f);
        this.setRegistryName(mobFarmData.getRegistryName());
        this.func_149663_c(this.getRegistryName().toString());
        this.func_149647_a(TinyMobFarm.creativeTabTinyMobFarm);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.mobFarmData = mobFarmData;
    }

    public MessagePassingQueue.Consumer<List<String>> getTooltipBuilder() {
        return this.mobFarmData::addTooltip;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.setMobFarmData(this.mobFarmData);
            tileEntityMobFarm.updateRedstone();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && player instanceof EntityPlayerMP && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityMobFarm) {
            player.openGui((Object)"tinymobfarm", 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityMobFarm) {
            TileEntityMobFarm tileEntityMobFarm = (TileEntityMobFarm)tileEntity;
            tileEntityMobFarm.updateRedstone();
            tileEntityMobFarm.saveAndSync();
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        ItemStack lasso;
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileEntity instanceof TileEntityMobFarm && !(lasso = ((TileEntityMobFarm)tileEntity).getLasso()).func_190926_b()) {
            EntityItem drop = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.3, (double)pos.func_177952_p() + 0.5, lasso);
            world.func_72838_d((Entity)drop);
        }
        super.func_176208_a(world, pos, state, player);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMobFarm();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

