/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigList;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ConfigList<T extends ConfigValue>
extends ConfigValue
implements Iterable<T> {
    public static final String ID = "list";
    public static final Color4I COLOR = Color4I.rgb(16755273);
    public final List<T> list = new ArrayList<T>();
    public T type;

    public ConfigList(T t) {
        this.type = t;
    }

    @Override
    public String getID() {
        return ID;
    }

    public boolean canAdd(ConfigValue value) {
        return !value.isNull() && this.type.getID().equals(value.getID());
    }

    public ConfigList<T> add(ConfigValue v) {
        if (this.canAdd(v)) {
            this.writeToList();
            ConfigValue v1 = ((ConfigValue)this.type).copy();
            v1.setValueFromOtherValue(v);
            this.list.add(v1);
            this.readFromList();
        }
        return this;
    }

    @Override
    public void writeData(DataOut data) {
        this.writeToList();
        data.writeString(this.type.getID());
        ((ConfigValue)this.type).writeData(data);
        data.writeVarInt(this.list.size());
        for (ConfigValue s : this.list) {
            s.writeData(data);
        }
    }

    @Override
    public void readData(DataIn data) {
        this.list.clear();
        this.type = FTBLibAPI.createConfigValueFromId(data.readString());
        ((ConfigValue)this.type).readData(data);
        int s = data.readVarInt();
        while (--s >= 0) {
            ConfigValue v = ((ConfigValue)this.type).copy();
            v.readData(data);
            this.list.add(v);
        }
        this.readFromList();
    }

    @Override
    public String getString() {
        this.writeToList();
        StringBuilder builder = new StringBuilder("[");
        for (int i = 0; i < this.list.size(); ++i) {
            builder.append(((ConfigValue)this.list.get(i)).getString());
            if (i == this.list.size() - 1) continue;
            builder.append(',');
            builder.append(' ');
        }
        builder.append(']');
        return builder.toString();
    }

    @Override
    public boolean getBoolean() {
        return !this.list.isEmpty();
    }

    @Override
    public int getInt() {
        return this.list.size();
    }

    @Override
    public ConfigList<T> copy() {
        this.writeToList();
        ConfigList<ConfigValue> l = new ConfigList<ConfigValue>(((ConfigValue)this.type).copy());
        for (ConfigValue value : this.list) {
            l.list.add(value.copy());
        }
        return l;
    }

    @Override
    public Color4I getColor() {
        return COLOR;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        this.writeToList();
        NBTTagList l = new NBTTagList();
        for (ConfigValue value : this.list) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            value.writeToNBT(nbt1, "value");
            l.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a(key, (NBTBase)l);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.list.clear();
        NBTTagList l = nbt.func_150295_c(key, 10);
        for (int i = 0; i < l.func_74745_c(); ++i) {
            ConfigValue v = ((ConfigValue)this.type).copy();
            v.readFromNBT(l.func_150305_b(i), "value");
            this.list.add(v);
        }
        this.readFromList();
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> l) {
        l.add(TextFormatting.AQUA + "Type: " + TextFormatting.RESET + this.type.getID());
        if (this.list.isEmpty()) {
            l.add(TextFormatting.AQUA + "Value: []");
        } else {
            l.add(TextFormatting.AQUA + "Value: [");
            for (ConfigValue value : this.list) {
                l.add("  " + value.getStringForGUI().func_150254_d());
            }
            l.add(TextFormatting.AQUA + "]");
        }
        if (inst.getCanEdit() && inst.getDefaultValue() instanceof ConfigList) {
            ConfigList val = (ConfigList)inst.getDefaultValue();
            if (val.list.isEmpty()) {
                l.add(TextFormatting.AQUA + "Default: []");
            } else {
                l.add(TextFormatting.AQUA + "Default: [");
                for (ConfigValue value : val.list) {
                    l.add("  " + value.getStringForGUI().func_150254_d());
                }
                l.add(TextFormatting.AQUA + "]");
            }
        }
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        new GuiEditConfigList(inst, callback).openGui();
    }

    @Override
    public ITextComponent getStringForGUI() {
        return new TextComponentString("...");
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void setValueFromOtherValue(ConfigValue ovalue) {
        this.list.clear();
        if (ovalue instanceof ConfigList && !ovalue.isEmpty() && ((ConfigValue)this.type).equals(((ConfigList)ovalue).type)) {
            for (ConfigValue v : (ConfigList)ovalue) {
                ConfigValue value = ((ConfigValue)this.type).copy();
                value.setValueFromOtherValue(v);
                this.list.add(value);
            }
        }
        this.readFromList();
    }

    @Override
    public void setValueFromJson(JsonElement json) {
        this.list.clear();
        if (json.isJsonArray()) {
            for (JsonElement e : json.getAsJsonArray()) {
                ConfigValue value = ((ConfigValue)this.type).copy();
                value.setValueFromJson(e);
                this.list.add(value);
            }
        }
        this.readFromList();
    }

    public void readFromList() {
    }

    public void writeToList() {
    }

    public static class SimpleList<C extends ConfigValue, V>
    extends ConfigList<C> {
        public final Collection<V> collection;
        public final Function<V, C> toConfig;
        public final Function<C, V> fromConfig;

        public SimpleList(Collection<V> c, C type, Function<V, C> to, Function<C, V> from) {
            super(type);
            this.collection = c;
            this.toConfig = to;
            this.fromConfig = from;
        }

        @Override
        public void readFromList() {
            this.collection.clear();
            for (ConfigValue value : this.list) {
                this.collection.add(this.fromConfig.apply(value));
            }
        }

        @Override
        public void writeToList() {
            this.list.clear();
            for (V value : this.collection) {
                this.list.add(this.toConfig.apply(value));
            }
        }
    }
}

