/*
 * Decompiled with CFR 0.152.
 */
package terrapin47.bloodtinker.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bloodtinker")
public class ItemBloodyThornRing
extends Item
implements IBauble {
    protected static final UUID HEALTH_MODIFIER_1 = UUID.fromString("2b1b168e-e53b-11e8-9f32-f2801f1b9fd1");
    protected static final AttributeModifier HEALTH_MOD_1 = new AttributeModifier(HEALTH_MODIFIER_1, "BLOODYTHORNRING_HEALTH_MOD_1", 4.0, 0);
    protected static final UUID HEALTH_MODIFIER_2 = UUID.fromString("4dca1dba-5835-4216-8f56-0f6d9af37b36");
    protected static final AttributeModifier HEALTH_MOD_2 = new AttributeModifier(HEALTH_MODIFIER_2, "BLOODYTHORNRING_HEALTH_MOD_2", 4.0, 0);

    public ItemBloodyThornRing() {
        String name = "bloody_thorn_ring";
        this.setRegistryName(name);
        this.func_77655_b("bloodtinker." + name);
        this.func_77637_a(CreativeTabs.field_78037_j);
        this.func_77625_d(1);
    }

    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
        IAttributeInstance maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (!maxHealth.func_180374_a(HEALTH_MOD_1)) {
            maxHealth.func_111121_a(HEALTH_MOD_1);
        } else if (!maxHealth.func_180374_a(HEALTH_MOD_2)) {
            maxHealth.func_111121_a(HEALTH_MOD_2);
        }
    }

    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
        IAttributeInstance maxHealth = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
        if (player.func_110143_aJ() - 4.0f > 1.0f) {
            player.func_70606_j(player.func_110143_aJ() - 4.0f);
        } else {
            player.func_70606_j(1.0f);
        }
        player.func_70057_ab();
        if (maxHealth.func_180374_a(HEALTH_MOD_2)) {
            maxHealth.func_188479_b(HEALTH_MODIFIER_2);
        } else if (maxHealth.func_180374_a(HEALTH_MOD_1)) {
            maxHealth.func_188479_b(HEALTH_MODIFIER_1);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttacked(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (!ItemBloodyThornRing.isWearingThornRing(player)) {
            return;
        }
        DamageSource damageSource = event.getSource();
        if (damageSource.func_76364_f() != null && damageSource.func_76364_f() instanceof EntityLivingBase && !damageSource.func_76364_f().field_70128_L) {
            player.func_70606_j(player.func_110143_aJ() - 2.0f);
            Entity attackingEntity = damageSource.func_76346_g();
            EntityLivingBase thornTarget = (EntityLivingBase)attackingEntity;
            thornTarget.func_70097_a(DamageSource.func_92087_a((Entity)player), 4.0f);
        }
    }

    public static boolean isWearingThornRing(EntityPlayer player) {
        IBaublesItemHandler baubles = BaublesApi.getBaublesHandler((EntityPlayer)player);
        ItemStack slot1 = baubles.getStackInSlot(1);
        ItemStack slot2 = baubles.getStackInSlot(2);
        boolean inSlot1 = !slot1.func_190926_b() && slot1.func_77973_b() instanceof ItemBloodyThornRing;
        boolean inSlot2 = !slot2.func_190926_b() && slot2.func_77973_b() instanceof ItemBloodyThornRing;
        return inSlot1 || inSlot2;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public void register(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add("Increases max life and reflects a little damage... At the cost of pain.");
    }
}

