/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.lexicon.page;

import com.meteor.extrabotany.common.block.ModBlocks;
import com.meteor.extrabotany.common.crafting.recipe.RecipePedestal;
import com.meteor.extrabotany.common.item.ModItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.internal.IGuiLexiconEntry;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.lexicon.page.PageRecipe;

public class PagePedestalRecipe
extends PageRecipe {
    private static final ResourceLocation hammerOverlay = new ResourceLocation("extrabotany:textures/gui/pedestalOverlay.png");
    private final List<RecipePedestal> recipes;
    private int ticksElapsed = 0;
    private int recipeAt = 0;
    private final ItemStack renderStack;

    public PagePedestalRecipe(String unlocalizedName, List<RecipePedestal> recipes) {
        super(unlocalizedName);
        this.recipes = recipes;
        this.renderStack = new ItemStack(ModBlocks.pedestal);
        ItemNBTHelper.setBoolean((ItemStack)this.renderStack, (String)"RenderFull", (boolean)true);
    }

    public PagePedestalRecipe(String unlocalizedName, RecipePedestal recipe) {
        this(unlocalizedName, Collections.singletonList(recipe));
    }

    public void onPageAdded(LexiconEntry entry, int index) {
        for (RecipePedestal recipe : this.recipes) {
            LexiconRecipeMappings.map((ItemStack)recipe.getOutput(), (LexiconEntry)entry, (int)index);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        RecipePedestal recipe = this.recipes.get(this.recipeAt);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        this.renderItemAtGridPos(gui, 1, 1, recipe.getInput(), false);
        this.renderItemAtGridPos(gui, 2, 1, this.renderStack, false);
        this.renderItemAtGridPos(gui, 2, 2, new ItemStack(ModItems.hammermanasteel), false);
        this.renderItemAtGridPos(gui, 3, 1, recipe.getOutput(), false);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int x = gui.getLeft() + gui.getWidth() / 2 - 50;
        int y = gui.getTop() + 115;
        String dropString = I18n.func_135052_a((String)"extrabotanymisc.hammer", (Object[])new Object[0]) + " " + TextFormatting.BOLD + "(?)";
        boolean hoveringOverDrop = false;
        boolean unicode = font.func_82883_a();
        font.func_78264_a(true);
        int dw = font.func_78256_a(dropString);
        int dx = x + 35 - dw / 2;
        int dy = gui.getTop() + 30;
        if (mx > dx && mx <= dx + dw && my > dy && my <= dy + 10) {
            hoveringOverDrop = true;
        }
        font.func_78276_b(dropString, dx, dy, 0x77000000);
        font.func_78264_a(unicode);
        GlStateManager.func_179084_k();
        render.func_110577_a(hammerOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        GlStateManager.func_179084_k();
        if (hoveringOverDrop) {
            String tip0 = I18n.func_135052_a((String)"extrabotanymisc.hammerTip", (Object[])new Object[0]);
            RenderHelper.renderTooltip((int)mx, (int)my, Arrays.asList(tip0));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (GuiScreen.func_146272_n()) {
            return;
        }
        if (this.ticksElapsed % 20 == 0) {
            ++this.recipeAt;
            if (this.recipeAt == this.recipes.size()) {
                this.recipeAt = 0;
            }
        }
        ++this.ticksElapsed;
    }

    public List<ItemStack> getDisplayedRecipes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (RecipePedestal r : this.recipes) {
            list.add(r.getOutput());
        }
        return list;
    }
}

