/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.google.common.collect.Multimap;
import com.meteor.extrabotany.ExtraBotanyCreativeTab;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.client.render.IModelReg;
import com.meteor.extrabotany.common.core.network.ExtraBotanyNetwork;
import com.meteor.extrabotany.common.core.network.PacketLeftClick;
import com.meteor.extrabotany.common.entity.gaia.EntityVoidHerrscher;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemExcaliber
extends ItemSword
implements IRelic,
ILensEffect,
IModelReg,
IManaUsingItem {
    private static final String TAG_ATTACKER_USERNAME = "attackerUsername";
    private static final String TAG_HOME_ID = "homeID";
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";
    public static Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"B_EXCALIBER", (int)3, (int)-1, (float)6.2f, (float)6.0f, (int)40);
    private static final int MANA_PER_DAMAGE = 100;

    public ItemExcaliber() {
        this("excaliber");
    }

    public ItemExcaliber(String name) {
        super(toolMaterial);
        this.func_77637_a(ExtraBotanyCreativeTab.INSTANCE);
        this.setRegistryName(new ResourceLocation("extrabotany", name));
        this.func_77655_b(name);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            ExtraBotanyNetwork.sendToServer(new PacketLeftClick());
        }
    }

    @SubscribeEvent
    public void attackEntity(AttackEntityEvent evt) {
        if (!evt.getEntityPlayer().field_70170_p.field_72995_K) {
            this.trySpawnBurst(evt.getEntityPlayer());
        }
    }

    public void trySpawnBurst(EntityPlayer player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && player.func_184825_o(0.0f) == 1.0f) {
            EntityManaBurst burst = ItemExcaliber.getBurst(player, player.func_184614_ca());
            player.field_70170_p.func_72838_d((Entity)burst);
            ToolCommons.damageItem((ItemStack)player.func_184614_ca(), (int)1, (EntityLivingBase)player, (int)100);
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            this.updateRelic(stack, (EntityPlayer)entity);
        }
        if (!world.field_72995_K && entity instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)entity), (int)(this.getManaPerDamage() * 2), (boolean)true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public int getManaPerDamage() {
        return 100;
    }

    public boolean usesMana(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemExcaliber.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ItemExcaliber.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[0]), list);
            } else {
                ItemExcaliber.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{Minecraft.func_71410_x().field_71439_g.func_70005_c_()}), list);
            }
        } else {
            ItemExcaliber.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof EntityPlayerMP) {
                RelicBindTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemExcaliber.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap attrib = super.getAttributeModifiers(slot, stack);
        UUID uuid = new UUID((this.func_77658_a() + slot.toString()).hashCode(), 0L);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            attrib.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", 5.0, 0));
            attrib.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(uuid, "Weapon modifier", 0.3, 1));
        }
        return attrib;
    }

    public static EntityManaBurst getBurst(EntityPlayer player, ItemStack stack) {
        EntityManaBurst burst = new EntityManaBurst(player, EnumHand.MAIN_HAND);
        float motionModifier = 9.0f;
        burst.setColor(0xFFFF20);
        burst.setMana(100);
        burst.setStartingMana(100);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.setMotion(burst.field_70159_w * (double)motionModifier, burst.field_70181_x * (double)motionModifier, burst.field_70179_y * (double)motionModifier);
        ItemStack lens = stack.func_77946_l();
        ItemNBTHelper.setString((ItemStack)lens, (String)TAG_ATTACKER_USERNAME, (String)player.func_70005_c_());
        burst.setSourceLens(lens);
        return burst;
    }

    public void apply(ItemStack stack, BurstProperties props) {
    }

    public void updateBurst(IManaBurst burst, ItemStack stack) {
        Entity home;
        EntityThrowable entity = (EntityThrowable)burst;
        AxisAlignedBB axis = new AxisAlignedBB(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70142_S, entity.field_70137_T, entity.field_70136_U).func_186662_g(1.0);
        String attacker = ItemNBTHelper.getString((ItemStack)burst.getSourceLens(), (String)TAG_ATTACKER_USERNAME, (String)"");
        if (burst.getColor() == 0xFFAF00 || burst.getColor() == 16766720) {
            AxisAlignedBB axis1 = new AxisAlignedBB(entity.field_70165_t - 2.5, entity.field_70163_u - 2.5, entity.field_70161_v - 2.5, entity.field_70142_S + 2.5, entity.field_70137_T + 2.5, entity.field_70136_U + 2.5);
            if (burst.getColor() == 16766720) {
                axis1.func_186662_g(1.5);
            }
            List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis1);
            for (EntityLivingBase living : entities) {
                if (living instanceof EntityPlayer && (living.func_70005_c_().equals(attacker) || FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) && burst.getColor() == 0xFFAF00 || burst.getColor() == 16766720 && living instanceof EntityVoidHerrscher) continue;
                if (entity.field_70173_aa % 3 == 0) {
                    ExtraBotanyAPI.dealTrueDamage(living, burst.getColor() == 16766720 ? 1.8f : 2.2f);
                }
                if (living.field_70737_aN != 0) continue;
                living.func_70097_a(ItemRelic.damageSource(), burst.getColor() == 16766720 ? 7.0f : 8.0f);
            }
            return;
        }
        int homeID = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_HOME_ID, (int)-1);
        if (homeID == -1) {
            AxisAlignedBB axis1 = new AxisAlignedBB(entity.field_70165_t - 5.0, entity.field_70163_u - 5.0, entity.field_70161_v - 5.0, entity.field_70142_S + 5.0, entity.field_70137_T + 5.0, entity.field_70136_U + 5.0);
            List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis1);
            for (EntityLivingBase living : entities) {
                if (living instanceof EntityPlayer || !(living instanceof IMob) || living.field_70737_aN != 0) continue;
                homeID = living.func_145782_y();
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_HOME_ID, (int)homeID);
                break;
            }
        }
        List entities = entity.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        if (homeID != -1 && (home = entity.field_70170_p.func_73045_a(homeID)) != null) {
            Vector3 vecEntity = Vector3.fromEntityCenter((Entity)home);
            Vector3 vecThis = Vector3.fromEntityCenter((Entity)entity);
            Vector3 vecMotion = vecEntity.subtract(vecThis);
            Vector3 vecCurrentMotion = new Vector3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y);
            vecMotion.normalize().multiply(vecCurrentMotion.mag());
            burst.setMotion(vecMotion.x, vecMotion.y, vecMotion.z);
        }
        for (Object living : entities) {
            if (living instanceof EntityPlayer && (living.func_70005_c_().equals(attacker) || FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W()) || !living.func_70089_S()) continue;
            int cost = 33;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = BotaniaAPI.terrasteelToolMaterial.func_78000_c() + 3.0f;
            if (burst.isFake() || entity.field_70170_p.field_72995_K) continue;
            EntityPlayer player = ((EntityLivingBase)living).field_70170_p.func_72924_a(attacker);
            living.func_70097_a(player == null ? ItemRelic.damageSource() : DamageSource.func_76365_a((EntityPlayer)player), damage);
            ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)living, 3.0f);
            entity.func_70106_y();
            break;
        }
    }

    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    @Nonnull
    public String func_77657_g(@Nonnull ItemStack par1ItemStack) {
        return super.func_77657_g(par1ItemStack).replaceAll("item\\.", "item.extrabotany:");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public boolean collideBurst(IManaBurst burst, RayTraceResult arg1, boolean arg2, boolean dead, ItemStack arg4) {
        EntityThrowable entity = (EntityThrowable)burst;
        if (burst.getColor() == 0xFFAF00) {
            entity.func_130014_f_().func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        }
        return dead;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, @Nonnull ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.manaResource && par2ItemStack.func_77952_i() == 4 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }
}

