/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.relic;

import com.meteor.extrabotany.common.item.equipment.shield.ItemManasteelShield;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IPixieSpawner;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.advancements.RelicBindTrigger;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.relic.ItemRelic;

public class ItemAchilleshield
extends ItemManasteelShield
implements IRelic,
IPixieSpawner {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public ItemAchilleshield() {
        super(BotaniaAPI.terrasteelToolMaterial, "achilleshield");
    }

    public void onEnemyRammed(ItemStack stack, EntityLivingBase user, EntityLivingBase enemy, Vec3d rammingDir) {
        int knockback = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)stack);
        int power = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)stack);
        enemy.func_70653_a((Entity)user, 1.5f * (float)(1 + knockback), -rammingDir.field_72450_a, -rammingDir.field_72449_c);
        if (user instanceof EntityPlayer) {
            enemy.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)user)), 13.0f + 1.5f * (float)power);
        } else {
            enemy.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)user), 13.0f + 1.5f * (float)power);
        }
    }

    @Override
    public void onAttackBlocked(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        EntityDamageSourceIndirect indirectSource;
        if (source.func_76364_f() != null) {
            if (attacked instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)attacked;
                source.func_76364_f().func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
            } else {
                source.func_76364_f().func_70097_a(DamageSource.func_76358_a((EntityLivingBase)attacked), damage);
            }
        }
        if (source instanceof EntityDamageSourceIndirect && (indirectSource = (EntityDamageSourceIndirect)source).func_76364_f() != null && indirectSource.func_76346_g() != null && indirectSource.func_76364_f() instanceof IProjectile) {
            Vec3d dir = indirectSource.func_76364_f().func_174824_e(1.0f).func_178788_d(indirectSource.func_76346_g().func_174824_e(1.0f)).func_72432_b();
            ((IProjectile)indirectSource.func_76364_f()).func_70186_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c, 15.0f, 2.0f);
            if (indirectSource.func_76364_f() instanceof EntityArrow) {
                ((EntityArrow)indirectSource.func_76364_f()).field_70250_c = attacked;
            }
        }
        super.onAttackBlocked(stack, attacked, damage, source);
    }

    @Override
    public int getRepairSpeed() {
        return 5;
    }

    @Override
    public float getAttackerKnockbackMultiplier(ItemStack stack, EntityLivingBase attacked, float damage, DamageSource source) {
        return 1.5f;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        super.onUsingTick(stack, player, count);
        if ((player.field_70159_w > 0.0 || player.field_70179_y > 0.0) && player.func_184587_cr()) {
            Vec3d moveDir = new Vec3d(player.field_70159_w, player.field_70181_x, player.field_70179_y).func_72432_b();
            List targets = player.field_70170_p.func_175647_a(EntityLivingBase.class, player.func_174813_aQ().func_186662_g(1.0), e -> e != player);
            for (EntityLivingBase target : targets) {
                this.onEnemyRammed(stack, player, target, moveDir);
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.updateRelic(stack, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flags) {
        this.addBindInfo(tooltip, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        if (GuiScreen.func_146272_n()) {
            if (!this.hasUUID(stack)) {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicUnbound", (Object[])new Object[0]), list);
            } else if (!this.getSoulbindUUID(stack).equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.notYourSagittarius", (Object[])new Object[0]), list);
            } else {
                ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.relicSoulbound", (Object[])new Object[]{Minecraft.func_71410_x().field_71439_g.func_70005_c_()}), list);
            }
        } else {
            ItemAchilleshield.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.shiftinfo", (Object[])new Object[0]), list);
        }
    }

    public boolean shouldDamageWrongPlayer() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    private static void addStringToTooltip(String s, List<String> tooltip) {
        tooltip.add(s.replaceAll("&", "\u00a7"));
    }

    public void updateRelic(ItemStack stack, EntityPlayer player) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IRelic)) {
            return;
        }
        boolean rightPlayer = true;
        if (!this.hasUUID(stack)) {
            this.bindToUUID(player.func_110124_au(), stack);
            if (player instanceof EntityPlayerMP) {
                RelicBindTrigger.INSTANCE.trigger((EntityPlayerMP)player, stack);
            }
        } else if (!this.getSoulbindUUID(stack).equals(player.func_110124_au())) {
            rightPlayer = false;
        }
        if (!(rightPlayer || player.field_70173_aa % 10 != 0 || stack.func_77973_b() instanceof ItemRelic && !((ItemRelic)stack.func_77973_b()).shouldDamageWrongPlayer())) {
            player.func_70097_a(ItemAchilleshield.damageSource(), 2.0f);
        }
    }

    public boolean isRightPlayer(EntityPlayer player, ItemStack stack) {
        return this.hasUUID(stack) && this.getSoulbindUUID(stack).equals(player.func_110124_au());
    }

    public static DamageSource damageSource() {
        return new DamageSource("botania-relic");
    }

    public void bindToUUID(UUID uuid, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }

    public boolean hasUUID(ItemStack stack) {
        return this.getSoulbindUUID(stack) != null;
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public float getPixieChance(ItemStack arg0) {
        return 1.0f;
    }
}

