/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.lens;

import com.meteor.extrabotany.client.core.handler.ModelHandler;
import com.meteor.extrabotany.common.item.ItemMod;
import com.meteor.extrabotany.common.item.lens.LensCloud;
import com.meteor.extrabotany.common.item.lens.LensMana;
import com.meteor.extrabotany.common.item.lens.LensPotion;
import com.meteor.extrabotany.common.item.lens.LensPush;
import com.meteor.extrabotany.common.item.lens.LensSexpistol;
import com.meteor.extrabotany.common.item.lens.LensSmelt;
import com.meteor.extrabotany.common.lib.LibItemsName;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ICompositableLens;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.ILensControl;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.IManaSpreader;
import vazkii.botania.api.mana.ITinyPlanetExcempt;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.lens.Lens;

public class ItemLens
extends ItemMod
implements ILensControl,
ICompositableLens,
ITinyPlanetExcempt,
IBrewItem {
    public static final int SUBTYPES = 6;
    public static final int PUSH = 0;
    public static final int SMELT = 1;
    public static final int MANA = 2;
    public static final int POTION = 3;
    public static final int CLOUD = 4;
    public static final int SEXPISTOL = 5;
    private static final int PROP_NONE = 0;
    private static final int PROP_POWER = 1;
    private static final int PROP_ORIENTATION = 2;
    private static final int PROP_TOUCH = 4;
    private static final int PROP_INTERACTION = 8;
    private static final int PROP_DAMAGE = 16;
    private static final int PROP_CONTROL = 32;
    private static final int[] props = new int[6];
    private static final Lens[] lenses = new Lens[6];
    private static final Lens fallbackLens = new Lens();
    private static final String TAG_COLOR = "color";
    private static final String TAG_COMPOSITE_LENS = "compositeLens";
    private static final String TAG_BREW_KEY = "brewKey";

    public ItemLens() {
        super("lens");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 6; ++i) {
                stacks.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return "item." + LibItemsName.LENSES[Math.min(5, stack.func_77952_i())];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> stacks, ITooltipFlag flags) {
        Brew brew;
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            stacks.add(I18n.func_135052_a((String)"botaniamisc.color", (Object[])new Object[]{I18n.func_135052_a((String)("botania.color" + storedColor), (Object[])new Object[0])}));
        }
        if ((brew = this.getBrew(stack)) != null) {
            for (PotionEffect effect : brew.getPotionEffects(stack)) {
                TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
                stacks.add(format + I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + (effect.func_76458_c() == 0 ? "" : " " + I18n.func_135052_a((String)("botania.roman" + (effect.func_76458_c() + 1)), (Object[])new Object[0])) + TextFormatting.GRAY + (effect.func_188419_a().func_76403_b() ? "" : " (" + Potion.func_188410_a((PotionEffect)effect, (float)1.0f) + ")"));
            }
        }
    }

    private String getItemShortTermName(ItemStack stack) {
        return I18n.func_135052_a((String)(stack.func_77977_a().replaceAll("item.", "item.botania:") + ".short"), (Object[])new Object[0]);
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (compositeLens.func_190926_b()) {
            return super.func_77653_i(stack);
        }
        return String.format(I18n.func_135052_a((String)"item.botania:compositeLens.name", (Object[])new Object[]{this.getItemShortTermName(stack), this.getItemShortTermName(compositeLens)}), new Object[0]);
    }

    public void apply(ItemStack stack, BurstProperties props) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor != -1) {
            props.color = this.getLensColor(stack);
        }
        ItemLens.getLens(stack.func_77952_i()).apply(stack, props);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).apply(compositeLens, props);
        }
    }

    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        dead = ItemLens.getLens(stack.func_77952_i()).collideBurst(burst, entity, pos, isManaBlock, dead, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            dead = ((ILens)compositeLens.func_77973_b()).collideBurst(burst, pos, isManaBlock, dead, compositeLens);
        }
        return dead;
    }

    public void updateBurst(IManaBurst burst, ItemStack stack) {
        EntityThrowable entity = (EntityThrowable)burst;
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == 16 && entity.field_70170_p.field_72995_K) {
            burst.setColor(this.getLensColor(stack));
        }
        ItemLens.getLens(stack.func_77952_i()).updateBurst(burst, entity, stack);
        ItemStack compositeLens = this.getCompositeLens(stack);
        if (!compositeLens.func_190926_b() && compositeLens.func_77973_b() instanceof ILens) {
            ((ILens)compositeLens.func_77973_b()).updateBurst(burst, compositeLens);
        }
    }

    public int getLensColor(ItemStack stack) {
        int storedColor = ItemLens.getStoredColor(stack);
        if (storedColor == -1) {
            return 0xFFFFFF;
        }
        if (storedColor == 16) {
            return Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 1.0f, 1.0f);
        }
        return EnumDyeColor.func_176764_b((int)storedColor).func_193350_e();
    }

    public static int getStoredColor(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_COLOR, (int)-1);
    }

    public static void setLensColor(ItemStack stack, int color) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_COLOR, (int)color);
    }

    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public static void setProps(int lens, int props_) {
        ItemLens.props[lens] = props_;
    }

    public static void setLens(int index, Lens lens) {
        ItemLens.lenses[index] = lens;
    }

    public static boolean isBlacklisted(ItemStack lens1, ItemStack lens2) {
        ICompositableLens item1 = (ICompositableLens)lens1.func_77973_b();
        ICompositableLens item2 = (ICompositableLens)lens2.func_77973_b();
        return (item1.getProps(lens1) & item2.getProps(lens2)) != 0;
    }

    public static Lens getLens(int index) {
        if (index < 0 || index >= lenses.length) {
            return fallbackLens;
        }
        Lens lens = lenses[index];
        return lens == null ? fallbackLens : lens;
    }

    public boolean canCombineLenses(ItemStack sourceLens, ItemStack compositeLens) {
        ICompositableLens compositeItem;
        ICompositableLens sourceItem = (ICompositableLens)sourceLens.func_77973_b();
        if (sourceItem == (compositeItem = (ICompositableLens)compositeLens.func_77973_b()) && sourceLens.func_77952_i() == compositeLens.func_77952_i()) {
            return false;
        }
        if (!sourceItem.isCombinable(sourceLens) || !compositeItem.isCombinable(compositeLens)) {
            return false;
        }
        return !ItemLens.isBlacklisted(sourceLens, compositeLens);
    }

    public ItemStack getCompositeLens(ItemStack stack) {
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_COMPOSITE_LENS, (boolean)true);
        if (cmp == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(cmp);
    }

    public ItemStack setCompositeLens(ItemStack sourceLens, ItemStack compositeLens) {
        if (!compositeLens.func_190926_b()) {
            NBTTagCompound cmp = compositeLens.func_77955_b(new NBTTagCompound());
            ItemNBTHelper.setCompound((ItemStack)sourceLens, (String)TAG_COMPOSITE_LENS, (NBTTagCompound)cmp);
        }
        return sourceLens;
    }

    public int getManaToTransfer(IManaBurst burst, EntityThrowable entity, ItemStack stack, IManaReceiver receiver) {
        return ItemLens.getLens(stack.func_77952_i()).getManaToTransfer(burst, entity, stack, receiver);
    }

    public boolean shouldPull(ItemStack stack) {
        return true;
    }

    public boolean isControlLens(ItemStack stack) {
        return this.getProps(stack) != 0;
    }

    public boolean allowBurstShooting(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        return ItemLens.getLens(stack.func_77952_i()).allowBurstShooting(stack, spreader, redstone);
    }

    public void onControlledSpreaderTick(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        ItemLens.getLens(stack.func_77952_i()).onControlledSpreaderTick(stack, spreader, redstone);
    }

    public void onControlledSpreaderPulse(ItemStack stack, IManaSpreader spreader, boolean redstone) {
        ItemLens.getLens(stack.func_77952_i()).onControlledSpreaderPulse(stack, spreader, redstone);
    }

    public int getProps(ItemStack stack) {
        return props[stack.func_77952_i()];
    }

    public boolean isCombinable(ItemStack stack) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelHandler.registerItemMetas(this, LibItemsName.LENSES.length, i -> LibItemsName.LENSES[i]);
    }

    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"");
        return BotaniaAPI.getBrewFromKey((String)key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemLens.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)brew);
    }

    static {
        ItemLens.setProps(0, 0);
        ItemLens.setProps(1, 0);
        ItemLens.setProps(2, 0);
        ItemLens.setProps(3, 0);
        ItemLens.setProps(4, 0);
        ItemLens.setProps(5, 32);
        ItemLens.setLens(0, new LensPush());
        ItemLens.setLens(1, new LensSmelt());
        ItemLens.setLens(2, new LensMana());
        ItemLens.setLens(3, new LensPotion());
        ItemLens.setLens(4, new LensCloud());
        ItemLens.setLens(5, new LensSexpistol());
    }
}

