/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.tool;

import baubles.api.BaubleType;
import com.meteor.extrabotany.api.item.INatureOrb;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.entity.gaia.EntityGaiaIII;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBauble;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemNatureOrb
extends ItemBauble
implements INatureOrb,
IManaGivingItem {
    public static final String TAG_XP = "xp";
    public static int max = 500000;

    public ItemNatureOrb() {
        super("natureorb");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<String> stacks, ITooltipFlag flags) {
        ItemStack cosmetic;
        String key = RenderHelper.getKeyDisplayString((String)"Baubles Inventory");
        String i = I18n.func_135052_a((String)"extrabotany.natureorb", (Object[])new Object[0]);
        String ci = i + this.getXP(stack) + "/" + max;
        String a = I18n.func_135052_a((String)("extrabotany.natureorbeffect1" + (this.getXP(stack) > 100000)), (Object[])new Object[0]);
        String b = I18n.func_135052_a((String)("extrabotany.natureorbeffect2" + (this.getXP(stack) > 300000)), (Object[])new Object[0]);
        String c = I18n.func_135052_a((String)("extrabotany.natureorbeffect3" + (this.getXP(stack) > 400000)), (Object[])new Object[0]);
        if (key != null) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botania.baubletooltip", (Object[])new Object[]{key}), stacks);
        }
        if (!(cosmetic = this.getCosmeticItem(stack)).func_190926_b()) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasCosmetic", (Object[])new Object[]{cosmetic.func_82833_r()}), stacks);
        }
        if (this.hasPhantomInk(stack)) {
            this.addStringToTooltip(I18n.func_135052_a((String)"botaniamisc.hasPhantomInk", (Object[])new Object[0]), stacks);
        }
        this.addStringToTooltip(ci, stacks);
        this.addStringToTooltip(a, stacks);
        this.addStringToTooltip(b, stacks);
        this.addStringToTooltip(c, stacks);
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af() && this.getXP(player.func_184586_b(hand)) >= 100000 && ConfigHandler.GAIA_ENABLE) {
            return EntityGaiaIII.spawn(player, player.func_184586_b(hand), worldIn, pos, false) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            list.add((Object)new ItemStack((Item)this));
            ItemStack s = new ItemStack((Item)this);
            this.setXP(s, this.getMaxXP(s));
            list.add((Object)s);
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase entity) {
        super.onWornTick(stack, entity);
        if (entity instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)entity;
            if (this.getXP(stack) > 100000) {
                ManaItemHandler.dispatchManaExact((ItemStack)stack, (EntityPlayer)p, (int)1, (boolean)true);
            }
            if (this.getXP(stack) > 200000) {
                ManaItemHandler.dispatchManaExact((ItemStack)stack, (EntityPlayer)p, (int)1, (boolean)true);
            }
            if (this.getXP(stack) > 300000) {
                ManaItemHandler.dispatchManaExact((ItemStack)stack, (EntityPlayer)p, (int)1, (boolean)true);
                if (p.field_70173_aa % 60 == 0) {
                    p.func_70691_i(1.0f);
                }
            }
            if (this.getXP(stack) > 400000 && p.field_70173_aa % 40 == 0) {
                ItemNatureOrb.clearPotions(p);
                this.addXP(stack, -10);
            }
        }
    }

    public static void clearPotions(EntityPlayer player) {
        int posXInt = MathHelper.func_76141_d((float)player.func_180425_c().func_177958_n());
        int posZInt = MathHelper.func_76141_d((float)player.func_180425_c().func_177952_p());
        List<Potion> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_188419_a().func_76398_f()).filter(effect -> effect.func_188419_a().getCurativeItems().contains(Items.field_151117_aB)).map(PotionEffect::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_184589_d(potion);
            if (!player.func_130014_f_().field_72995_K) {
                ((WorldServer)player.func_130014_f_()).func_184164_w().func_187301_b(posXInt >> 4, posZInt >> 4).func_187267_a((Packet)new SPacketRemoveEntityEffect(player.func_145782_y(), potion));
            }
        });
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)((float)this.getXP(stack) / (float)this.getMaxXP(stack));
    }

    @Override
    public void addXP(ItemStack stack, int xp) {
        this.setXP(stack, Math.min(Math.max(this.getXP(stack) + xp, 0), this.getMaxXP(stack)));
    }

    @Override
    public void setXP(ItemStack stack, int xp) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_XP, (int)xp);
    }

    @Override
    public int getXP(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_XP, (int)0);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.CHARM;
    }

    @Override
    public int getMaxXP(ItemStack stack) {
        return max;
    }

    @Override
    public boolean canExportTo(ItemStack stack, ItemStack otherstack) {
        return true;
    }

    @Override
    public boolean canReceiveFrom(ItemStack stack, ItemStack otherstack) {
        return true;
    }
}

