/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.tool;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.core.handler.ModSounds;
import com.meteor.extrabotany.common.entity.EntityFlowerWeapon;
import com.meteor.extrabotany.common.item.ItemMod;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;

public class ItemKingGarden
extends ItemMod
implements IManaUsingItem {
    private static final String TAG_WEAPONS_SPAWNED = "weaponsSpawned";
    private static final String TAG_CHARGING = "charging";
    private static final String TAG_TYPE = "type";
    public static final int WEAPON_TYPES = 17;
    public static String[] typename = new String[]{"bloodyenchantress", "sunbless", "moonbless", "stardustlotus", "stonesia", "entropinnyum", "dreadthorn", "medumone", "thermalily", "tigerseye", "bellethorn", "heiseiDream", "annoyingflower", "manalinkium", "omniviolet", "bellflower", "tinkle"};

    public ItemKingGarden() {
        super("kinggarden");
        this.func_77625_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<String> stacks, ITooltipFlag flags) {
        String i = I18n.func_135052_a((String)"extrabotany.kinggarden", (Object[])new Object[0]);
        String ci = i + ItemKingGarden.getType(par1ItemStack).length;
        stacks.add(ci);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        ItemStack stack = player.func_184586_b(hand);
        ItemKingGarden.setCharging(stack, true);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int time) {
        int spawned = ItemKingGarden.getWeaponsSpawned(stack);
        if (spawned == ItemKingGarden.getType(stack).length) {
            ItemKingGarden.setCharging(stack, false);
            ItemKingGarden.setWeaponsSpawned(stack, 0);
        }
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase living, int count) {
        int spawned = ItemKingGarden.getWeaponsSpawned(stack);
        if (!(count == this.func_77626_a(stack) || spawned >= ItemKingGarden.getType(stack).length || living.field_70170_p.field_72995_K || living instanceof EntityPlayer && !ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)living), (int)100, (boolean)true))) {
            Vector3 look = new Vector3(living.func_70040_Z()).multiply(1.0, 0.0, 1.0);
            double playerRot = Math.toRadians(living.field_70177_z + 90.0f);
            if (look.x == 0.0 && look.z == 0.0) {
                look = new Vector3(Math.cos(playerRot), 0.0, Math.sin(playerRot));
            }
            look = look.normalize().multiply(-2.0);
            int div = spawned / 5;
            int mod = spawned % 5;
            Vector3 pl = look.add(Vector3.fromEntityCenter((Entity)living)).add(0.0, 1.6, (double)div * 0.1);
            Random rand = living.field_70170_p.field_73012_v;
            Vector3 axis = look.normalize().crossProduct(new Vector3(-1.0, 0.0, -1.0)).normalize();
            double rot = (double)mod * Math.PI / 4.0 - 1.5707963267948966;
            Vector3 axis1 = axis.multiply((double)div * 3.5 + 5.0).rotate(rot, look);
            if (axis1.y < 0.0) {
                axis1 = axis1.multiply(1.0, -1.0, 1.0);
            }
            Vector3 end = pl.add(axis1);
            EntityFlowerWeapon weapon = new EntityFlowerWeapon(living.field_70170_p, living);
            weapon.field_70165_t = end.x;
            weapon.field_70163_u = end.y;
            weapon.field_70161_v = end.z;
            weapon.field_70177_z = living.field_70177_z;
            weapon.setVariety(ItemKingGarden.getType(stack)[spawned]);
            weapon.setDelay(spawned);
            weapon.setRotation(MathHelper.func_76142_g((float)(-living.field_70177_z + 180.0f)));
            living.field_70170_p.func_72838_d((Entity)weapon);
            weapon.func_184185_a(vazkii.botania.common.core.handler.ModSounds.babylonSpawn, 1.0f, 1.0f + living.field_70170_p.field_73012_v.nextFloat() * 3.0f);
            if (weapon.getVariety() == 12) {
                weapon.func_184185_a(ModSounds.annoyingflower, 1.0f, 1.0f);
                if (living instanceof EntityPlayer) {
                    ExtraBotanyAPI.unlockAdvancement((EntityPlayer)living, "annoyingdog_summon");
                }
            }
            ItemKingGarden.setWeaponsSpawned(stack, spawned + 1);
        }
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public static boolean isCharging(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)TAG_CHARGING, (boolean)false);
    }

    public static int getWeaponsSpawned(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_WEAPONS_SPAWNED, (int)0);
    }

    public static int[] getType(ItemStack stack) {
        return ItemNBTHelper.getIntArray((ItemStack)stack, (String)TAG_TYPE);
    }

    public static void setCharging(ItemStack stack, boolean charging) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)TAG_CHARGING, (boolean)charging);
    }

    public static void setWeaponsSpawned(ItemStack stack, int count) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_WEAPONS_SPAWNED, (int)count);
    }

    public static void setType(ItemStack stack, int[] type) {
        ItemNBTHelper.setIntArray((ItemStack)stack, (String)TAG_TYPE, (int[])type);
    }

    public boolean usesMana(ItemStack stack) {
        return true;
    }
}

