/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import com.meteor.extrabotany.common.item.ModItems;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBauble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;

public class ItemSuperCrown
extends ItemBauble
implements ICosmeticBauble {
    private ItemStack renderStack;

    public ItemSuperCrown() {
        super("supercrown");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onEntityDamaged(LivingHurtEvent event) {
        if (!(event.getEntityLiving() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntityLiving();
        if (BaublesApi.isBaubleEquipped((EntityPlayer)player, (Item)ModItems.supercrown) != -1 && this.hasArmorSet(player)) {
            event.setAmount(Math.max(0.0f, event.getAmount() - 1.0f));
        }
    }

    public boolean hasArmorSet(EntityPlayer player) {
        return this.hasArmorSetItem(player, 0) && this.hasArmorSetItem(player, 1) && this.hasArmorSetItem(player, 2) && this.hasArmorSetItem(player, 3);
    }

    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        if (player == null || player.field_71071_by == null || player.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack stack = (ItemStack)player.field_71071_by.field_70460_b.get(3 - i);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ModItems.cosmhelm || stack.func_77973_b() == ModItems.coshelmrevealing || stack.func_77973_b() == ModItems.cmhelm || stack.func_77973_b() == ModItems.cmhelmrevealing;
            }
            case 1: {
                return stack.func_77973_b() == ModItems.cosmchest || stack.func_77973_b() == ModItems.cmchest || stack.func_77973_b() == ModItems.cmchestdarkened;
            }
            case 2: {
                return stack.func_77973_b() == ModItems.cosmleg || stack.func_77973_b() == ModItems.cmleg;
            }
            case 3: {
                return stack.func_77973_b() == ModItems.cosmboot || stack.func_77973_b() == ModItems.cmboot;
            }
        }
        return false;
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderStack = stack;
        if (type == IBaubleRender.RenderType.HEAD) {
            IBaubleRender.Helper.translateToHeadLevel((EntityPlayer)player);
            IBaubleRender.Helper.translateToFace();
            IBaubleRender.Helper.defaultTransforms();
            this.scale(1.4f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.65f, (float)0.3f);
            this.renderItem();
        }
    }

    public void scale(float f) {
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.renderStack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.HEAD;
    }
}

