/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meteor.extrabotany.common.core.handler.PlayerStatHandler;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBaubleRelic;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemGameWinner
extends ItemBaubleRelic {
    public static final String TAG_TRUEDAMAGETAKEN = "truedamagetaken";
    public static final String TAG_GAIADEFEAT = "gaiadefeat";
    public static final String TAG_VOIDHERRSCHERDEFEAT = "voidherrscherdefeat";

    public ItemGameWinner() {
        super("gamewinner");
    }

    @Override
    public void updateRelic(ItemStack stack, EntityPlayer player) {
        super.updateRelic(stack, player);
        if (this.getSoulbindUUID(stack) != null && player.field_70170_p.func_152378_a(this.getSoulbindUUID(stack)) != null) {
            EntityPlayer trueplayer = player.field_70170_p.func_152378_a(this.getSoulbindUUID(stack));
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_GAIADEFEAT, (int)PlayerStatHandler.getGaiaDefeat(trueplayer));
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_VOIDHERRSCHERDEFEAT, (int)PlayerStatHandler.getVoidHerrscherDefeat(trueplayer));
            ItemNBTHelper.setFloat((ItemStack)stack, (String)TAG_TRUEDAMAGETAKEN, (float)PlayerStatHandler.getTrueDamageTaken(trueplayer));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        super.addBindInfo(list, stack);
        this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.gaiadefeat", (Object[])new Object[0]) + ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_GAIADEFEAT, (int)0), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.voidherrscherdefeat", (Object[])new Object[0]) + ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_VOIDHERRSCHERDEFEAT, (int)0), list);
        this.addStringToTooltip(I18n.func_135052_a((String)"extrabotany.truedamagetaken", (Object[])new Object[0]) + ItemNBTHelper.getFloat((ItemStack)stack, (String)TAG_TRUEDAMAGETAKEN, (float)0.0f), list);
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.CHARM;
    }

    @Override
    public boolean shouldDamageWrongPlayer() {
        return false;
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111147_b((Multimap)attributes);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111148_a((Multimap)attributes);
        }
    }

    void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ItemGameWinner.getBaubleUUID(stack), "GameWinner", (double)(0.05f * (float)Math.min(10, ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_GAIADEFEAT, (int)0))), 1).func_111168_a(false));
        attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ItemGameWinner.getBaubleUUID(stack), "GameWinner", (double)(0.03f * (float)Math.min(10, ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_VOIDHERRSCHERDEFEAT, (int)0))), 1).func_111168_a(false));
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemGameWinner.getBaubleUUID(stack), "GameWinner", (double)(0.1f * (float)Math.min(10, ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_VOIDHERRSCHERDEFEAT, (int)0))), 1).func_111168_a(false));
        attributes.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ItemGameWinner.getBaubleUUID(stack), "GameWinner", (double)(0.03f * Math.min(20.0f, ItemNBTHelper.getFloat((ItemStack)stack, (String)TAG_TRUEDAMAGETAKEN, (float)0.0f) / 500.0f)), 1).func_111168_a(false));
    }
}

