/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBauble;
import com.meteor.extrabotany.common.lib.LibItemsName;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;

public class ItemCosmetic
extends ItemBauble
implements ICosmeticBauble {
    final int types = Variants.values().length;
    private ItemStack renderStack;

    public ItemCosmetic() {
        super("cosmetic");
        this.func_77627_a(true);
        this.renderStack = new ItemStack((Item)this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHiddenTooltip(ItemStack stack, World world, List<String> stacks, ITooltipFlag flags) {
        this.addStringToTooltip(I18n.func_135052_a((String)(stack.func_77952_i() == 8 || stack.func_77952_i() == 9 ? "Creative Only" : "botaniamisc.cosmeticBauble"), (Object[])new Object[0]), stacks);
        super.addHiddenTooltip(stack, world, stacks, flags);
    }

    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        this.renderStack = stack;
        if (stack.func_77952_i() >= this.types || stack.func_77952_i() < 0) {
            return;
        }
        Variants variant = Variants.values()[stack.func_77952_i()];
        if (type == IBaubleRender.RenderType.HEAD) {
            IBaubleRender.Helper.translateToHeadLevel((EntityPlayer)player);
            IBaubleRender.Helper.translateToFace();
            IBaubleRender.Helper.defaultTransforms();
            switch (variant) {
                case MASK: {
                    this.scale(1.25f);
                    GlStateManager.func_179109_b((float)0.0f, (float)0.025f, (float)0.01f);
                    this.renderItem();
                    break;
                }
                case PYLON: {
                    this.scale(0.8f);
                    GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.3f);
                    this.renderItem();
                    break;
                }
                case GOGGLE_JUNGLE: {
                    this.scale(1.15f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case GOGGLE_OCEAN: {
                    this.scale(1.15f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case GOGGLE_SNOWFIELD: {
                    this.scale(1.15f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case GOGGLE_STANDARD: {
                    this.scale(1.15f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case BLACKGLASSES: {
                    this.scale(1.15f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
                case QUESTION: {
                    this.scale(0.75f);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.3f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    this.renderItem();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.3f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)-0.65f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderItem();
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.2f, (float)0.3f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179109_b((float)0.65f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)-35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    this.renderItem();
                    GlStateManager.func_179121_F();
                    break;
                }
                case LEMON: {
                    this.scale(0.5f);
                    GlStateManager.func_179109_b((float)-0.4f, (float)-0.1f, (float)0.0f);
                    this.renderItem();
                    break;
                }
                case THUGLIFE: {
                    this.scale(1.35f);
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.065f, (float)0.045f);
                    this.renderItem();
                    break;
                }
            }
        }
    }

    public void scale(float f) {
        GlStateManager.func_179152_a((float)f, (float)f, (float)f);
    }

    public void renderItem() {
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_175599_af().func_181564_a(this.renderStack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    @Nonnull
    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + LibItemsName.COSMETIC_NAMES[Math.min(this.types - 1, par1ItemStack.func_77952_i())];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < LibItemsName.COSMETIC_NAMES.length; ++i) {
            if ("UNUSED".equals(LibItemsName.COSMETIC_NAMES[i])) continue;
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("extrabotany:" + LibItemsName.COSMETIC_NAMES[i], "inventory"));
        }
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.types; ++i) {
                stacks.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.HEAD;
    }

    public static enum Variants {
        MASK,
        PYLON,
        GOGGLE_JUNGLE,
        GOGGLE_OCEAN,
        GOGGLE_SNOWFIELD,
        GOGGLE_STANDARD,
        BLACKGLASSES,
        QUESTION,
        LEMON,
        THUGLIFE;

    }
}

