/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.bauble;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.meteor.extrabotany.client.core.handler.MiscellaneousIcons;
import com.meteor.extrabotany.common.item.equipment.bauble.ItemBaubleRelic;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBaubleRender;
import vazkii.botania.api.item.ICosmeticBauble;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.IconHelper;

public class ItemCoreGod
extends ItemBaubleRelic
implements IManaUsingItem,
ICosmeticBauble {
    public static final List<String> playersWithFlight = new ArrayList<String>();
    private static final int COST = 25;
    final int types = 2;

    public ItemCoreGod() {
        super("coregod");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.func_77627_a(true);
    }

    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> stacks) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < 2; ++i) {
                stacks.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Override
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        super.onWornTick(stack, player);
        if (player instanceof EntityPlayer) {
            EntityPlayer p = (EntityPlayer)player;
            boolean flying = p.field_71075_bZ.field_75100_b;
            if (flying && player instanceof EntityPlayerMP) {
                BotaniaAPI.internalHandler.sendBaubleUpdatePacket((EntityPlayer)((EntityPlayerMP)player), 5);
            }
        }
    }

    @SubscribeEvent
    public void updatePlayerFlyStatus(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            ItemStack core = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
            if (playersWithFlight.contains(ItemCoreGod.playerStr(player))) {
                if (this.shouldPlayerHaveFlight(player)) {
                    player.field_71075_bZ.field_75101_c = true;
                    if (player.field_71075_bZ.field_75100_b && !player.field_70170_p.field_72995_K) {
                        ManaItemHandler.requestManaExact((ItemStack)core, (EntityPlayer)player, (int)25, (boolean)true);
                    }
                } else {
                    if (!player.func_175149_v() && !player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75101_c = false;
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75102_a = false;
                    }
                    playersWithFlight.remove(ItemCoreGod.playerStr(player));
                }
            } else if (this.shouldPlayerHaveFlight(player)) {
                playersWithFlight.add(ItemCoreGod.playerStr(player));
                player.field_71075_bZ.field_75101_c = true;
            }
        }
    }

    @SubscribeEvent
    public void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        String username = event.player.func_146103_bH().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    public static String playerStr(EntityPlayer player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    private boolean shouldPlayerHaveFlight(EntityPlayer player) {
        ItemStack armor = BaublesApi.getBaublesHandler((EntityPlayer)player).getStackInSlot(5);
        if (!armor.func_190926_b() && armor.func_77973_b() == this) {
            return ManaItemHandler.requestManaExact((ItemStack)armor, (EntityPlayer)player, (int)25, (boolean)false);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IBaubleRender.RenderType type, float partialTicks) {
        if (type == IBaubleRender.RenderType.BODY) {
            TextureAtlasSprite icon = null;
            int meta = stack.func_77960_j();
            boolean flying = player.field_71075_bZ.field_75100_b;
            float rz = 120.0f;
            float rx = 20.0f + (float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)(flying ? 0.3f : 0.2f)) + 0.5) * (double)(flying ? 15.0f : 5.0f));
            float ry = 0.0f;
            float h = 0.2f;
            float i = 0.15f;
            float s = 1.0f;
            float x = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int light = 0xF000F0;
            int lightmapX = light % 65536;
            int lightmapY = light / 65536;
            float lbx = OpenGlHelper.lastBrightnessX;
            float lby = OpenGlHelper.lastBrightnessY;
            switch (meta) {
                case 0: {
                    rz = 170.0f;
                    h = 1.0f;
                    rx = 0.0f;
                    ry = -((float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)(flying ? 0.3f : 0.2f)) + (double)0.6f) * (double)(flying ? 15.0f : 5.0f)));
                    icon = MiscellaneousIcons.INSTANCE.godcoreIcons[0];
                    break;
                }
                case 1: {
                    rz = 180.0f;
                    h = 1.0f;
                    i = 0.22f;
                    x = 0.16f;
                    rx = 0.0f;
                    ry = -((float)((Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)0.2f) + (double)0.6f) * 3.0));
                    icon = MiscellaneousIcons.INSTANCE.volantoroIcon;
                }
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightmapX, (float)lightmapY);
            float mul = 1.6f;
            float f = icon.func_94209_e();
            float f1 = icon.func_94212_f();
            float f2 = icon.func_94206_g();
            float f3 = icon.func_94210_h();
            float sr = 1.0f / (s *= mul);
            IBaubleRender.Helper.rotateIfSneaking((EntityPlayer)player);
            GlStateManager.func_179109_b((float)0.0f, (float)h, (float)i);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-x), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            IconHelper.renderIconIn3D((Tessellator)Tessellator.func_178181_a(), (float)f1, (float)f2, (float)f, (float)f3, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.03125f);
            GlStateManager.func_179152_a((float)sr, (float)sr, (float)sr);
            GlStateManager.func_179114_b((float)(-ry), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-rx), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-rz), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)0.0f, (float)0.0f);
            switch (meta) {
                case 0: {
                    TextureAtlasSprite icon2 = MiscellaneousIcons.INSTANCE.godcoreIcons[1];
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                    IconHelper.renderIconIn3D((Tessellator)Tessellator.func_178181_a(), (float)icon2.func_94212_f(), (float)icon2.func_94206_g(), (float)icon2.func_94209_e(), (float)icon2.func_94210_h(), (int)icon2.func_94211_a(), (int)icon2.func_94216_b(), (float)0.03125f);
                    GlStateManager.func_179152_a((float)sr, (float)sr, (float)sr);
                    GlStateManager.func_179094_E();
                    TextureAtlasSprite icon3 = MiscellaneousIcons.INSTANCE.godcoreIcons[2];
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                    GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                    GlStateManager.func_179131_c((float)0.85f, (float)0.42f, (float)0.02f, (float)Math.max(0.2f, Math.min(1.0f, 0.45f + (float)Math.sin((double)((float)player.field_70173_aa + partialTicks) * (double)(flying ? 0.4f : 0.2f)))));
                    IconHelper.renderIconIn3D((Tessellator)Tessellator.func_178181_a(), (float)icon3.func_94212_f(), (float)icon3.func_94206_g(), (float)icon3.func_94209_e(), (float)icon3.func_94210_h(), (int)icon3.func_94211_a(), (int)icon3.func_94216_b(), (float)0.03125f);
                    GlStateManager.func_179152_a((float)sr, (float)sr, (float)sr);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179114_b((float)(-ry), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-rx), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-rz), (float)0.0f, (float)0.0f, (float)1.0f);
                    break;
                }
                case 1: {
                    GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)rz, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)rx, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)ry, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                    IconHelper.renderIconIn3D((Tessellator)Tessellator.func_178181_a(), (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.03125f);
                    GlStateManager.func_179152_a((float)sr, (float)sr, (float)sr);
                    GlStateManager.func_179114_b((float)(-ry), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-rx), (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)(-rz), (float)0.0f, (float)0.0f, (float)1.0f);
                }
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lbx, (float)lby);
        }
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111147_b((Multimap)attributes);
        }
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K) {
            HashMultimap attributes = HashMultimap.create();
            this.fillModifiers((Multimap<String, AttributeModifier>)attributes, stack);
            player.func_110140_aT().func_111148_a((Multimap)attributes);
        }
    }

    void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(ItemCoreGod.getBaubleUUID(stack), "Core God", 0.25, 1).func_111168_a(false));
        attributes.put((Object)SharedMonsterAttributes.field_193334_e.func_111108_a(), (Object)new AttributeModifier(ItemCoreGod.getBaubleUUID(stack), "Core God", (double)0.6f, 1).func_111168_a(false));
        attributes.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(ItemCoreGod.getBaubleUUID(stack), "Core God", 0.25, 1).func_111168_a(false));
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.BODY;
    }

    public boolean usesMana(ItemStack arg0) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < 2; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation("extrabotany:coregod", "inventory"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addBindInfo(List<String> list, ItemStack stack) {
        super.addBindInfo(list, stack);
        if (GuiScreen.func_146272_n()) {
            this.addStringToTooltip(I18n.func_135052_a((String)("extrabotany.wings" + stack.func_77952_i()), (Object[])new Object[0]), list);
        }
    }
}

