/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.equipment.armor.combatmaid;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.common.item.equipment.armor.combatmaid.ItemCombatMaidArmor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.IManaGivingItem;
import vazkii.botania.api.mana.ManaItemHandler;

public class ItemCombatMaidHelm
extends ItemCombatMaidArmor
implements IManaDiscountArmor,
IManaGivingItem {
    public List<DamageSource> source = new ArrayList<DamageSource>();

    public ItemCombatMaidHelm() {
        this("combatmaidhelm");
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.source.add(DamageSource.field_82728_o);
        this.source.add(DamageSource.field_76367_g);
        this.source.add(DamageSource.field_76369_e);
        this.source.add(DamageSource.field_76379_h);
        this.source.add(DamageSource.field_82729_p);
        this.source.add(DamageSource.field_76372_a);
        this.source.add(DamageSource.field_76371_c);
        this.source.add(DamageSource.field_76370_b);
        this.source.add(DamageSource.field_180137_b);
    }

    public ItemCombatMaidHelm(String name) {
        super(EntityEquipmentSlot.HEAD, name);
    }

    @Override
    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        super.onArmorTick(world, player, stack);
        if (this.hasArmorSet(player)) {
            ExtraBotanyAPI.unlockAdvancement(player, "armorset_combat");
            if (player.func_70996_bM() && player.field_70173_aa % 50 == 0) {
                player.func_70691_i(1.0f);
            }
            ManaItemHandler.dispatchManaExact((ItemStack)stack, (EntityPlayer)player, (int)1, (boolean)true);
            if (player.field_70173_aa % 40 == 0) {
                this.clearPotions(player);
            }
        }
    }

    private void clearPotions(EntityPlayer player) {
        int posXInt = MathHelper.func_76141_d((float)player.func_180425_c().func_177958_n());
        int posZInt = MathHelper.func_76141_d((float)player.func_180425_c().func_177952_p());
        List<Potion> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_188419_a().func_76398_f()).map(PotionEffect::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_184589_d(potion);
            if (!player.func_130014_f_().field_72995_K) {
                ((WorldServer)player.func_130014_f_()).func_184164_w().func_187301_b(posXInt >> 4, posZInt >> 4).func_187267_a((Packet)new SPacketRemoveEntityEffect(player.func_145782_y(), potion));
            }
        });
    }

    public float getDiscount(ItemStack stack, int slot, EntityPlayer player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.25f : 0.0f;
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingHurtEvent event) {
        EntityPlayer player;
        Entity attacker = event.getSource().func_76364_f();
        if (attacker instanceof EntityPlayer && this.hasArmorSet(player = (EntityPlayer)attacker)) {
            if (player.func_184614_ca() == ItemStack.field_190927_a) {
                event.setAmount(event.getAmount() + 10.0f);
            }
            if (player.func_70996_bM()) {
                player.func_70691_i(event.getAmount() / 8.0f);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingHurtEvent event) {
        EntityPlayer player;
        EntityLivingBase target = event.getEntityLiving();
        if (target instanceof EntityPlayer && this.hasArmorSet(player = (EntityPlayer)target) && this.source.contains(event.getSource())) {
            event.setAmount(0.0f);
        }
    }
}

