/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.brew;

import com.meteor.extrabotany.common.entity.EntitySplashGrenade;
import com.meteor.extrabotany.common.item.ItemMod;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemBrewSplashGrenade
extends ItemMod
implements IBrewItem {
    private static final String TAG_BREW_KEY = "brewKey";

    public ItemBrewSplashGrenade() {
        super("splashgrenade");
        this.func_77625_d(16);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack stack = player.func_184586_b(handIn);
        ItemStack itemstack1 = player.field_71075_bZ.field_75098_d ? stack.func_77946_l() : stack.func_77979_a(1);
        EntitySplashGrenade sg = new EntitySplashGrenade(world, (EntityLivingBase)player);
        sg.setItem(itemstack1);
        sg.shoot((Entity)player, player.field_70125_A, player.field_70177_z, -5.0f, 0.8f, 1.0f);
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)sg);
        }
        world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187827_fP, SoundCategory.PLAYERS, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        stack.func_190918_g(1);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack stack = new ItemStack((Item)this);
                ItemBrewSplashGrenade.setBrew(stack, s);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return String.format(I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")), I18n.func_74838_a((String)this.getBrew(stack).getUnlocalizedName(stack)), TextFormatting.BOLD + "" + TextFormatting.RESET);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
            list.add(format + net.minecraft.client.resources.I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + (effect.func_76458_c() == 0 ? "" : " " + net.minecraft.client.resources.I18n.func_135052_a((String)("botania.roman" + (effect.func_76458_c() + 1)), (Object[])new Object[0])) + TextFormatting.GRAY + (effect.func_188419_a().func_76403_b() ? "" : " (" + Potion.func_188410_a((PotionEffect)effect, (float)0.6f) + ")"));
        }
    }

    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"");
        return BotaniaAPI.getBrewFromKey((String)key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBrewSplashGrenade.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)brew);
    }
}

