/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.item.brew;

import com.meteor.extrabotany.common.item.ItemMod;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemBrewBase
extends ItemMod
implements IBrewItem {
    private static final String TAG_BREW_KEY = "brewKey";
    private static final String TAG_SWIGS_LEFT = "swigsLeft";
    private final int swigs;
    private final int drinkSpeed;
    private final ItemStack baseItem;
    private final float mutilplier;
    private final int amplifier;

    public ItemBrewBase(String name, int swigs, int drinkSpeed, int amplifier, float mutilplier, ItemStack baseItem) {
        super(name);
        this.swigs = swigs;
        this.drinkSpeed = drinkSpeed;
        this.baseItem = baseItem;
        this.mutilplier = mutilplier;
        this.amplifier = amplifier;
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("extrabotany", "swigs_taken"), (stack, world, entity) -> swigs - this.getSwigsLeft(stack));
    }

    public int func_77626_a(ItemStack stack) {
        return this.drinkSpeed;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, World world, EntityLivingBase living) {
        if (!world.field_72995_K) {
            for (PotionEffect effect : this.getBrew(stack).getPotionEffects(stack)) {
                PotionEffect newEffect = new PotionEffect(effect.func_188419_a(), (int)((float)effect.func_76459_b() * this.mutilplier), effect.func_76458_c() + this.amplifier, true, true);
                if (effect.func_188419_a().func_76403_b()) {
                    effect.func_188419_a().func_180793_a((Entity)living, (Entity)living, living, newEffect.func_76458_c(), 1.0);
                    continue;
                }
                living.func_70690_d(newEffect);
            }
            if (world.field_73012_v.nextBoolean()) {
                world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            int swigs = this.getSwigsLeft(stack);
            if (living instanceof EntityPlayer && !((EntityPlayer)living).field_71075_bZ.field_75098_d) {
                if (swigs == 1) {
                    if (!((EntityPlayer)living).field_71071_by.func_70441_a(this.baseItem.func_77946_l())) {
                        return this.baseItem.func_77946_l();
                    }
                    return ItemStack.field_190927_a;
                }
                this.setSwigsLeft(stack, swigs - 1);
            }
        }
        return stack;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (String s : BotaniaAPI.brewMap.keySet()) {
                ItemStack stack = new ItemStack((Item)this);
                ItemBrewBase.setBrew(stack, s);
                list.add((Object)stack);
            }
        }
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return String.format(I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name")), I18n.func_74838_a((String)this.getBrew(stack).getUnlocalizedName(stack)), "" + this.getSwigsLeft(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> list, ITooltipFlag flags) {
        Brew brew = this.getBrew(stack);
        for (PotionEffect effect : brew.getPotionEffects(stack)) {
            TextFormatting format = effect.func_188419_a().func_76398_f() ? TextFormatting.RED : TextFormatting.GRAY;
            list.add(format + net.minecraft.client.resources.I18n.func_135052_a((String)effect.func_76453_d(), (Object[])new Object[0]) + (effect.func_76458_c() == 0 ? "" : " " + net.minecraft.client.resources.I18n.func_135052_a((String)("botania.roman" + (effect.func_76458_c() + 1 + this.amplifier)), (Object[])new Object[0])) + TextFormatting.GRAY + (effect.func_188419_a().func_76403_b() ? "" : " (" + Potion.func_188410_a((PotionEffect)effect, (float)this.mutilplier) + ")"));
        }
    }

    public Brew getBrew(ItemStack stack) {
        String key = ItemNBTHelper.getString((ItemStack)stack, (String)TAG_BREW_KEY, (String)"");
        return BotaniaAPI.getBrewFromKey((String)key);
    }

    public static void setBrew(ItemStack stack, Brew brew) {
        ItemBrewBase.setBrew(stack, (brew == null ? BotaniaAPI.fallbackBrew : brew).getKey());
    }

    public static void setBrew(ItemStack stack, String brew) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_BREW_KEY, (String)brew);
    }

    public int getSwigsLeft(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SWIGS_LEFT, (int)this.swigs);
    }

    public void setSwigsLeft(ItemStack stack, int swigs) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SWIGS_LEFT, (int)swigs);
    }
}

