/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.judah;

import com.google.common.base.Optional;
import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import com.meteor.extrabotany.common.entity.judah.EntityJudahSpear;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import vazkii.botania.common.Botania;

public class EntityJudahOath
extends EntityThrowableCopy {
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_PLAYERLIST = "playerlist";
    private static final DataParameter<Integer> DAMAGE = EntityDataManager.func_187226_a(EntityJudahOath.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntityJudahOath.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TYPE = EntityDataManager.func_187226_a(EntityJudahOath.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> UUID = EntityDataManager.func_187226_a(EntityJudahOath.class, (DataSerializer)DataSerializers.field_187203_m);
    private Status preStatus;
    private Status status;
    private float range = 5.0f;
    private int fakecount = 0;
    private int count = 0;
    private int standby = 0;

    public EntityJudahOath(World worldIn) {
        super(worldIn);
    }

    public EntityJudahOath(World worldIn, EntityLivingBase thrower) {
        super(worldIn, thrower);
    }

    @Override
    public float getGravityVelocity() {
        return 0.15f;
    }

    @Override
    protected void func_70088_a() {
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TYPE, (Object)Type.JUDAH.ordinal());
        this.field_70180_af.func_187214_a(UUID, (Object)Optional.absent());
    }

    @Override
    public void func_70071_h_() {
        this.preStatus = this.status;
        if (this.status != Status.STANDBY) {
            this.field_70181_x *= (double)0.6f;
            this.status = this.getStatus();
        } else {
            this.field_70179_y = 0.0;
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
        }
        super.func_70071_h_();
        EntityLivingBase thrower = this.getThrower();
        if (!(this.field_70170_p.field_72995_K || thrower != null && thrower instanceof EntityPlayer && !thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        EntityPlayer player = (EntityPlayer)thrower;
        if (this.preStatus == Status.INAIR && this.status == Status.STANDBY) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.status == Status.STANDBY) {
            ++this.standby;
            if (this.range <= 13.0f) {
                this.range += 0.5f;
            }
            if (this.field_70173_aa % 4 == 0 && this.fakecount < 13) {
                EntityJudahSpear spear = new EntityJudahSpear(this.field_70170_p);
                spear.setUUID(this.func_110124_au());
                spear.setRotation(180.0f);
                spear.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                spear.setDamage(this.getDamage());
                spear.setFake(true);
                spear.setType(EntityJudahSpear.Type.byId(this.getType().ordinal()));
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)spear);
                }
                ++this.fakecount;
            }
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - (double)this.range + 2.5, this.field_70163_u - (double)this.range + 2.5, this.field_70161_v - (double)this.range + 2.5, this.field_70142_S + (double)this.range - 2.5, this.field_70137_T + (double)this.range - 2.5, this.field_70136_U + (double)this.range - 2.5);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
            double tx = this.field_70165_t;
            double ty = this.field_70163_u + 10.0;
            double tz = this.field_70161_v;
            for (EntityLivingBase living : entities) {
                if (living.func_110124_au() == this.getUUID() || living.field_70128_L || FMLCommonHandler.instance().getMinecraftServerInstance() != null && !FMLCommonHandler.instance().getMinecraftServerInstance().func_71219_W() && living instanceof EntityPlayer) continue;
                living.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 20, 9));
                tx = living.field_70165_t;
                ty = living.field_70163_u + 10.0;
                tz = living.field_70161_v;
            }
            if (this.standby > 20 && this.field_70173_aa % 10 == 0 && this.count < 13) {
                EntityJudahSpear spear = new EntityJudahSpear(this.field_70170_p);
                spear.setUUID(this.func_110124_au());
                spear.setRotation(0.0f);
                spear.func_70107_b(tx, ty, tz);
                spear.setDamage(this.getDamage());
                spear.setFake(false);
                spear.setType(EntityJudahSpear.Type.byId(this.getType().ordinal()));
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_72838_d((Entity)spear);
                }
                ++this.count;
            }
            for (int i = 0; i < 360; i += 2) {
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                switch (this.getType().metadata) {
                    case 0: {
                        r = 0.85f;
                        g = 0.6f;
                        b = 0.02f;
                        break;
                    }
                    case 1: {
                        r = 0.01f;
                        g = 0.6f;
                        b = 0.75f;
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                float rad = (float)i * (float)Math.PI / 180.0f;
                double x = this.field_70165_t + 0.5 - Math.cos(rad) * (double)this.range;
                double y = this.field_70163_u + 0.2;
                double z = this.field_70161_v + 0.5 - Math.sin(rad) * (double)this.range;
                Botania.proxy.sparkleFX(x, y, z, r, g, b, 1.0f, 3);
            }
        }
        if (this.standby > 140) {
            this.func_70106_y();
        }
    }

    private Status getStatus() {
        if (this.field_70170_p.func_180495_p(this.func_180425_c().func_177982_a(0, -1, 0)).func_177230_c() != Blocks.field_150350_a) {
            return Status.STANDBY;
        }
        return Status.INAIR;
    }

    @Override
    public void func_70014_b(NBTTagCompound cmp) {
        cmp.func_74778_a("Type", this.getType().getName());
        cmp.func_74768_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
        cmp.func_186854_a(TAG_PLAYERLIST, this.getUUID());
    }

    @Override
    public void func_70037_a(NBTTagCompound cmp) {
        if (cmp.func_150297_b("Type", 8)) {
            this.setType(Type.getTypeFromString(cmp.func_74779_i("Type")));
        }
        this.setDamage(cmp.func_74762_e(TAG_DAMAGE));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
        this.setUUID(cmp.func_186857_a(TAG_PLAYERLIST));
    }

    public UUID getUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(UUID)).orNull();
    }

    public void setUUID(UUID u) {
        this.field_70180_af.func_187227_b(UUID, (Object)Optional.fromNullable((Object)u));
    }

    public void setType(Type raftType) {
        this.field_70180_af.func_187227_b(TYPE, (Object)raftType.ordinal());
    }

    public Type getType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(TYPE));
    }

    public int getDamage() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE);
    }

    public void setDamage(int delay) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)delay);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    @Override
    protected void onImpact(RayTraceResult result) {
    }

    public static enum Type {
        JUDAH(0, "judah"),
        KIRA(1, "kira"),
        ETERNITY(2, "eternity"),
        SAKURA(2, "sakura");

        private final String name;
        private final int metadata;

        private Type(int metadataIn, String nameIn) {
            this.name = nameIn;
            this.metadata = metadataIn;
        }

        public String getName() {
            return this.name;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            if (id < 0 || id >= Type.values().length) {
                id = 0;
            }
            return Type.values()[id];
        }

        public static Type getTypeFromString(String nameIn) {
            for (int i = 0; i < Type.values().length; ++i) {
                if (!Type.values()[i].getName().equals(nameIn)) continue;
                return Type.values()[i];
            }
            return Type.values()[0];
        }
    }

    public static enum Status {
        INAIR,
        STANDBY;

    }
}

