/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.gaia;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityHonkaiBeam
extends Entity {
    private final double RADIUS = 20.0;
    public EntityLivingBase caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public boolean on = true;
    public EnumFacing blockSide = null;
    private static final DataParameter<Float> YAW = EntityDataManager.func_187226_a(EntityHonkaiBeam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntityHonkaiBeam.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntityHonkaiBeam.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_PLAYER = EntityDataManager.func_187226_a(EntityHonkaiBeam.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CASTER = EntityDataManager.func_187226_a(EntityHonkaiBeam.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityHonkaiBeam(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70158_ak = true;
    }

    public EntityHonkaiBeam(World world, EntityLivingBase caster, int duration) {
        this(world);
        this.caster = caster;
        this.setDuration(duration);
        this.calculateEndPos();
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public EntityHonkaiBeam(World world, EntityLivingBase caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.func_70107_b(x, y, z);
        this.calculateEndPos();
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            this.caster = (EntityLivingBase)this.field_70170_p.func_73045_a(this.getCasterID());
        }
        if (!this.field_70170_p.field_72995_K && this.getHasPlayer()) {
            this.updateWithPlayer();
        }
        if (!this.on) {
            this.func_70106_y();
        }
        AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 15.0, this.field_70163_u - 15.0, this.field_70161_v - 15.0, this.field_70142_S + 15.0, this.field_70137_T + 15.0, this.field_70136_U + 15.0);
        List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        if (this.caster == null) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 20) {
            this.calculateEndPos();
            List hit = this.raytraceEntities(this.field_70170_p, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(this.endPosX, this.endPosY, this.endPosZ), false, true, true).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(2);
            }
            if (!this.field_70170_p.field_72995_K) {
                for (EntityLivingBase target : hit) {
                    float damageFire = 3.0f;
                    float damageMob = 2.0f;
                    target.func_70097_a(DamageSource.field_76370_b, damageFire);
                    target.func_70097_a(DamageSource.field_76377_j, damageMob);
                }
            }
        }
        if (this.field_70173_aa - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.field_70146_Z.nextFloat() * 0.08f;
            float motionX = 0.1f * MathHelper.func_76134_b((float)yaw);
            float motionZ = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_175688_a(EnumParticleTypes.FLAME, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ, new int[0]);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.LAVA, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DURATION, (Object)0);
        this.func_184212_Q().func_187214_a(HAS_PLAYER, (Object)false);
        this.func_184212_Q().func_187214_a(CASTER, (Object)-1);
    }

    public float getYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.func_184212_Q().func_187227_b(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.func_184212_Q().func_187227_b(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(DURATION);
    }

    public void setDuration(int duration) {
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    public boolean getHasPlayer() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_PLAYER);
    }

    public void setHasPlayer(boolean player) {
        this.func_184212_Q().func_187227_b(HAS_PLAYER, (Object)player);
    }

    public int getCasterID() {
        return (Integer)this.func_184212_Q().func_187225_a(CASTER);
    }

    public void setCasterID(int id) {
        this.func_184212_Q().func_187227_b(CASTER, (Object)id);
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    private void calculateEndPos() {
        this.endPosX = this.field_70165_t + 20.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosZ = this.field_70161_v + 20.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
        this.endPosY = this.field_70163_u + 20.0 * Math.sin(this.getPitch());
    }

    public HitResult raytraceEntities(World world, Vec3d from, Vec3d to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        HitResult result = new HitResult();
        result.setBlockHit(world.func_147447_a(new Vec3d(from.field_72450_a, from.field_72448_b, from.field_72449_c), to, stopOnLiquid, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock));
        if (result.blockHit != null) {
            this.collidePosX = ((HitResult)result).blockHit.field_72307_f.field_72450_a;
            this.collidePosY = ((HitResult)result).blockHit.field_72307_f.field_72448_b;
            this.collidePosZ = ((HitResult)result).blockHit.field_72307_f.field_72449_c;
            this.blockSide = result.getBlockHit().field_178784_b;
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(Math.min(this.field_70165_t, this.collidePosX), Math.min(this.field_70163_u, this.collidePosY), Math.min(this.field_70161_v, this.collidePosZ), Math.max(this.field_70165_t, this.collidePosX), Math.max(this.field_70163_u, this.collidePosY), Math.max(this.field_70161_v, this.collidePosZ)).func_72314_b(1.0, 1.0, 1.0));
        for (EntityLivingBase entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.func_70111_Y() + 0.5f;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)pad, (double)pad, (double)pad);
            RayTraceResult hit = aabb.func_72327_a(from, to);
            if (aabb.func_72318_a(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (hit == null) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    private void updateWithPlayer() {
        this.setYaw((float)((double)(this.caster.field_70759_as + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.field_70125_A) * Math.PI / 180.0));
        this.func_70107_b(this.caster.field_70165_t, this.caster.field_70163_u + (double)1.2f, this.caster.field_70161_v);
    }

    public static class HitResult {
        private RayTraceResult blockHit;
        private List<EntityLivingBase> entities = new ArrayList<EntityLivingBase>();

        public RayTraceResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(RayTraceResult blockHit) {
            this.blockHit = blockHit;
        }

        public void addEntityHit(EntityLivingBase entity) {
            this.entities.add(entity);
        }
    }
}

