/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity.gaia;

import com.google.common.base.Optional;
import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.entity.IEntityWithShield;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.core.handler.ModSounds;
import com.meteor.extrabotany.common.core.handler.PlayerStatHandler;
import com.meteor.extrabotany.common.core.handler.StatHandler;
import com.meteor.extrabotany.common.entity.gaia.EntityDomain;
import com.meteor.extrabotany.common.entity.gaia.EntitySkullLandmine;
import com.meteor.extrabotany.common.entity.gaia.EntitySkullMinion;
import com.meteor.extrabotany.common.entity.gaia.EntitySkullMissile;
import com.meteor.extrabotany.common.entity.gaia.EntitySwordDomain;
import com.meteor.extrabotany.common.item.ItemMaterial;
import com.meteor.extrabotany.common.item.equipment.tool.ItemNatureOrb;
import io.netty.buffer.ByteBuf;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketRemoveEntityEffect;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBShaderObjects;
import vazkii.botania.api.boss.IBotaniaBoss;
import vazkii.botania.api.internal.ShaderCallback;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.lib.LibEntityNames;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntityGaiaIII
extends EntityLiving
implements IBotaniaBoss,
IEntityWithShield,
IEntityAdditionalSpawnData {
    public static final float ARENA_RANGE = 12.0f;
    private static final int SPAWN_TICKS = 160;
    private static final float MAX_HP = 450.0f;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final String TAG_RANKII = "rank2";
    private static final String TAG_RANKIII = "rank3";
    private static final String TAG_SHIELD = "shield";
    private static final String TAG_HARDCORE = "hardcore";
    private static final DataParameter<Integer> INVUL_TIME = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SHIELD = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PLAYER_COUNT = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<BlockPos> SOURCE = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Optional<UUID>> BOSSINFO_ID = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> RANKII = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> RANKIII = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HARDCORE = EntityDataManager.func_187226_a(EntityGaiaIII.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final BlockPos[] PYLON_LOCATIONS = new BlockPos[]{new BlockPos(4, 1, 4), new BlockPos(4, 1, -4), new BlockPos(-4, 1, 4), new BlockPos(-4, 1, -4)};
    private static final BlockPos[] MINION_LOCATIONS = new BlockPos[]{new BlockPos(3, 1, 3), new BlockPos(3, 1, -3), new BlockPos(-3, 1, 3), new BlockPos(-3, 1, -3)};
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer((ITextComponent)new TextComponentTranslation("entity." + LibEntityNames.DOPPLEGANGER_REGISTRY + ".name", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = BlockPos.field_177992_a;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int cd = 200;
    private int skillType = 0;
    public final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    public EntityPlayer trueKiller = null;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    @SideOnly(value=Side.CLIENT)
    private static Rectangle barRect;
    @SideOnly(value=Side.CLIENT)
    private static Rectangle hpBarRect;
    @SideOnly(value=Side.CLIENT)
    private ShaderCallback shaderCallback;

    public EntityGaiaIII(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70178_ae = true;
        this.field_70728_aV = 1225;
        if (world.field_72995_K) {
            Botania.proxy.addBoss((IBotaniaBoss)this);
        }
    }

    public void func_70606_j(float health) {
        super.func_70606_j(Math.max(health, this.func_110143_aJ() - 8.0f));
    }

    public void func_70636_d() {
        int count;
        int base;
        EntityPlayer player2;
        super.func_70636_d();
        Iterator<EntityPlayer> iterator = this.getPlayersAround().iterator();
        if (iterator.hasNext()) {
            player2 = iterator.next();
            this.func_70625_a((Entity)player2, 360.0f, 360.0f);
        }
        for (EntityPlayer player2 : this.getPlayersAround()) {
            if (this.playersWhoAttacked.contains(player2.func_110124_au())) continue;
            this.playersWhoAttacked.add(player2.func_110124_au());
        }
        if (!this.getRankII() && (this.func_110143_aJ() <= this.func_110138_aP() * 0.75f || this.getHardcore())) {
            this.setRankII(true);
            this.setShield(this.getHardcore() ? 10 : 5);
            this.spawnMinion();
            this.spawnDivineJudge();
            for (EntityPlayer player2 : this.getPlayersAround()) {
                if (this.field_70170_p.field_72995_K) continue;
                player2.func_145747_a(new TextComponentTranslation("extrabotanymisc.minionSpawn", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
            }
        }
        if (!this.getRankIII() && (this.func_110143_aJ() <= this.func_110138_aP() * 0.4f || this.getHardcore() && this.func_110143_aJ() <= this.func_110138_aP() * 0.6f)) {
            this.setRankIII(true);
            this.setShield(this.getHardcore() ? 10 : 5);
            this.spawnMinion();
            this.spawnDivineJudge();
            for (EntityPlayer player2 : this.getPlayersAround()) {
                if (this.field_70170_p.field_72995_K) continue;
                player2.func_145747_a(new TextComponentTranslation("extrabotanymisc.minionSpawn", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
            }
        }
        BlockPos source = this.getSource();
        if (this.field_70170_p.field_72995_K) {
            this.particles();
            player2 = Botania.proxy.getClientPlayer();
            if (this.getPlayersAround().contains(player2)) {
                player2.field_71075_bZ.field_75100_b = player2.field_71075_bZ.field_75100_b && player2.field_71075_bZ.field_75098_d;
            }
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.smashCheatyBlocks();
        List<EntityPlayer> players = this.getPlayersAround();
        if (players.isEmpty() && !this.field_70170_p.field_73010_i.isEmpty()) {
            this.func_70106_y();
        } else {
            for (EntityPlayer player3 : players) {
                this.clearPotions(player3);
                this.keepInsideArena(player3);
                player3.field_71075_bZ.field_75100_b = player3.field_71075_bZ.field_75100_b && player3.field_71075_bZ.field_75098_d;
            }
        }
        if (this.field_70128_L) {
            return;
        }
        if (this.getRankIII()) {
            if (this.field_70173_aa % 65 == 0) {
                for (int t = 0; t < 2; ++t) {
                    this.spawnMissile(2);
                }
                this.func_70691_i(1.0f);
            }
            if (this.cd == 0 && this.skillType == 1) {
                for (int t = 0; t < 17 + this.playerCount * 4; ++t) {
                    this.spawnMissile(3);
                }
                this.cd = 200;
                this.skillType = 2;
            }
        }
        if (this.getRankII() && this.field_70173_aa % 55 == 0) {
            this.spawnMissile(1);
        }
        if (this.field_70173_aa > 60 && this.field_70173_aa % 40 == 0) {
            this.spawnMissile(0);
            if (this.field_70170_p.field_73012_v.nextInt(10) < 4) {
                this.spawnMissile(1);
            }
        }
        int n = base = this.getHardcore() ? 10 + this.playerCount * 4 : 8 + this.playerCount * 3;
        int n2 = this.getRankIII() ? base + 9 : (count = this.getRankII() ? base + 5 : base);
        if (this.field_70173_aa > 200 && this.field_70173_aa % (this.getRankIII() ? 170 : (this.getRankII() ? 210 : 250)) == 0) {
            for (int i = 0; i < count; ++i) {
                int x = source.func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                int z = source.func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                int y = this.field_70170_p.func_175672_r(new BlockPos(x, -1, z)).func_177956_o();
                EntitySkullLandmine landmine = new EntitySkullLandmine(this.field_70170_p);
                if (i % 6 == 0) {
                    landmine.setType(2);
                }
                if (i % 5 == 0) {
                    landmine.setType(1);
                }
                landmine.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                landmine.summoner = this;
                this.field_70170_p.func_72838_d((Entity)landmine);
            }
        }
        if (ConfigHandler.GAIA_DISARM) {
            for (EntityPlayer player4 : this.getPlayersAround()) {
                if (player4.func_184812_l_()) continue;
                this.disarm(player4);
            }
        }
        if (this.cd > 0 && this.getRankII()) {
            --this.cd;
        }
        if (this.cd == 250 && this.skillType == 1) {
            for (EntityPlayer player5 : this.getPlayersAround()) {
                if (this.field_70170_p.field_72995_K) continue;
                player5.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaPreparing", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
            }
        }
        if (this.cd == 100 && this.skillType == 1) {
            for (EntityPlayer player6 : this.getPlayersAround()) {
                if (this.field_70170_p.field_72995_K) continue;
                player6.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (this.cd == 100 && this.skillType == 0) {
            for (EntityPlayer player7 : this.getPlayersAround()) {
                if (this.field_70170_p.field_72995_K) continue;
                player7.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning2", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        if (this.cd == 0 && !this.field_70170_p.field_72995_K && this.skillType == 0 && !this.getPlayersAround().isEmpty()) {
            EntityPlayer player8 = this.getPlayersAround().get(this.field_70170_p.field_73012_v.nextInt(this.getPlayersAround().size()));
            float amplifier = StatHandler.hasStat(player8, "gaia_defeat") ? 1.0f : 0.7f;
            player8.func_145747_a(new TextComponentTranslation("extrabotanymisc.gaiaWarning3", new Object[]{"Boss"}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            ExtraBotanyAPI.dealTrueDamage((EntityLivingBase)player8, (player8.func_110138_aP() * 0.2f + 6.0f) * amplifier);
            this.cd = 350;
            int n3 = this.skillType = this.getRankIII() ? 1 : this.field_70170_p.field_73012_v.nextInt(2);
        }
        if (this.cd == 0 && !this.field_70170_p.field_72995_K && this.skillType == 2) {
            if (ConfigHandler.GAIA_DIVINEJUDGE) {
                this.spawnDivineJudge();
            } else {
                this.spawnMinion();
            }
            this.cd = 300;
            int n4 = this.skillType = this.getRankIII() ? 3 : 0;
        }
        if (this.cd == 0 && !this.field_70170_p.field_72995_K && this.skillType == 3) {
            this.spawnMinion();
            this.cd = 340;
            this.skillType = this.field_70170_p.field_73012_v.nextInt(1);
        }
        if (this.tpDelay > 0) {
            --this.tpDelay;
        }
        if (this.tpDelay == 0 && this.func_110143_aJ() > 0.0f) {
            int tries;
            for (tries = 0; !this.teleportRandomly() && tries < 50; ++tries) {
            }
            if (tries >= 50) {
                this.teleportTo((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 1.6, (double)source.func_177952_p() + 0.5);
            }
            int n5 = this.tpDelay = this.getRankIII() ? 65 : 75;
        }
        if (this.field_70173_aa > 2600) {
            for (EntityPlayer p : this.getPlayersAround()) {
                ExtraBotanyAPI.unlockAdvancement(p, "music_all");
            }
        }
    }

    private void disarm(EntityPlayer player) {
        if (!this.match(player.func_184614_ca())) {
            EntityItem item = player.func_71040_bB(true);
            item.func_174867_a(90);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (this.match(stackAt)) continue;
            if (!stackAt.func_190926_b()) {
                EntityItem item = player.func_70099_a(stackAt, 0.0f);
                item.func_174867_a(90);
            }
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    private ItemStack parseItems(String str) {
        String[] entry = str.replace(" ", "").split(":");
        int meta = entry.length > 2 ? Integer.valueOf(entry[2]) : 0;
        ItemStack stack = new ItemStack((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(entry[0], entry[1])), 1, meta);
        return stack;
    }

    private boolean match(ItemStack stack) {
        String m = stack.func_77973_b().getRegistryName().toString();
        String[] whitelist = ConfigHandler.WHITELIST;
        if (whitelist.length > 0) {
            for (int i = 0; i < whitelist.length; ++i) {
                ItemStack compared = this.parseItems(whitelist[i]);
                compared.func_190920_e(stack.func_190916_E());
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)compared)) continue;
                return true;
            }
        }
        return m.indexOf("botania") != -1 || m.indexOf("extrabotany") != -1 || m.indexOf("minecraft") != -1;
    }

    private boolean match(Block block) {
        String m = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).toString();
        return m.indexOf("botania") != -1 || m.indexOf("extrabotany") != -1 || m.indexOf("minecraft") != -1;
    }

    private void spawnMinion() {
        for (int c = 0; c < 4; ++c) {
            EntitySkullMinion m = new EntitySkullMinion(this.field_70170_p);
            BlockPos p = this.getSource().func_177971_a((Vec3i)MINION_LOCATIONS[c]);
            m.func_70107_b(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
            m.setType(c);
            m.setShield(2);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)m);
        }
    }

    private void spawnDivineJudge() {
        for (int i = 0; i < 8; ++i) {
            float rad = (float)(i * 45) * (float)Math.PI / 180.0f;
            double x = (double)this.getSource().func_177958_n() + 0.5 - Math.cos(rad) * 5.0;
            double y = this.getSource().func_177956_o() + 7;
            double z = (double)this.getSource().func_177952_p() + 0.5 - Math.sin(rad) * 5.0;
            EntitySwordDomain domain = new EntitySwordDomain(this.func_130014_f_());
            EntityDomain d = new EntityDomain(this.func_130014_f_());
            d.func_70107_b(x, y - 0.5, z);
            this.func_130014_f_().func_72838_d((Entity)d);
            if (!this.playersWhoAttacked.isEmpty()) {
                domain.setUUID(this.playersWhoAttacked.get(Math.min(i, Math.max(0, this.playersWhoAttacked.size() - 1))));
            }
            domain.setType(i);
            domain.func_70107_b(x, y, z + 2.0);
            domain.setCount((int)(y - 2.0));
            domain.setSource(this.getSource());
            this.func_130014_f_().func_72838_d((Entity)domain);
        }
    }

    private void spawnMissile(int type) {
        EntitySkullMissile missile = new EntitySkullMissile((EntityLivingBase)this);
        missile.func_70107_b(this.field_70165_t + (Math.random() - 0.05), this.field_70163_u + 1.8 + (Math.random() - 0.05), this.field_70161_v + (Math.random() - 0.05));
        missile.setDamage(this.getHardcore() ? 6.0f : 4.0f);
        if (type > 0) {
            missile.setFire(true);
        }
        if (type > 1) {
            missile.setEffect(true);
            missile.setTrueDamage(this.getHardcore() ? 3.0f : 2.0f);
        }
        if (missile.findTarget()) {
            if (type > 2) {
                int x = this.getSource().func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                int z = this.getSource().func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                missile.func_70107_b(x, this.field_70163_u + 1.8 + (Math.random() - 0.05), z);
            }
            this.func_184185_a(vazkii.botania.common.core.handler.ModSounds.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72838_d((Entity)missile);
            }
        }
    }

    public static boolean spawn(EntityPlayer player, ItemStack stack, World world, BlockPos pos, boolean hard) {
        if (!(world.func_175625_s(pos) instanceof TileEntityBeacon) || !EntityGaiaIII.isTruePlayer((Entity)player) || EntityGaiaIII.getGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            if (!world.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.peacefulNoob", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        for (BlockPos coords : PYLON_LOCATIONS) {
            BlockPos pos_ = pos.func_177971_a((Vec3i)coords);
            IBlockState state = world.func_180495_p(pos_);
            if (state.func_177230_c() == ModBlocks.pylon && state.func_177229_b((IProperty)BotaniaStateProps.PYLON_VARIANT) == PylonVariant.GAIA) continue;
            if (!world.field_72995_K) {
                player.func_145747_a(new TextComponentTranslation("botaniamisc.needsCatalysts", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        List<BlockPos> invalidArenaBlocks = EntityGaiaIII.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.field_72995_K) {
                Botania.proxy.setWispFXDepthTest(false);
                for (BlockPos pos_ : invalidArenaBlocks) {
                    Botania.proxy.wispFX((double)pos_.func_177958_n() + 0.5, (double)pos_.func_177956_o() + 0.5, (double)pos_.func_177952_p() + 0.5, 1.0f, 0.2f, 0.2f, 0.5f, 0.0f, 8.0f);
                }
                Botania.proxy.setWispFXDepthTest(true);
            } else {
                PacketHandler.sendTo((EntityPlayerMP)((EntityPlayerMP)player), (IMessage)new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ARENA_INDICATOR, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new int[0]));
                player.func_145747_a(new TextComponentTranslation("botaniamisc.badArena", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return false;
        }
        if (!world.field_72995_K) {
            int playerCount;
            EntityGaiaIII e = new EntityGaiaIII(world);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5);
            e.source = pos;
            e.setShield(5);
            e.hardMode = hard;
            e.func_96094_a(player.func_146103_bH().getName());
            e.playerCount = playerCount = e.getPlayersAround().size();
            e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)(450.0f * (float)playerCount));
            e.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_188791_g).func_111128_a(15.0);
            e.func_184185_a(SoundEvents.field_187525_aO, 10.0f, 0.1f);
            e.func_180482_a(world.func_175649_E(new BlockPos((Entity)e)), null);
            world.func_72838_d((Entity)e);
            if (stack.func_77973_b() instanceof ItemNatureOrb) {
                ItemNatureOrb o = (ItemNatureOrb)stack.func_77973_b();
                o.addXP(stack, -100000);
            }
            if (stack.func_77973_b() instanceof ItemMaterial) {
                stack.func_190918_g(1);
            }
        }
        return true;
    }

    private static List<BlockPos> checkArena(World world, BlockPos beaconPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(12.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane((double)x, (double)z, (double)0.0, (double)0.0) > 12.0f) continue;
                for (int y = -1; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = beaconPos.func_177982_a(x, y, z);
                    boolean expectedBlockHere = y == -1;
                    boolean bl = isBlockHere = world.func_180495_p(pos).func_185890_d((IBlockAccess)world, pos) != null;
                    if (expectedBlockHere == isBlockHere) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 18.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVUL_TIME, (Object)0);
        this.field_70180_af.func_187214_a(RANKII, (Object)false);
        this.field_70180_af.func_187214_a(RANKIII, (Object)false);
        this.field_70180_af.func_187214_a(HARDCORE, (Object)false);
        this.field_70180_af.func_187214_a(SHIELD, (Object)0);
    }

    public boolean getHardcore() {
        return (Boolean)this.field_70180_af.func_187225_a(HARDCORE);
    }

    public void setHardcore(boolean b) {
        this.field_70180_af.func_187227_b(HARDCORE, (Object)b);
    }

    public boolean getRankII() {
        return (Boolean)this.field_70180_af.func_187225_a(RANKII);
    }

    public boolean getRankIII() {
        return (Boolean)this.field_70180_af.func_187225_a(RANKIII);
    }

    public void setRankII(boolean b) {
        this.field_70180_af.func_187227_b(RANKII, (Object)b);
    }

    public void setRankIII(boolean b) {
        this.field_70180_af.func_187227_b(RANKIII, (Object)b);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVUL_TIME);
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVUL_TIME, (Object)time);
    }

    public void func_70014_b(NBTTagCompound par1nbtTagCompound) {
        super.func_70014_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74768_a(TAG_INVUL_TIME, this.getInvulTime());
        par1nbtTagCompound.func_74757_a(TAG_AGGRO, this.aggro);
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_X, this.source.func_177958_n());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Y, this.source.func_177956_o());
        par1nbtTagCompound.func_74768_a(TAG_SOURCE_Z, this.source.func_177952_p());
        par1nbtTagCompound.func_74768_a(TAG_PLAYER_COUNT, this.playerCount);
        par1nbtTagCompound.func_74768_a(TAG_SHIELD, this.getShield());
        par1nbtTagCompound.func_74757_a(TAG_RANKII, this.getRankII());
        par1nbtTagCompound.func_74757_a(TAG_RANKIII, this.getRankIII());
    }

    public void func_70037_a(NBTTagCompound par1nbtTagCompound) {
        super.func_70037_a(par1nbtTagCompound);
        this.setInvulTime(par1nbtTagCompound.func_74762_e(TAG_INVUL_TIME));
        this.aggro = par1nbtTagCompound.func_74767_n(TAG_AGGRO);
        int x = par1nbtTagCompound.func_74762_e(TAG_SOURCE_X);
        int y = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Y);
        int z = par1nbtTagCompound.func_74762_e(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.playerCount = par1nbtTagCompound.func_74764_b(TAG_PLAYER_COUNT) ? par1nbtTagCompound.func_74762_e(TAG_PLAYER_COUNT) : 1;
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_96094_a(@Nonnull String name) {
        super.func_96094_a(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70691_i(float amount) {
        if (this.getInvulTime() == 0) {
            super.func_70691_i(amount);
        }
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float par2) {
        Entity e = source.func_76346_g();
        if (e instanceof EntityPlayer && EntityGaiaIII.isTruePlayer(e)) {
            EntityPlayer player = (EntityPlayer)e;
            if (!this.playersWhoAttacked.contains(player.func_110124_au())) {
                this.playersWhoAttacked.add(player.func_110124_au());
            }
            int cap = 20;
            if (this.getRankII()) {
                this.teleportRandomly();
            }
            return super.func_70097_a(source, Math.min((float)cap, par2));
        }
        return false;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void func_70665_d(@Nonnull DamageSource par1DamageSource, float par2) {
        super.func_70665_d(par1DamageSource, par2);
        Entity attacker = par1DamageSource.func_76364_f();
        if (attacker != null) {
            Vector3 thisVector = Vector3.fromEntityCenter((Entity)this);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)attacker);
            Vector3 motionVector = thisVector.subtract(playerVector).normalize().multiply(0.75);
            if (this.func_110143_aJ() > 0.0f) {
                this.field_70159_w = -motionVector.x;
                this.field_70181_x = 0.5;
                this.field_70179_y = -motionVector.z;
                this.tpDelay = 4;
            }
        }
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        super.func_70645_a(source);
        this.func_184185_a(SoundEvents.field_187539_bB, 20.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.field_70165_t, this.field_70163_u, this.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(450.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("extrabotany", "gaia_guardian_3");
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        if ("player".equals(source.func_76355_l()) && source.func_76346_g() instanceof EntityPlayer) {
            this.trueKiller = (EntityPlayer)source.func_76346_g();
        }
        super.func_82160_b(wasRecentlyHit, lootingModifier);
        for (EntityEquipmentSlot e : EntityEquipmentSlot.values()) {
            this.func_184201_a(e, ItemStack.field_190927_a);
        }
        for (UUID u : this.playersWhoAttacked) {
            EntityPlayer player = this.field_70170_p.func_152378_a(u);
            if (player == null) continue;
            EntityPlayer saveLastAttacker = this.field_70717_bb;
            double savePosX = this.field_70165_t;
            double savePosY = this.field_70163_u;
            double savePosZ = this.field_70161_v;
            this.field_70717_bb = player;
            this.field_70165_t = player.field_70165_t;
            this.field_70163_u = player.field_70163_u;
            this.field_70161_v = player.field_70161_v;
            super.func_184610_a(wasRecentlyHit, lootingModifier, DamageSource.func_76365_a((EntityPlayer)player));
            ExtraBotanyAPI.unlockAdvancement(player, "gaia_defeat");
            PlayerStatHandler.setGaiaDefeat(player, PlayerStatHandler.getGaiaDefeat(player) + 1);
            this.field_70165_t = savePosX;
            this.field_70163_u = savePosY;
            this.field_70161_v = savePosZ;
            this.field_70717_bb = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            Botania.proxy.removeBoss((IBotaniaBoss)this);
        }
        this.field_70170_p.func_175718_b(1010, this.getSource(), 0);
        super.func_70106_y();
    }

    private List<EntityPlayer> getPlayersAround() {
        BlockPos source = this.getSource();
        float range = 15.0f;
        return this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
    }

    private static int getGaiaGuardiansAround(World world, BlockPos source) {
        float range = 15.0f;
        List l = world.func_72872_a(EntityGaiaIII.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
        return l.size();
    }

    private void particles() {
        BlockPos source = this.getSource();
        for (int i = 0; i < 360; i += 8) {
            float r = 0.3f;
            float g = 0.0f;
            float b = 1.0f;
            float m = 0.15f;
            float mv = 0.35f;
            float rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)source.func_177958_n() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)source.func_177956_o() + 0.5;
            double z = (double)source.func_177952_p() + 0.5 - Math.sin(rad) * 12.0;
            Botania.proxy.wispFX(x, y, z, r, g, b, 0.5f, (float)(Math.random() - 0.5) * m, (float)(Math.random() - 0.5) * mv, (float)(Math.random() - 0.5) * m);
        }
        if (this.getInvulTime() > 10) {
            Vector3 pos = Vector3.fromEntityCenter((Entity)this).subtract(new Vector3(0.0, 0.2, 0.0));
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vector3 pylonPos = new Vector3((double)(source.func_177958_n() + arr.func_177958_n()), (double)(source.func_177956_o() + arr.func_177956_o()), (double)(source.func_177952_p() + arr.func_177952_p()));
                double worldTime = this.field_70173_aa;
                float rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vector3 partPos = new Vector3(xp, pylonPos.y, zp);
                Vector3 mot = pos.subtract(partPos).multiply(0.04);
                float r = 0.0f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.25f + (float)Math.random() * 0.1f, -0.075f - (float)Math.random() * 0.015f);
                Botania.proxy.wispFX(partPos.x, partPos.y, partPos.z, r, g, b, 0.4f, (float)mot.x, (float)mot.y, (float)mot.z);
            }
        }
    }

    private void smashCheatyBlocks() {
        int radius = 10;
        int posXInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177958_n());
        int posYInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177956_o());
        int posZInt = net.minecraft.util.math.MathHelper.func_76141_d((float)this.getSource().func_177952_p());
        for (int i = -radius; i < radius + 1; ++i) {
            for (int j = -radius; j < radius + 1; ++j) {
                for (int k = -radius; k < radius + 1; ++k) {
                    int xp = posXInt + i;
                    int yp = posYInt + j;
                    int zp = posZInt + k;
                    BlockPos posp = new BlockPos(xp, yp, zp);
                    if (!EntityGaiaIII.isCheatyBlock(this.field_70170_p, posp) && this.field_70170_p.func_180495_p(posp).func_185904_a() != Material.field_151586_h && this.field_70170_p.func_180495_p(posp).func_185904_a() != Material.field_151587_i && (!ConfigHandler.GAIA_SMASH || this.match(this.field_70170_p.func_180495_p(posp).func_177230_c()))) continue;
                    this.field_70170_p.func_175655_b(posp, true);
                }
            }
        }
    }

    private void clearPotions(EntityPlayer player) {
        int posXInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70165_t);
        int posZInt = net.minecraft.util.math.MathHelper.func_76128_c((double)this.field_70161_v);
        List<Potion> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_76459_b() < 160 && effect.func_82720_e() && !effect.func_188419_a().func_76398_f()).map(PotionEffect::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_184589_d(potion);
            ((WorldServer)this.field_70170_p).func_184164_w().func_187301_b(posXInt >> 4, posZInt >> 4).func_187267_a((Packet)new SPacketRemoveEntityEffect(player.func_145782_y(), potion));
        });
    }

    private void keepInsideArena(EntityPlayer player) {
        BlockPos source = this.getSource();
        if (MathHelper.pointDistanceSpace((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)((double)source.func_177958_n() + 0.5), (double)((double)source.func_177956_o() + 0.5), (double)((double)source.func_177952_p() + 0.5)) >= 12.0f) {
            Vector3 sourceVector = new Vector3((double)source.func_177958_n() + 0.5, (double)source.func_177956_o() + 0.5, (double)source.func_177952_p() + 0.5);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)player);
            Vector3 motion = sourceVector.subtract(playerVector).normalize();
            player.field_70159_w = motion.x;
            player.field_70181_x = 0.2;
            player.field_70179_y = motion.z;
            player.field_70133_I = true;
            player.func_70690_d(new PotionEffect(MobEffects.field_189112_A, 400, 4));
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_85033_bc() {
        if (this.getInvulTime() == 0) {
            super.func_85033_bc();
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.getInvulTime() == 0;
    }

    private static boolean isCheatyBlock(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return CHEATY_BLOCKS.contains(Block.field_149771_c.func_177774_c((Object)block));
    }

    private boolean teleportRandomly() {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        boolean flag = this.func_184595_k(x, y, z);
        if (flag) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_184595_k(double x, double y, double z) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                IBlockState iblockstate = world.func_180495_p(blockpos1);
                if (iblockstate.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                blockpos = blockpos1;
            }
            if (flag1) {
                BlockPos source;
                this.func_70634_a(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (world.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
                if (MathHelper.pointDistanceSpace((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)(source = this.getSource()).func_177958_n(), (double)source.func_177956_o(), (double)source.func_177952_p()) > 12.0f) {
                    flag = false;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        for (int j = 0; j < 128; ++j) {
            double d6 = (double)j / 127.0;
            float f = (random.nextFloat() - 0.5f) * 0.2f;
            float f1 = (random.nextFloat() - 0.5f) * 0.2f;
            float f2 = (random.nextFloat() - 0.5f) * 0.2f;
            double d3 = d0 + (this.field_70165_t - d0) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d4 = d1 + (this.field_70163_u - d1) * d6 + random.nextDouble() * (double)this.field_70131_O;
            double d5 = d2 + (this.field_70161_v - d2) * d6 + (random.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            world.func_175688_a(EnumParticleTypes.PORTAL, d3, d4, d5, (double)f, (double)f1, (double)f2, new int[0]);
        }
        Vec3d origPos = new Vec3d(d0, d1 + (double)(this.field_70131_O / 2.0f), d2);
        Vec3d newPos = new Vec3d(this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 2.0f), this.field_70161_v);
        if (origPos.func_72436_e(newPos) > 1.0) {
            for (EntityPlayer player : this.getPlayersAround()) {
                RayTraceResult rtr = player.func_174813_aQ().func_186662_g(0.25).func_72327_a(origPos, newPos);
                if (rtr == null) continue;
                player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 6.0f);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarTextureRect() {
        if (barRect == null) {
            barRect = new Rectangle(0, 0, 185, 15);
        }
        return barRect;
    }

    @SideOnly(value=Side.CLIENT)
    public Rectangle getBossBarHPTextureRect() {
        if (hpBarRect == null) {
            hpBarRect = new Rectangle(0, EntityGaiaIII.barRect.y + EntityGaiaIII.barRect.height, 181, 7);
        }
        return hpBarRect;
    }

    @SideOnly(value=Side.CLIENT)
    public int bossBarRenderCallback(ScaledResolution res, int x, int y) {
        GlStateManager.func_179094_E();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = new ItemStack(Items.field_151144_bL, 1, 3);
        mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74520_c();
        GlStateManager.func_179091_B();
        mc.func_175599_af().func_175042_a(stack, px, py);
        RenderHelper.func_74518_a();
        boolean unicode = mc.field_71466_p.func_82883_a();
        mc.field_71466_p.func_78264_a(true);
        mc.field_71466_p.func_175063_a("" + this.playerCount, (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        mc.field_71466_p.func_78264_a(unicode);
        GlStateManager.func_179121_F();
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBossBarShaderProgram(boolean background) {
        return background ? 0 : ShaderHelper.dopplegangerBar;
    }

    @SideOnly(value=Side.CLIENT)
    public ShaderCallback getBossBarShaderCallback(boolean background, int shader) {
        if (this.shaderCallback == null) {
            this.shaderCallback = shader1 -> {
                int grainIntensityUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"grainIntensity");
                int hpFractUniform = ARBShaderObjects.glGetUniformLocationARB((int)shader1, (CharSequence)"hpFract");
                float time = this.getInvulTime();
                float grainIntensity = time > 20.0f ? 1.0f : Math.max(0.0f, time / 20.0f);
                ARBShaderObjects.glUniform1fARB((int)grainIntensityUniform, (float)grainIntensity);
                ARBShaderObjects.glUniform1fARB((int)hpFractUniform, (float)(this.func_110143_aJ() / this.func_110138_aP()));
            };
        }
        return background ? null : this.shaderCallback;
    }

    @Override
    public int getShield() {
        return (Integer)this.field_70180_af.func_187225_a(SHIELD);
    }

    @Override
    public void setShield(int shield) {
        this.field_70180_af.func_187227_b(SHIELD, (Object)shield);
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.playerCount);
        buffer.writeBoolean(this.hardMode);
        buffer.writeLong(this.source.func_177986_g());
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @SideOnly(value=Side.CLIENT)
    public void readSpawnData(ByteBuf additionalData) {
        this.playerCount = additionalData.readInt();
        this.hardMode = additionalData.readBoolean();
        this.source = BlockPos.func_177969_a((long)additionalData.readLong());
        long msb = additionalData.readLong();
        long lsb = additionalData.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DopplegangerMusic(this));
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    @SideOnly(value=Side.CLIENT)
    private static class DopplegangerMusic
    extends MovingSound {
        private final EntityGaiaIII guardian;

        public DopplegangerMusic(EntityGaiaIII guardian) {
            super(ModSounds.gaiaMusic3, SoundCategory.RECORDS);
            this.guardian = guardian;
            this.field_147660_d = guardian.getSource().func_177958_n();
            this.field_147661_e = guardian.getSource().func_177956_o();
            this.field_147658_f = guardian.getSource().func_177952_p();
            this.field_147659_g = true;
        }

        public void func_73660_a() {
            if (!this.guardian.func_70089_S()) {
                this.field_147668_j = true;
            }
        }
    }
}

