/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.entity;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.entity.IBossProjectile;
import com.meteor.extrabotany.common.entity.EntityThrowableCopy;
import com.meteor.extrabotany.common.entity.gaia.EntityVoidHerrscher;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntitySubspaceSpear
extends EntityThrowableCopy
implements IBossProjectile {
    private static final String TAG_LIVE_TICKS = "liveTicks";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_DAMAGE = "damage";
    private static final String TAG_LIFE = "life";
    private static final String TAG_PITCH = "pitch";
    private static final DataParameter<Integer> LIVE_TICKS = EntityDataManager.func_187226_a(EntitySubspaceSpear.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROTATION = EntityDataManager.func_187226_a(EntitySubspaceSpear.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DAMAGE = EntityDataManager.func_187226_a(EntitySubspaceSpear.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(EntitySubspaceSpear.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntitySubspaceSpear.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntitySubspaceSpear(World worldIn) {
        super(worldIn);
    }

    public EntitySubspaceSpear(World world, EntityLivingBase thrower) {
        super(world, thrower);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_70105_a(0.0f, 0.0f);
        this.field_70180_af.func_187214_a(LIVE_TICKS, (Object)0);
        this.field_70180_af.func_187214_a(ROTATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DAMAGE, (Object)0);
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean func_180427_aV() {
        return true;
    }

    @Override
    protected float getGravityVelocity() {
        return 0.0f;
    }

    @Override
    public void func_70071_h_() {
        EntityLivingBase thrower = this.getThrower();
        if (!this.field_70170_p.field_72995_K && (thrower == null || thrower.field_70128_L)) {
            this.func_70106_y();
            return;
        }
        EntityLivingBase player = thrower;
        if (!this.field_70170_p.field_72995_K) {
            AxisAlignedBB axis = new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - (double)0.45f, this.field_70161_v - 1.0, this.field_70142_S + 1.0, this.field_70137_T + (double)0.45f, this.field_70136_U + 1.0);
            List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
            for (EntityLivingBase living : entities) {
                if (living == thrower || living.field_70737_aN != 0) continue;
                if (thrower instanceof EntityVoidHerrscher) {
                    ExtraBotanyAPI.dealBossDamage(living, this.getDamage());
                } else {
                    ExtraBotanyAPI.dealTrueDamage(living, this.getDamage());
                }
                EntitySubspaceSpear.attackedFrom(living, player, this.getDamage());
            }
        }
        super.func_70071_h_();
        if (this.field_70173_aa > this.getLife()) {
            this.func_70106_y();
        }
    }

    public static void attackedFrom(EntityLivingBase target, EntityLivingBase player, int i) {
        if (player != null && player instanceof EntityPlayer) {
            target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)player)), (float)i);
        } else {
            target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)player), (float)i);
        }
    }

    @Override
    protected void onImpact(RayTraceResult pos) {
        EntityLivingBase thrower = this.getThrower();
        if (pos.field_72308_g == null || pos.field_72308_g != thrower) {
            // empty if block
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound cmp) {
        super.func_70014_b(cmp);
        cmp.func_74768_a(TAG_LIVE_TICKS, this.getLiveTicks());
        cmp.func_74776_a(TAG_ROTATION, this.getRotation());
        cmp.func_74768_a(TAG_LIFE, this.getLife());
        cmp.func_74768_a(TAG_DAMAGE, this.getDamage());
        cmp.func_74776_a(TAG_PITCH, this.getPitch());
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound cmp) {
        super.func_70037_a(cmp);
        this.setLiveTicks(cmp.func_74762_e(TAG_LIVE_TICKS));
        this.setRotation(cmp.func_74760_g(TAG_ROTATION));
        this.setLife(cmp.func_74762_e(TAG_LIFE));
        this.setDamage(cmp.func_74762_e(TAG_DAMAGE));
        this.setPitch(cmp.func_74760_g(TAG_PITCH));
    }

    public int getLiveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(LIVE_TICKS);
    }

    public void setLiveTicks(int ticks) {
        this.field_70180_af.func_187227_b(LIVE_TICKS, (Object)ticks);
    }

    public float getRotation() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION)).floatValue();
    }

    public void setRotation(float rot) {
        this.field_70180_af.func_187227_b(ROTATION, (Object)Float.valueOf(rot));
    }

    public float getPitch() {
        return ((Float)this.field_70180_af.func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float rot) {
        this.field_70180_af.func_187227_b(PITCH, (Object)Float.valueOf(rot));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int delay) {
        this.field_70180_af.func_187227_b(LIFE, (Object)delay);
    }

    public int getDamage() {
        return (Integer)this.field_70180_af.func_187225_a(DAMAGE);
    }

    public void setDamage(int delay) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)delay);
    }

    @Override
    public boolean isBoss(Entity p) {
        return this.getLiveTicks() > 0;
    }
}

