/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.core.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PersistentVariableHandler {
    private static File cacheFile;
    private static final String TAG_CONTRIBUTORS = "contributors";
    private static final String TAG_CONTRIBUTORS_PREFIX = "contributor";
    private static final String TAG_CONTRIBUTORS_COUNT = "contributorCount";
    private static final String TAG_CONTRIBUTORSUUID = "contributorsuuid";
    private static final String TAG_CONTRIBUTORSUUID_PREFIX = "contributoruuid";
    private static final String TAG_CONTRIBUTORSUUID_COUNT = "contributoruuidCount";
    private static final String TAG_ADVERTISEMENT = "advertisements";
    private static final String TAG_ADVERTISEMENT_PREFIX = "ads";
    private static final String TAG_ADVERTISEMENT_COUNT = "advertisementCount";
    public static final List<String> contributors;
    public static final List<String> contributorsuuid;
    public static final List<String> advertisements;

    public static void save() throws IOException {
        NBTTagCompound cmp = new NBTTagCompound();
        try {
            String str;
            URL url = new URL("https://raw.githubusercontent.com/ExtraMeteorP/Extra-Botany/master/contributors.md");
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = r.readLine()) != null) {
                contributors.add(str);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int count = contributors.size();
        cmp.func_74768_a(TAG_CONTRIBUTORS_COUNT, count);
        NBTTagCompound contributorsCmp = new NBTTagCompound();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound contributorCmp = new NBTTagCompound();
            contributorCmp.func_74778_a(TAG_CONTRIBUTORS_PREFIX, contributors.get(i));
            contributorsCmp.func_74782_a(TAG_CONTRIBUTORS_PREFIX + i, (NBTBase)contributorCmp);
        }
        cmp.func_74782_a(TAG_CONTRIBUTORS, (NBTBase)contributorsCmp);
        try {
            String str;
            URL url = new URL("https://raw.githubusercontent.com/ExtraMeteorP/Extra-Botany/master/contributorsuuid.md");
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = r.readLine()) != null) {
                contributorsuuid.add(str);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int countuuid = contributorsuuid.size();
        cmp.func_74768_a(TAG_CONTRIBUTORSUUID_COUNT, countuuid);
        NBTTagCompound contributorsuuidCmp = new NBTTagCompound();
        for (int i = 0; i < countuuid; ++i) {
            NBTTagCompound contributoruuidCmp = new NBTTagCompound();
            contributoruuidCmp.func_74778_a(TAG_CONTRIBUTORSUUID_PREFIX, contributorsuuid.get(i));
            contributorsuuidCmp.func_74782_a(TAG_CONTRIBUTORSUUID_PREFIX + i, (NBTBase)contributoruuidCmp);
        }
        cmp.func_74782_a(TAG_CONTRIBUTORSUUID, (NBTBase)contributorsuuidCmp);
        try {
            String str;
            URL url = new URL("https://raw.githubusercontent.com/ExtraMeteorP/RandomThings/master/advertisement.md");
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((str = r.readLine()) != null) {
                advertisements.add(str);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int countads = advertisements.size();
        cmp.func_74768_a(TAG_ADVERTISEMENT_COUNT, countads);
        NBTTagCompound adsCmp = new NBTTagCompound();
        for (int i = 0; i < countads; ++i) {
            NBTTagCompound adCmp = new NBTTagCompound();
            adCmp.func_74778_a(TAG_ADVERTISEMENT_PREFIX, advertisements.get(i));
            adsCmp.func_74782_a(TAG_ADVERTISEMENT_PREFIX + i, (NBTBase)adCmp);
        }
        cmp.func_74782_a(TAG_ADVERTISEMENT, (NBTBase)adsCmp);
    }

    public static void load() throws IOException {
        NBTTagCompound cmp = new NBTTagCompound();
        int count = cmp.func_74762_e(TAG_CONTRIBUTORS_COUNT);
        contributors.clear();
        if (count > 0) {
            NBTTagCompound contributorsCmp = cmp.func_74775_l(TAG_CONTRIBUTORS);
            for (int i = 0; i < count; ++i) {
                NBTTagCompound contributorCmp = contributorsCmp.func_74775_l(TAG_CONTRIBUTORS_PREFIX + i);
                if (contributorCmp.func_74779_i(TAG_CONTRIBUTORS_PREFIX) == null) continue;
                contributors.add(contributorCmp.func_74779_i(TAG_CONTRIBUTORS_PREFIX));
            }
        }
        int countuuid = cmp.func_74762_e(TAG_CONTRIBUTORSUUID_COUNT);
        contributorsuuid.clear();
        if (countuuid > 0) {
            NBTTagCompound contributorsuuidCmp = cmp.func_74775_l(TAG_CONTRIBUTORSUUID);
            for (int i = 0; i < countuuid; ++i) {
                NBTTagCompound contributoruuidCmp = contributorsuuidCmp.func_74775_l(TAG_CONTRIBUTORSUUID_PREFIX + i);
                if (contributoruuidCmp.func_74779_i(TAG_CONTRIBUTORSUUID_PREFIX) == null) continue;
                contributorsuuid.add(contributoruuidCmp.func_74779_i(TAG_CONTRIBUTORSUUID_PREFIX));
            }
        }
        int countads = cmp.func_74762_e(TAG_ADVERTISEMENT_COUNT);
        advertisements.clear();
        if (countads > 0) {
            NBTTagCompound adsCmp = cmp.func_74775_l(TAG_ADVERTISEMENT);
            for (int i = 0; i < countads; ++i) {
                NBTTagCompound adCmp = adsCmp.func_74775_l(TAG_ADVERTISEMENT_PREFIX + i);
                if (adCmp.func_74779_i(TAG_ADVERTISEMENT_PREFIX) == null) continue;
                advertisements.add(adCmp.func_74779_i(TAG_ADVERTISEMENT_PREFIX));
            }
        }
        PersistentVariableHandler.injectNBTToFile(cmp, PersistentVariableHandler.getCacheFile());
    }

    public static void saveSafe() {
        try {
            PersistentVariableHandler.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setCacheFile(File f) {
        cacheFile = f;
    }

    private static File getCacheFile() throws IOException {
        if (!cacheFile.exists()) {
            cacheFile.createNewFile();
        }
        return cacheFile;
    }

    private static NBTTagCompound getCacheCompound() throws IOException {
        return PersistentVariableHandler.getCacheCompound(PersistentVariableHandler.getCacheFile());
    }

    private static NBTTagCompound getCacheCompound(File cache) throws IOException {
        if (cache == null) {
            throw new RuntimeException("No cache file!");
        }
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(cache));
        }
        catch (IOException e) {
            NBTTagCompound cmp = new NBTTagCompound();
            CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(cache));
            return PersistentVariableHandler.getCacheCompound(cache);
        }
    }

    private static void injectNBTToFile(NBTTagCompound cmp, File f) {
        try {
            CompressedStreamTools.func_74799_a((NBTTagCompound)cmp, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        contributors = new ArrayList<String>();
        contributorsuuid = new ArrayList<String>();
        advertisements = new ArrayList<String>();
    }
}

