/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.item.INatureOrb;
import com.meteor.extrabotany.common.block.ModBlocks;
import com.meteor.extrabotany.common.block.tile.TileInventoryBase;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.crafting.recipe.RecipePedestal;
import com.meteor.extrabotany.common.item.ModItems;
import java.util.Iterator;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PylonVariant;
import vazkii.botania.common.Botania;

public class TilePedestal
extends TileInventoryBase
implements ITickable {
    private int rot;
    private boolean isDirty;
    public int strikes = 0;
    private int solar = 0;
    public static final BlockPos[] PYLON_LOCATIONS = new BlockPos[]{new BlockPos(2, 0, 2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, -2)};
    public static final BlockPos[] PYLON2_LOCATIONS = new BlockPos[]{new BlockPos(3, 1, 3), new BlockPos(-3, 1, 3), new BlockPos(3, 1, -3), new BlockPos(-3, 1, -3), new BlockPos(2, 0, 2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, -2)};
    public static final BlockPos[] POOL_LOCATIONS = new BlockPos[]{new BlockPos(3, 0, 3), new BlockPos(-3, 0, 3), new BlockPos(3, 0, -3), new BlockPos(-3, 0, -3)};
    public static final BlockPos[] ROCK_LOCATIONS = new BlockPos[]{new BlockPos(2, -1, 2), new BlockPos(2, -1, 1), new BlockPos(2, -1, 0), new BlockPos(2, -1, -1), new BlockPos(2, -1, -2), new BlockPos(1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(0, -1, 2), new BlockPos(0, -1, -2), new BlockPos(-1, -1, 2), new BlockPos(-1, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-2, -1, -2)};

    public TilePedestal() {
        super(1, 1);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.rot = nbttagcompound.func_74762_e("Rot");
        this.strikes = nbttagcompound.func_74762_e("strikes");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("Rot", this.rot);
        nbttagcompound.func_74768_a("strikes", this.strikes);
        return nbttagcompound;
    }

    public void func_73660_a() {
        block16: {
            if (this.isDirty) {
                this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
                this.isDirty = false;
            }
            if (this.rot == 360) {
                this.rot = 0;
            }
            if (!this.getItem().func_190926_b()) {
                ++this.rot;
            }
            if (this.getItem().func_77973_b() instanceof INatureOrb) {
                INatureOrb o = (INatureOrb)this.getItem().func_77973_b();
                if (TilePedestal.canInfuse2(this.field_145850_b, this.field_174879_c)) {
                    if (!this.func_145831_w().field_72995_K) {
                        o.addXP(this.getItem(), 6);
                    }
                    Botania.proxy.sparkleFX((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.3f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.1f, 1.0f, 0.1f, 4.0f, 10);
                } else if (TilePedestal.canInfuse(this.field_145850_b, this.field_174879_c)) {
                    if (!this.func_145831_w().field_72995_K) {
                        o.addXP(this.getItem(), 2);
                    }
                    Botania.proxy.sparkleFX((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 1.3f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), 0.15f, 0.8f, 0.15f, 3.0f, 10);
                }
            }
            if (this.getItem().func_77973_b() == ModItems.nightmareFuel) {
                if (this.field_145850_b.func_72935_r()) {
                    ++this.solar;
                    if (this.solar >= 6000) {
                        this.setItem(new ItemStack(ModItems.spiritFuel));
                    }
                }
            } else {
                this.solar = 0;
            }
            if (this.getStrikes() < ConfigHandler.CRAFTING_STRIKES) break block16;
            ItemStack input = this.getItem();
            Iterator<RecipePedestal> iterator = ExtraBotanyAPI.pedestalRecipes.iterator();
            if (iterator.hasNext()) {
                RecipePedestal rp = iterator.next();
                ItemStack output = RecipePedestal.getOutput(this.getItem());
                if (output.func_190926_b() || output.equals(input)) {
                    this.setStrikes(0);
                    return;
                }
                this.setStrikes(0);
                this.setItem(output);
                EntityXPOrb orb = new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1);
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_72838_d((Entity)orb);
                }
            }
        }
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public static MultiblockSet makeMultiblockSet2() {
        Multiblock mb = new Multiblock();
        for (BlockPos o : PYLON2_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), vazkii.botania.common.block.ModBlocks.pylon.func_176203_a(1));
        }
        for (BlockPos o : POOL_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), vazkii.botania.common.block.ModBlocks.pool.func_176223_P());
        }
        for (BlockPos o : ROCK_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), vazkii.botania.common.block.ModBlocks.shimmerrock.func_176223_P());
        }
        mb.addComponent(new BlockPos(0, 0, 0).func_177984_a(), ModBlocks.pedestal.func_176223_P());
        return mb.makeSet();
    }

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos o : PYLON_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), vazkii.botania.common.block.ModBlocks.pylon.func_176203_a(1));
        }
        mb.addComponent(new BlockPos(0, 0, 0).func_177984_a(), ModBlocks.pedestal.func_176223_P());
        return mb.makeSet();
    }

    public static boolean canInfuse(World world, BlockPos pos) {
        for (BlockPos o : PYLON_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == vazkii.botania.common.block.ModBlocks.pylon && world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177229_b((IProperty)BotaniaStateProps.PYLON_VARIANT) == PylonVariant.NATURA) continue;
            return false;
        }
        return true;
    }

    public static boolean canInfuse2(World world, BlockPos pos) {
        for (BlockPos o : PYLON2_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == vazkii.botania.common.block.ModBlocks.pylon && world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177229_b((IProperty)BotaniaStateProps.PYLON_VARIANT) == PylonVariant.NATURA) continue;
            return false;
        }
        for (BlockPos o : POOL_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == vazkii.botania.common.block.ModBlocks.pool) continue;
            return false;
        }
        for (BlockPos o : ROCK_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == vazkii.botania.common.block.ModBlocks.shimmerrock) continue;
            return false;
        }
        return true;
    }

    public void markForUpdate() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void setStrikes(int strikes) {
        this.strikes = strikes;
        this.markForUpdate();
    }

    public int getStrikes() {
        return this.strikes;
    }

    public int getRotation() {
        return this.rot;
    }

    public ItemStack getItem() {
        return this.stacks.getStackInSlot(0);
    }

    public void setItem(ItemStack item) {
        this.stacks.setStackInSlot(0, item);
        this.isDirty = true;
    }
}

