/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import cofh.redstoneflux.api.IEnergyConnection;
import cofh.redstoneflux.api.IEnergyReceiver;
import com.google.common.base.Predicates;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.block.tile.mana.TileSpreader;

@Optional.InterfaceList(value={@Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyConnection", striprefs=true), @Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyStorage", striprefs=true), @Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyReceiver", striprefs=true)})
public class TileManaGenerator
extends TileMod
implements ITickable,
IManaReceiver,
ISparkAttachable,
IEnergyConnection,
IEnergyStorage,
IEnergyReceiver {
    private static final String TAG_MANA = "mana";
    private static final String TAG_ENERGY = "energy";
    int mana;
    public int energy = 0;
    private static final int MAX_ENERGY = ConfigHandler.MG_MAXENERGY;

    public void func_73660_a() {
        if (!ConfigHandler.DISABLE_MANAGENERATOR) {
            return;
        }
        int speed = ConfigHandler.MG_TRANSFERSPEED;
        for (EnumFacing e : EnumFacing.field_82609_l) {
            TileEntity te;
            BlockPos neighbor = this.func_174877_v().func_177972_a(e);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IEnergyStorage storage = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, e.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, e.func_176734_d());
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (storage != null) {
                this.recieveEnergy(storage.extractEnergy(1000, false));
            }
            if (!(te instanceof TileSpreader)) continue;
            TileSpreader p = (TileSpreader)te;
            if (this.getCurrentMana() < speed || p.getCurrentMana() >= p.getMaxMana()) continue;
            int current = Math.min(speed, p.getMaxMana() - p.getCurrentMana());
            p.recieveMana(current);
            this.recieveMana(-current);
        }
        if (this.energy >= 1000) {
            this.recieveEnergy(-1000);
            this.recieveMana(ConfigHandler.MG_CONVERT);
        }
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public boolean isFull() {
        return this.energy >= MAX_ENERGY;
    }

    public void recieveEnergy(int mana) {
        this.energy = Math.min(MAX_ENERGY, this.energy + mana);
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(1000000, this.mana + mana);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public void writePacketNBT(NBTTagCompound cmp) {
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a(TAG_ENERGY, this.energy);
    }

    public void readPacketNBT(NBTTagCompound cmp) {
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.energy = cmp.func_74762_e(TAG_ENERGY);
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity arg0) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        int space = Math.max(0, 1000000 - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        return 0;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int space = this.getMaxEnergyStored() - this.energy;
        if (!simulate) {
            this.energy = Math.min(this.energy + maxReceive, this.getMaxEnergyStored());
        }
        return Math.min(space, maxReceive);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int available = this.energy;
        if (!simulate) {
            this.energy = Math.max(this.energy - maxExtract, 0);
        }
        return Math.min(maxExtract, available);
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return MAX_ENERGY;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public boolean canConnectEnergy(EnumFacing arg0) {
        return true;
    }

    public int getEnergyStored(EnumFacing arg0) {
        return this.energy;
    }

    public int getMaxEnergyStored(EnumFacing arg0) {
        return MAX_ENERGY;
    }

    public int receiveEnergy(EnumFacing arg0, int arg1, boolean arg2) {
        return this.receiveEnergy(arg1, arg2);
    }
}

