/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileInventoryBase
extends TileEntity {
    public final StackHandler stacks;

    public TileInventoryBase(int slot) {
        this(slot, Items.field_190931_a.func_77639_j());
    }

    public TileInventoryBase(int slot, int stackLimit) {
        this.stacks = new StackHandler(this, slot, stackLimit);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.stacks);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("Items", 10)) {
            this.stacks.deserializeNBT(compound.func_74775_l("Items"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("Items", (NBTBase)this.stacks.serializeNBT());
        return compound;
    }

    public void onDataPacket(NetworkManager manager, SPacketUpdateTileEntity packet) {
        this.readPacketData(packet.func_148857_g());
    }

    protected void readPacketData(NBTTagCompound data) {
        this.stacks.deserializeNBT(data.func_74775_l("Items"));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.writePacketData(new NBTTagCompound()));
    }

    protected NBTTagCompound writePacketData(NBTTagCompound data) {
        data.func_74782_a("Items", (NBTBase)this.stacks.serializeNBT());
        return data;
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        return true;
    }

    public void onContentsChanged(int slot) {
        this.refresh();
    }

    protected void refresh() {
        if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.markAndNotifyBlock(this.field_174879_c, null, state, state, 11);
        }
    }

    public class StackHandler
    extends ItemStackHandler {
        private final int stackLimit;

        StackHandler(TileInventoryBase tile, int i, int stackLimit) {
            super(i);
            this.stackLimit = stackLimit;
        }

        public int getSlotLimit(int slot) {
            return this.stackLimit;
        }

        public List<ItemStack> getStacks() {
            return this.stacks;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return TileInventoryBase.this.isItemValidForSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValid(slot, stack)) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }

        protected void onContentsChanged(int slot) {
            TileInventoryBase.this.onContentsChanged(slot);
        }
    }
}

