/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import com.google.common.base.Predicates;
import com.meteor.extrabotany.common.block.BlockInfinityCube;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.mana.spark.ISparkEntity;

public class TileInfinityCube
extends TileEntity
implements ITickable,
IManaReceiver,
ISparkAttachable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_ROTATION = "rotation";
    private int mana;
    private int rot;
    private static final int MAX_MANA = 1000000;
    private static final int COST = 150;

    public void func_73660_a() {
        if (this.rot == 360) {
            this.rot = 0;
        }
        ++this.rot;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getCurrentMana() < 150) {
            return;
        }
        this.recieveMana(-150);
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                for (int z = -4; z < 4; ++z) {
                    BlockPos newpos = this.func_174877_v().func_177982_a(x, y, z);
                    if (newpos == this.func_174877_v()) continue;
                    this.tickBlock(newpos);
                }
            }
        }
    }

    private void tickBlock(BlockPos pos) {
        TileEntity tile;
        IBlockState blockState = this.field_145850_b.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block == null) {
            return;
        }
        if (block instanceof BlockFluidBase) {
            return;
        }
        if (block instanceof BlockInfinityCube) {
            return;
        }
        if (block.func_149653_t()) {
            for (int i = 0; i < 1 && this.func_145831_w().func_180495_p(pos) == blockState; ++i) {
                block.func_180650_b(this.field_145850_b, pos, blockState, this.field_145850_b.field_73012_v);
            }
        }
        if (block.hasTileEntity(this.field_145850_b.func_180495_p(pos)) && (tile = this.field_145850_b.func_175625_s(pos)) != null && !tile.func_145837_r()) {
            for (int i = 0; i < 1 && !tile.func_145837_r(); ++i) {
                if (!(tile instanceof ITickable)) continue;
                ((ITickable)tile).func_73660_a();
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound cmp) {
        super.func_189515_b(cmp);
        cmp.func_74768_a(TAG_MANA, this.mana);
        cmp.func_74768_a(TAG_ROTATION, this.rot);
        return cmp;
    }

    public void func_145839_a(NBTTagCompound cmp) {
        super.func_145839_a(cmp);
        this.mana = cmp.func_74762_e(TAG_MANA);
        this.rot = cmp.func_74762_e(TAG_ROTATION);
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public void attachSpark(ISparkEntity arg0) {
    }

    public boolean canAttachSpark(ItemStack arg0) {
        return true;
    }

    public ISparkEntity getAttachedSpark() {
        List sparks = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(this.field_174879_c.func_177984_a(), this.field_174879_c.func_177984_a().func_177982_a(1, 1, 1)), Predicates.instanceOf(ISparkEntity.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ISparkEntity)e;
        }
        return null;
    }

    public int getAvailableSpaceForMana() {
        int space = Math.max(0, 1000000 - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        return 0;
    }

    public boolean isFull() {
        return this.mana >= 1000000;
    }

    public void recieveMana(int mana) {
        this.mana = Math.min(1000000, this.mana + mana);
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean canRecieveManaFromBursts() {
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getRotation() {
        return this.rot;
    }
}

