/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.tile;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;

public class TileGildedTinyPotato
extends TileMod
implements ITickable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.375, 0.625);
    private static final String TAG_HUNGER = "hunger";
    private static final String TAG_LOVE = "love";
    private static final String TAG_ISTOUCHED = "istouched";
    private static final String TAG_NAME = "name";
    public int hunger;
    public int love = 0;
    public int touchTicks = 0;
    public String name = "";
    public int jumpTicks = 0;
    public int hungerTicks = 0;

    public void func_73660_a() {
        if (this.field_145850_b.field_73012_v.nextInt(100) == 0 && this.hunger > 0) {
            this.jump();
            this.hunger = Math.max(0, this.hunger - 1);
        }
        if (this.hunger == 0) {
            ++this.hungerTicks;
        }
        if (this.field_145850_b.field_73012_v.nextInt(100) == 0 && this.hungerTicks > 6000) {
            this.love = Math.max(0, this.love - 1);
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.touchTicks > 0) {
            --this.touchTicks;
        }
    }

    public void eat(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemFood && this.hunger < 100) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            int recover = Math.min(food.func_150905_g(stack) * 2, 100 - this.hunger);
            this.hunger += recover;
            this.love = Math.min(100, this.love + recover / 4);
            stack.func_190918_g(1);
            this.field_145850_b.func_175688_a(EnumParticleTypes.HEART, (double)this.field_174879_c.func_177958_n() + TileGildedTinyPotato.AABB.field_72340_a + Math.random() * (TileGildedTinyPotato.AABB.field_72336_d - TileGildedTinyPotato.AABB.field_72340_a), (double)this.field_174879_c.func_177956_o() + TileGildedTinyPotato.AABB.field_72337_e, (double)this.field_174879_c.func_177952_p() + TileGildedTinyPotato.AABB.field_72339_c + Math.random() * (TileGildedTinyPotato.AABB.field_72334_f - TileGildedTinyPotato.AABB.field_72339_c), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void play(ItemStack stack, EntityPlayer player) {
        if (this.love <= 80 || this.touchTicks == 0) {
            // empty if block
        }
    }

    public void touch() {
        this.jump();
        if (this.touchTicks == 0) {
            this.touchTicks = 24000;
            this.love = Math.min(100, this.love + 5);
        }
    }

    public void jump() {
        if (this.jumpTicks == 0) {
            this.jumpTicks = 20;
        }
        if (Math.random() < 0.25) {
            this.hunger = Math.max(0, this.hunger - 1);
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public void writePacketNBT(NBTTagCompound cmp) {
        super.writePacketNBT(cmp);
        cmp.func_74768_a(TAG_HUNGER, this.hunger);
        cmp.func_74768_a(TAG_LOVE, this.love);
        cmp.func_74768_a(TAG_ISTOUCHED, this.touchTicks);
        cmp.func_74778_a(TAG_NAME, this.name);
    }

    public void readPacketNBT(NBTTagCompound cmp) {
        super.readPacketNBT(cmp);
        this.hunger = cmp.func_74762_e(TAG_HUNGER);
        this.love = cmp.func_74762_e(TAG_LOVE);
        this.touchTicks = cmp.func_74762_e(TAG_ISTOUCHED);
        this.name = cmp.func_74779_i(TAG_NAME);
    }
}

