/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.subtile.generating;

import com.meteor.extrabotany.api.subtile.SubTileGeneratingNature;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.crafting.recipe.RecipeStonesia;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class SubTileStonesia
extends SubTileGeneratingNature {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final BlockPos[] OFFSETS = new BlockPos[]{new BlockPos(0, 0, 1), new BlockPos(0, 0, -1), new BlockPos(1, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(-1, 0, -1), new BlockPos(1, 0, 1), new BlockPos(1, 0, -1)};
    int burnTime;
    int cooldown;

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.redstoneSignal > 0) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            for (int i = 0; i < 3; ++i) {
                Botania.proxy.wispFX((double)this.supertile.func_174877_v().func_177958_n() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177956_o() + 0.5 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177952_p() + 0.5 + Math.random() * 0.2 - 0.1, 0.1f, 0.1f, 0.1f, (float)Math.random() / 6.0f, (float)(-Math.random()) / 30.0f);
            }
        }
        if (this.burnTime == 0) {
            if (this.mana < this.getMaxMana() && !this.supertile.func_145831_w().field_72995_K) {
                List<BlockPos> offsets = Arrays.asList(OFFSETS);
                Collections.shuffle(offsets);
                for (BlockPos offset : offsets) {
                    BlockPos pos = this.supertile.func_174877_v().func_177971_a((Vec3i)offset);
                    Block block = this.supertile.func_145831_w().func_180495_p(pos).func_177230_c();
                    int output = RecipeStonesia.getOutput(new ItemStack(block));
                    if (block == null || output == 0) continue;
                    if (this.cooldown == 0) {
                        this.burnTime += output;
                        this.supertile.func_145831_w().func_175698_g(pos);
                        this.cooldown = this.getCooldown();
                    }
                    this.sync();
                    this.playSound();
                    break;
                }
            }
        } else {
            if (this.supertile.func_145831_w().field_73012_v.nextInt(8) == 0) {
                this.doBurnParticles();
            }
            --this.burnTime;
        }
    }

    @Override
    public int getRate() {
        return 25;
    }

    @Override
    public boolean willConsume() {
        return ConfigHandler.LP_STONESIA;
    }

    public void doBurnParticles() {
        Botania.proxy.wispFX((double)this.supertile.func_174877_v().func_177958_n() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177956_o() + 0.55 + Math.random() * 0.2 - 0.1, (double)this.supertile.func_174877_v().func_177952_p() + 0.5, 0.05f, 0.05f, 0.7f, (float)Math.random() / 6.0f, (float)(-Math.random()) / 60.0f);
    }

    public void playSound() {
        this.supertile.func_145831_w().func_184133_a(null, this.supertile.func_174877_v(), SoundEvents.field_187664_bz, SoundCategory.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }

    public int getMaxMana() {
        return 800;
    }

    public int getColor() {
        return 0x778899;
    }

    public LexiconEntry getEntry() {
        return LexiconData.stonesia;
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_BURN_TIME, this.burnTime);
        cmp.func_74768_a(TAG_COOLDOWN, this.cooldown);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.burnTime = cmp.func_74762_e(TAG_BURN_TIME);
        this.cooldown = cmp.func_74762_e(TAG_COOLDOWN);
    }

    public void populateDropStackNBTs(List<ItemStack> drops) {
        super.populateDropStackNBTs(drops);
        int cooldown = this.cooldown;
        if (this.burnTime > 0) {
            cooldown = this.getCooldown();
        }
        if (cooldown > 0) {
            ItemNBTHelper.setInt((ItemStack)drops.get(0), (String)TAG_COOLDOWN, (int)this.getCooldown());
        }
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, entity, stack);
        this.cooldown = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_COOLDOWN, (int)0);
    }

    public boolean canGeneratePassively() {
        return this.burnTime > 0;
    }

    public int getDelayBetweenPassiveGeneration() {
        return 1;
    }

    public int getValueForPassiveGeneration() {
        int catalysis = ConfigHandler.LP_STONESIA ? (this.isEnabled() ? 2 : 0) : 0;
        return ConfigHandler.EFF_STONESIA + catalysis;
    }

    public int getCooldown() {
        return 40;
    }
}

