/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block.subtile.functional;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.subtile.SubTileFunctionalNature;
import com.meteor.extrabotany.common.core.config.ConfigHandler;
import com.meteor.extrabotany.common.item.equipment.tool.ItemBinder;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.common.Botania;

public class SubTileStardustLotus
extends SubTileFunctionalNature {
    private static final int RANGE = 1;
    private static final String TAG_MANA = "consumed";
    private static final String TAG_COST = "cost";
    private static final String TAG_X = "Posx";
    private static final String TAG_Y = "Posy";
    private static final String TAG_Z = "Posz";
    private static final String TAG_DIM = "dim";
    private static final String TAG_PAPER = "haspaper";
    int dim = 0;
    int consumed = 0;
    int shouldCost = 0;
    int x;
    int z = 0;
    int y = -1;
    boolean hasPaper = false;
    private static final BlockPos[] QUARTZ_LOCATIONS = new BlockPos[]{new BlockPos(2, -1, 2), new BlockPos(2, -1, 1), new BlockPos(2, -1, 0), new BlockPos(2, -1, -1), new BlockPos(2, -1, -2), new BlockPos(1, -1, 2), new BlockPos(1, -1, -2), new BlockPos(0, -1, 2), new BlockPos(0, -1, -2), new BlockPos(-1, -1, 2), new BlockPos(-1, -1, -2), new BlockPos(-2, -1, 2), new BlockPos(-2, -1, 1), new BlockPos(-2, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-2, -1, -2)};
    private static final BlockPos[] LAMP_LOCATIONS = new BlockPos[]{new BlockPos(2, 2, 2), new BlockPos(-2, 2, 2), new BlockPos(2, 2, -2), new BlockPos(-2, 2, -2)};
    private static final BlockPos[] PILLAR_LOCATIONS = new BlockPos[]{new BlockPos(2, 1, 2), new BlockPos(-2, 1, 2), new BlockPos(2, 1, -2), new BlockPos(-2, 1, -2), new BlockPos(2, 0, 2), new BlockPos(-2, 0, 2), new BlockPos(2, 0, -2), new BlockPos(-2, 0, -2)};

    @Override
    public void writeToPacketNBT(NBTTagCompound cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_MANA, this.consumed);
        cmp.func_74768_a(TAG_COST, this.shouldCost);
        cmp.func_74768_a(TAG_X, this.x);
        cmp.func_74768_a(TAG_Y, this.y);
        cmp.func_74768_a(TAG_Z, this.z);
        cmp.func_74757_a(TAG_PAPER, this.hasPaper);
        cmp.func_74768_a(TAG_DIM, this.dim);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound cmp) {
        super.readFromPacketNBT(cmp);
        this.consumed = cmp.func_74762_e(TAG_MANA);
        this.shouldCost = cmp.func_74762_e(TAG_COST);
        this.x = cmp.func_74762_e(TAG_X);
        this.y = cmp.func_74762_e(TAG_Y);
        this.z = cmp.func_74762_e(TAG_Z);
        this.hasPaper = cmp.func_74767_n(TAG_PAPER);
        this.dim = cmp.func_74762_e(TAG_DIM);
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() instanceof ItemBinder) {
            ItemBinder bind = (ItemBinder)player.func_184586_b(hand).func_77973_b();
            if (bind.getPosY(player.func_184586_b(hand)) == -1 || bind.getDim(player.func_184586_b(hand)) != player.field_71093_bK) {
                if (!world.field_72995_K) {
                    player.func_145747_a(new TextComponentTranslation("extrabotanymisc.bindingwrong", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)));
                }
                return false;
            }
            this.x = bind.getPosX(player.func_184586_b(hand));
            this.y = bind.getPosY(player.func_184586_b(hand));
            this.z = bind.getPosZ(player.func_184586_b(hand));
            this.dim = bind.getDim(player.func_184586_b(hand));
        }
        return true;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        int posx = this.supertile.func_174877_v().func_177958_n();
        int posy = this.supertile.func_174877_v().func_177956_o();
        int posz = this.supertile.func_174877_v().func_177952_p();
        if (!SubTileStardustLotus.canTPExist(this.getWorld(), this.getPos()) || this.redstoneSignal > 0 || this.y == -1) {
            return;
        }
        this.shouldCost = (int)(((double)ConfigHandler.BASECOST + Math.sqrt(Math.pow(this.x - posx, 2.0) + Math.pow(this.y - posy, 2.0) + Math.pow(this.z - posz, 2.0)) * (double)ConfigHandler.PERCOST) * (double)(this.isEnabled() ? 0.8f : 1.0f));
        if (!this.hasPaper) {
            for (EntityItem item : this.supertile.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-1, -1, -1), this.supertile.func_174877_v().func_177982_a(2, 2, 2)))) {
                if (item.func_92059_d().func_77973_b() != Items.field_151121_aF || item.func_92059_d().func_190916_E() <= 0) continue;
                item.func_92059_d().func_190918_g(1);
                this.hasPaper = true;
            }
        }
        if (this.hasPaper && this.consumed < this.shouldCost && this.mana > ConfigHandler.CONSUMESPEED) {
            this.mana -= ConfigHandler.CONSUMESPEED;
            this.consumed += ConfigHandler.CONSUMESPEED;
        }
        if (this.consumed > 0) {
            int imax = 360 * this.consumed / this.shouldCost;
            for (int i = 0; i < imax; i += 15) {
                float rad = (float)i * (float)Math.PI / 180.0f;
                double x = (double)posx + 0.5 - Math.cos(rad) * 2.0;
                double y = (double)posy + 0.2;
                double z = (double)posz + 0.5 - Math.sin(rad) * 2.0;
                Botania.proxy.sparkleFX(x, y, z, 1.0f, 0.1f, 1.0f, 1.0f, 10);
            }
        }
        if (this.consumed >= this.shouldCost) {
            Botania.proxy.sparkleFX((double)((float)posx + 0.5f), (double)((float)posy + 1.0f), (double)((float)posz + 0.5f), 1.0f, 0.1f, 1.0f, 5.0f, 10);
            for (EntityLivingBase living : this.supertile.func_145831_w().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.supertile.func_174877_v().func_177982_a(-1, -1, -1), this.supertile.func_174877_v().func_177982_a(2, 2, 2)))) {
                living.func_70107_b((double)this.x, (double)this.y + 0.5, (double)this.z);
                if (!(living instanceof EntityPlayer)) continue;
                ExtraBotanyAPI.unlockAdvancement((EntityPlayer)living, "stardustlotus_teleport");
            }
        }
    }

    @Override
    public int getRate() {
        return 60;
    }

    @Override
    public boolean willConsume() {
        return true;
    }

    public static MultiblockSet makeMultiblockSet() {
        Multiblock mb = new Multiblock();
        for (BlockPos o : QUARTZ_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150371_ca.func_176223_P());
        }
        for (BlockPos o : LAMP_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_180398_cJ.func_176223_P());
        }
        for (BlockPos o : PILLAR_LOCATIONS) {
            mb.addComponent(o.func_177984_a(), Blocks.field_150368_y.func_176223_P());
        }
        return mb.makeSet();
    }

    public static boolean canTPExist(World world, BlockPos pos) {
        for (BlockPos o : QUARTZ_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_150371_ca) continue;
            return false;
        }
        for (BlockPos o : LAMP_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_180398_cJ) continue;
            return false;
        }
        for (BlockPos o : PILLAR_LOCATIONS) {
            if (world.func_180495_p(pos.func_177971_a((Vec3i)o)).func_177230_c() == Blocks.field_150368_y) continue;
            return false;
        }
        return true;
    }

    public int getMaxMana() {
        return 100000;
    }

    public LexiconEntry getEntry() {
        return LexiconData.stardustlotus;
    }

    public int getColor() {
        return 0x800080;
    }

    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.toBlockPos(), 1);
    }
}

