/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block;

import com.meteor.extrabotany.api.ExtraBotanyAPI;
import com.meteor.extrabotany.api.item.IHammer;
import com.meteor.extrabotany.common.block.BlockMod;
import com.meteor.extrabotany.common.block.tile.TilePedestal;
import com.meteor.extrabotany.common.item.ItemGildedMashedPotato;
import com.meteor.extrabotany.common.item.ItemSpiritFuel;
import com.meteor.extrabotany.common.item.equipment.tool.ItemHammerUltimate;
import com.meteor.extrabotany.common.item.equipment.tool.ItemKingGarden;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BlockPedestal
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 1.25, 0.875);

    public BlockPedestal() {
        super(Material.field_151576_e, "pedestal");
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Random rand = new Random();
        TilePedestal pedestal = (TilePedestal)world.func_175625_s(pos);
        if (pedestal != null && !pedestal.getItem().func_190926_b()) {
            float f = rand.nextFloat() * 0.8f + 0.1f;
            float f1 = rand.nextFloat() * 0.8f + 0.1f;
            float f2 = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), pedestal.getItem());
            float f3 = 0.05f;
            item.field_70159_w = (float)rand.nextGaussian() * f3;
            item.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            item.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)item);
        }
        super.func_180663_b(world, pos, state);
    }

    public static boolean handleBlockActivation(World world, BlockPos pos, EntityPlayer player, ItemStack heldItem) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TilePedestal) {
            TilePedestal te = (TilePedestal)tile;
            if (!heldItem.func_190926_b() && te.getItem().func_190926_b()) {
                te.setStrikes(0);
                te.markForUpdate();
                ItemStack newItem = heldItem.func_77946_l();
                newItem.func_190920_e(1);
                te.setItem(newItem);
                heldItem.func_190918_g(1);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                return true;
            }
            if (!te.getItem().func_190926_b()) {
                if (heldItem.func_190926_b()) {
                    if (player.field_71071_by.func_70441_a(((TilePedestal)tile).getItem())) {
                        te.setStrikes(0);
                        te.markForUpdate();
                        te.setItem(ItemStack.field_190927_a);
                        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                        return true;
                    }
                } else if (te.getItem().func_77973_b() instanceof ItemHammerUltimate && !heldItem.func_190926_b()) {
                    ItemHammerUltimate stack = (ItemHammerUltimate)te.getItem().func_77973_b();
                    te.setStrikes(0);
                    te.markForUpdate();
                    if (heldItem.func_77973_b() instanceof ItemGildedMashedPotato && stack.getRepair(te.getItem()) < 3 && heldItem.func_190916_E() >= 5) {
                        if (!world.field_72995_K) {
                            ItemHammerUltimate.setRepair(te.getItem(), stack.getRepair(te.getItem()) + 1);
                        }
                        heldItem.func_190918_g(5);
                        ExtraBotanyAPI.unlockAdvancement(player, "ultimatehammer_upgrade");
                        return true;
                    }
                    if (heldItem.func_77973_b() == ModItems.elementiumSword && stack.getAttack(te.getItem()) < 10) {
                        if (!world.field_72995_K) {
                            ItemHammerUltimate.setAttack(te.getItem(), stack.getAttack(te.getItem()) + 1);
                        }
                        heldItem.func_190918_g(1);
                        return true;
                    }
                    if (heldItem.func_77973_b() == com.meteor.extrabotany.common.item.ModItems.hammerterrasteel) {
                        if (!ItemHammerUltimate.hasRange(te.getItem())) {
                            if (!world.field_72995_K) {
                                stack.setRange(te.getItem(), true);
                            }
                            heldItem.func_190918_g(1);
                            return true;
                        }
                    }
                } else {
                    if (heldItem.func_77973_b() instanceof IHammer) {
                        te.setStrikes(te.getStrikes() + 1);
                        heldItem.func_77972_a(1, (EntityLivingBase)player);
                        te.markForUpdate();
                        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187686_e, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                        ExtraBotanyAPI.unlockAdvancement(player, "fragment_forge");
                        return true;
                    }
                    if (te.getItem().func_77973_b() instanceof ItemKingGarden && !heldItem.func_190926_b()) {
                        te.setStrikes(0);
                        te.markForUpdate();
                        ItemStack stack = te.getItem();
                        ItemKingGarden k = (ItemKingGarden)te.getItem().func_77973_b();
                        int[] clear = new int[]{};
                        if (ItemKingGarden.getType(stack).length < 20 && !world.field_72995_K && heldItem.func_77973_b() instanceof ItemBlockSpecialFlower) {
                            if (BlockPedestal.getType(heldItem).matches("bloodyenchantress")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 0));
                            } else if (BlockPedestal.getType(heldItem).matches("sunbless")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 1));
                            } else if (BlockPedestal.getType(heldItem).matches("moonbless")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 2));
                            } else if (BlockPedestal.getType(heldItem).matches("stardustlotus")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 3));
                            } else if (BlockPedestal.getType(heldItem).matches("stonesia")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 4));
                            } else if (BlockPedestal.getType(heldItem).matches("entropinnyum")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 5));
                            } else if (BlockPedestal.getType(heldItem).matches("dreadthorn")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 6));
                            } else if (BlockPedestal.getType(heldItem).matches("medumone")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 7));
                            } else if (BlockPedestal.getType(heldItem).matches("thermalily")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 8));
                            } else if (BlockPedestal.getType(heldItem).matches("tigerseye")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 9));
                            } else if (BlockPedestal.getType(heldItem).matches("bellethorn")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 10));
                            } else if (BlockPedestal.getType(heldItem).matches("heiseiDream")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 11));
                            } else if (BlockPedestal.getType(heldItem).matches("annoyingflower")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 12));
                            } else if (BlockPedestal.getType(heldItem).matches("manalinkium")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 13));
                            } else if (BlockPedestal.getType(heldItem).matches("omniviolet")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 14));
                            } else if (BlockPedestal.getType(heldItem).matches("bellflower")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 15));
                            } else if (BlockPedestal.getType(heldItem).matches("tinkle")) {
                                ItemKingGarden.setType(stack, BlockPedestal.addType(ItemKingGarden.getType(stack), 16));
                            }
                        }
                        return true;
                    }
                    if (te.getItem().func_77973_b() instanceof ItemSpiritFuel && heldItem.func_77973_b() == ModItems.lexicon) {
                        te.setStrikes(0);
                        te.markForUpdate();
                        ItemLexicon l = (ItemLexicon)heldItem.func_77973_b();
                        l.unlockKnowledge(heldItem, ExtraBotanyAPI.dreamKnowledge);
                        ExtraBotanyAPI.unlockAdvancement(player, "newknowledge_unlock");
                        return true;
                    }
                    if (player.field_71071_by.func_70441_a(((TilePedestal)tile).getItem())) {
                        te.setStrikes(0);
                        te.markForUpdate();
                        te.setItem(ItemStack.field_190927_a);
                        world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getType(ItemStack stack) {
        return stack.func_77942_o() ? ItemNBTHelper.getString((ItemStack)stack, (String)"type", (String)"") : "";
    }

    public static int[] addType(int[] k, int i) {
        int[] ary = k;
        ary = Arrays.copyOf(ary, ary.length + 1);
        ary[ary.length - 1] = i;
        return ary;
    }

    public static int[] clear(int[] k) {
        int[] ary = k;
        ary = Arrays.copyOf(ary, 0);
        return ary;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return BlockPedestal.handleBlockActivation(world, pos, player, player.func_184586_b(hand));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TilePedestal();
    }

    public LexiconEntry getEntry(World arg0, BlockPos arg1, EntityPlayer arg2, ItemStack arg3) {
        return LexiconData.pedestal;
    }
}

