/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.common.block;

import com.meteor.extrabotany.common.block.BlockMod;
import com.meteor.extrabotany.common.block.tile.TileCocoonDesire;
import com.meteor.extrabotany.common.lexicon.LexiconData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;

public class BlockCocoonDesire
extends BlockMod
implements ILexiconable {
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.875, 0.8125);

    public BlockCocoonDesire() {
        super(Material.field_151580_n, "cocoondesire");
        this.func_149711_c(3.0f);
        this.func_149752_b(50.0f);
        this.func_149672_a(SoundType.field_185854_g);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        return new TileCocoonDesire();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Random rand = new Random();
        TileCocoonDesire pedestal = (TileCocoonDesire)world.func_175625_s(pos);
        if (pedestal != null && !pedestal.getItem().func_190926_b()) {
            float f = rand.nextFloat() * 0.8f + 0.1f;
            float f1 = rand.nextFloat() * 0.8f + 0.1f;
            float f2 = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + f), (double)((float)pos.func_177956_o() + f1), (double)((float)pos.func_177952_p() + f2), pedestal.getItem());
            float f3 = 0.05f;
            item.field_70159_w = (float)rand.nextGaussian() * f3;
            item.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            item.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)item);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return BlockCocoonDesire.handleBlockActivation(world, pos, player, player.func_184586_b(hand));
    }

    public static boolean handleBlockActivation(World world, BlockPos pos, EntityPlayer player, ItemStack heldItem) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileCocoonDesire) {
            TileCocoonDesire te = (TileCocoonDesire)tile;
            if (!heldItem.func_190926_b() && te.getItem().func_190926_b()) {
                ItemStack newItem = heldItem.func_77946_l();
                newItem.func_190920_e(1);
                te.setItem(newItem);
                heldItem.func_190918_g(1);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                return true;
            }
            if (!te.getItem().func_190926_b() && player.field_71071_by.func_70441_a(te.getItem())) {
                te.setItem(ItemStack.field_190927_a);
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat() * 0.2f + 1.0f, false);
                return true;
            }
        }
        return false;
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack lexicon) {
        return LexiconData.cocoondesire;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side.func_176740_k() == EnumFacing.Axis.Y ? BlockFaceShape.CENTER_BIG : BlockFaceShape.MIDDLE_POLE_THICK;
    }
}

