/*
 * Decompiled with CFR 0.152.
 */
package com.meteor.extrabotany.client.integration.jei.pedestal;

import com.meteor.extrabotany.client.integration.jei.pedestal.HammerRecipeWrapper;
import com.meteor.extrabotany.common.item.ModItems;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class HammerRecipeCategory
implements IRecipeCategory {
    public static final String UID = "extrabotany.pedestal";
    private final String localizedName;
    private final IDrawable background;
    private final IDrawable overlay;
    private final ItemStack renderStack = new ItemStack(ModItems.hammermanasteel);

    public HammerRecipeCategory(IGuiHelper guiHelper) {
        this.localizedName = I18n.func_135052_a((String)"extrabotany.nei.pedestal", (Object[])new Object[0]);
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("botania", "textures/gui/pureDaisyOverlay.png"), 0, 0, 64, 46);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        this.overlay.draw(minecraft, 48, 0);
        GlStateManager.func_179084_k();
        GlStateManager.func_179118_c();
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        if (!(recipeWrapper instanceof HammerRecipeWrapper)) {
            return;
        }
        int index = 0;
        recipeLayout.getItemStacks().init(index, true, 40, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(ItemStack.class).get(0));
        ++index;
        if (ingredients.getInputs(ItemStack.class).size() > 1) {
            recipeLayout.getItemStacks().init(index, true, 20, 12);
            recipeLayout.getItemStacks().set(index, (List)ingredients.getInputs(ItemStack.class).get(1));
            ++index;
        }
        recipeLayout.getItemStacks().init(index, true, 70, 12);
        recipeLayout.getItemStacks().set(index, this.renderStack);
        recipeLayout.getItemStacks().init(++index, false, 99, 12);
        recipeLayout.getItemStacks().set(index, (List)ingredients.getOutputs(ItemStack.class).get(0));
    }

    @Nonnull
    public String getModName() {
        return "extrabotany";
    }
}

