/*
 * Decompiled with CFR 0.152.
 */
package com.Zoko061602.ThaumicRestoration.lib.research;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.common.items.consumables.ItemPhial;
import thaumcraft.common.items.resources.ItemCrystalEssence;

public class AspectUtil {
    public static boolean containsAll(AspectList list, AspectList aspects) {
        return AspectUtil.getMissing(list, aspects).visSize() == 0;
    }

    public static AspectList getMissing(AspectList list, AspectList required) {
        AspectList al = new AspectList();
        for (Aspect a : required.getAspects()) {
            if (list.getAmount(a) >= required.getAmount(a)) continue;
            al.add(a, required.getAmount(a) - list.getAmount(a));
        }
        return al;
    }

    public static ItemStack crystalEssence(Aspect a) {
        return AspectUtil.crystalEssence(a, 1);
    }

    public static ItemStack phial(Aspect a) {
        return AspectUtil.phial(a, 1);
    }

    public static ItemStack phial(Aspect a, int count) {
        return AspectUtil.phial(a, count, 10);
    }

    public static ItemStack phial(Aspect a, int count, int aspectPerPhial) {
        ItemStack i = null;
        if (a != null) {
            i = new ItemStack(ItemsTC.phial, count, 1);
            ((ItemPhial)ItemsTC.phial).setAspects(i, new AspectList().add(a, aspectPerPhial));
        }
        if (a == null) {
            i = new ItemStack(ItemsTC.phial, count, 0);
        }
        return i;
    }

    public static ItemStack crystalEssence(Aspect a, int count) {
        ItemStack is = new ItemStack(ItemsTC.crystalEssence, count);
        ((ItemCrystalEssence)ItemsTC.crystalEssence).setAspects(is, new AspectList().add(a, 1));
        return is;
    }

    public static Aspect getAspectFromCrystalBlockStack(ItemStack is) {
        Aspect a = null;
        if (is.func_77942_o() && is.func_77978_p().func_150297_b("Aspect", 8)) {
            a = Aspect.getAspect((String)is.func_77978_p().func_74779_i("Aspect"));
        }
        if (a == null) {
            ArrayList al = new ArrayList(Aspect.aspects.values());
            a = (Aspect)al.get((int)(System.currentTimeMillis() % ((long)al.size() * 1000L) / 1000L));
        }
        return a;
    }

    public static NBTTagCompound writeALToNBT(AspectList list, NBTTagCompound nbt) {
        if (list != null) {
            list.writeToNBT(nbt);
        }
        return nbt;
    }

    public static AspectList primals(int i) {
        return new AspectList().add(Aspect.AIR, i).add(Aspect.WATER, i).add(Aspect.ORDER, i).add(Aspect.ENTROPY, i).add(Aspect.FIRE, i).add(Aspect.EARTH, i);
    }
}

