/*
 * Decompiled with CFR 0.152.
 */
package com.Zoko061602.ThaumicRestoration.items;

import com.Zoko061602.ThaumicRestoration.api.IWandTrigger;
import com.Zoko061602.ThaumicRestoration.items.ItemBaseMeta;
import com.Zoko061602.ThaumicRestoration.main.TR_Tab;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.items.IRechargable;
import thaumcraft.api.items.RechargeHelper;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;

public class ItemWand
extends ItemBaseMeta
implements IRechargable {
    public ItemWand() {
        super("item_wand", "novice", "adept", "master");
        this.func_77625_d(1);
    }

    @Override
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == TR_Tab.tabRestoration) {
            for (int i = 0; i != this.getVariants().length; ++i) {
                ItemStack is = new ItemStack((Item)this, 1, i);
                RechargeHelper.rechargeItemBlindly((ItemStack)is, null, (int)this.getMaxCharge(is, null));
                items.add((Object)new ItemStack((Item)this, 1, i));
                items.add((Object)is);
            }
        }
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!player.func_175151_a(pos, side, player.func_184586_b(hand))) {
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        player.func_184609_a(hand);
        for (IWandTrigger trigger : IWandTrigger.triggers) {
            IDustTrigger.Placement place = trigger.getValidFace(world, player, pos, side);
            if (place == null) continue;
            int cost = trigger.getCost();
            if (player.field_71075_bZ.field_75098_d) {
                cost = 0;
            }
            if (RechargeHelper.getCharge((ItemStack)player.func_184586_b(hand)) < cost) continue;
            RechargeHelper.consumeCharge((ItemStack)player.func_184586_b(hand), (EntityLivingBase)player, (int)cost);
            trigger.execute(world, player, pos, place, side);
            if (world.field_72995_K) {
                this.doSparkles(player, world, pos, hitX, hitY, hitZ, hand, trigger, place);
                break;
            }
            return EnumActionResult.SUCCESS;
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    private void doSparkles(EntityPlayer player, World world, BlockPos pos, float hitX, float hitY, float hitZ, EnumHand hand, IDustTrigger trigger, IDustTrigger.Placement place) {
        Vec3d v1 = EntityUtils.posToHand((Entity)player, (EnumHand)hand);
        Vec3d v2 = new Vec3d((Vec3i)pos);
        v2 = v2.func_72441_c(0.5, 0.5, 0.5);
        v2 = v2.func_178788_d(v1);
        int cnt = 50;
        for (int a = 0; a < cnt; ++a) {
            boolean floaty = a < cnt / 3;
            float r = (float)MathHelper.func_76136_a((Random)world.field_73012_v, (int)255, (int)255) / 255.0f;
            float g = (float)MathHelper.func_76136_a((Random)world.field_73012_v, (int)189, (int)255) / 255.0f;
            float b = (float)MathHelper.func_76136_a((Random)world.field_73012_v, (int)64, (int)255) / 255.0f;
            FXDispatcher.INSTANCE.drawSimpleSparkle(world.field_73012_v, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a / 6.0 + world.field_73012_v.nextGaussian() * 0.05, v2.field_72448_b / 6.0 + world.field_73012_v.nextGaussian() * 0.05 + (floaty ? 0.05 : 0.15), v2.field_72449_c / 6.0 + world.field_73012_v.nextGaussian() * 0.05, 0.5f, r, g, b, world.field_73012_v.nextInt(5), floaty ? 0.3f + world.field_73012_v.nextFloat() * 0.5f : 0.85f, floaty ? 0.2f : 0.5f, 16);
        }
        world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundsTC.dust, SoundCategory.PLAYERS, 0.33f, 1.0f + (float)world.field_73012_v.nextGaussian() * 0.05f, false);
        List sparkles = trigger.sparkle(world, player, pos, place);
        if (sparkles != null) {
            Vec3d v = new Vec3d((Vec3i)pos).func_72441_c((double)hitX, (double)hitY, (double)hitZ);
            for (BlockPos p : sparkles) {
                FXDispatcher.INSTANCE.drawBlockSparkles(p, v);
            }
        }
    }

    public int getMaxCharge(ItemStack stack, EntityLivingBase player) {
        switch (stack.func_77952_i()) {
            case 0: {
                return 50;
            }
            case 1: {
                return 200;
            }
            case 2: {
                return 800;
            }
        }
        return 50;
    }

    @Override
    public String func_77667_c(ItemStack stack) {
        return "item_wand_" + stack.func_77952_i();
    }

    public IRechargable.EnumChargeDisplay showInHud(ItemStack stack, EntityLivingBase player) {
        return IRechargable.EnumChargeDisplay.NEVER;
    }
}

