/*
 * Decompiled with CFR 0.152.
 */
package com.Zoko061602.ThaumicRestoration.crafting;

import com.Zoko061602.ThaumicRestoration.api.IWandTrigger;
import com.Zoko061602.ThaumicRestoration.blocks.TR_Blocks;
import com.Zoko061602.ThaumicRestoration.crafting.CrystalTypes;
import com.Zoko061602.ThaumicRestoration.crafting.RecipeCrystal;
import com.Zoko061602.ThaumicRestoration.crafting.TR_Golems;
import com.Zoko061602.ThaumicRestoration.items.TR_Items;
import com.Zoko061602.ThaumicRestoration.lib.crafting.RecipeCrystalInfusion;
import com.Zoko061602.ThaumicRestoration.lib.wands.WandTriggerDust;
import com.Zoko061602.ThaumicRestoration.lib.wands.WandTriggerFire;
import com.Zoko061602.ThaumicRestoration.lib.wands.WandTriggerSimple;
import java.util.HashMap;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IDustTrigger;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.items.ItemsTC;

public class TR_Recipes {
    public static HashMap<String, ResourceLocation> recipes = new HashMap();

    public static void addRecipes(RegistryEvent.Register<IRecipe> e) {
        TR_Recipes.addRegularRecipes();
        TR_Recipes.addArcaneRecipes();
        TR_Recipes.addCucibleRecipes();
        TR_Recipes.addCrystalInfuserRecipes();
        TR_Recipes.addInfusionRecipes();
        TR_Recipes.addWandTriggers();
        TR_Golems.addGolems();
        CrystalTypes.registerCrystals();
    }

    private static void addRegularRecipes() {
        recipes.put("TR_DECO.1", TR_Recipes.addShapelessOreRecipe(new ItemStack(TR_Blocks.blockGreatwoodPlank), new ItemStack(BlocksTC.plankGreatwood)));
        recipes.put("TR_DECO.2", TR_Recipes.addShapedOreRecipe(new ItemStack(TR_Blocks.blockGreatwoodFramed), " N ", "NGN", " N ", Character.valueOf('N'), "nuggetThaumium", Character.valueOf('G'), new ItemStack(TR_Blocks.blockGreatwoodPlank)));
        recipes.put("TR_DECO.3", TR_Recipes.addShapedOreRecipe(new ItemStack(TR_Blocks.blockReinforced, 5), "TST", "SSS", "TST", Character.valueOf('T'), "ingotThaumium", Character.valueOf('S'), new ItemStack(Blocks.field_150347_e)));
        TR_Recipes.addShapelessOreRecipe(new ItemStack(BlocksTC.plankGreatwood), new ItemStack(TR_Blocks.blockGreatwoodPlank));
        for (int i = 0; i != 6; ++i) {
            recipes.put("INFUSEDTHAUMIUM." + i, TR_Recipes.addShapedOreRecipe(new ItemStack(TR_Items.itemPlate, 3, i), "III", Character.valueOf('I'), new ItemStack(TR_Items.itemIngot, 1, i)));
        }
    }

    private static void addArcaneRecipes() {
        AspectList crystals = new AspectList().add(Aspect.ENTROPY, 1);
        recipes.put("NOVICEWAND.1", TR_Recipes.addShapedArcaneRecipe("NOVICEWAND@1", new ItemStack(TR_Items.itemWandRod, 1, 0), 10, crystals, "  G", " G ", "G  ", Character.valueOf('G'), new ItemStack(BlocksTC.logGreatwood)));
        crystals = new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.ORDER, 1);
        recipes.put("NOVICEWAND.2", TR_Recipes.addShapedArcaneRecipe("NOVICEWAND@1", new ItemStack(TR_Items.itemWandCap, 1, 0), 10, crystals, "NNN", "N N", Character.valueOf('N'), "nuggetBrass"));
        crystals = new AspectList().add(Aspect.AIR, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.EARTH, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1);
        recipes.put("NOVICEWAND.3", TR_Recipes.addShapedArcaneRecipe("NOVICEWAND@1", new ItemStack(TR_Items.itemWand, 1, 0), 25, crystals, "  C", " R ", "C  ", Character.valueOf('R'), new ItemStack(TR_Items.itemWandRod), Character.valueOf('C'), new ItemStack(TR_Items.itemWandCap)));
        crystals = new AspectList().add(Aspect.AIR, 3).add(Aspect.FIRE, 3).add(Aspect.WATER, 3).add(Aspect.EARTH, 3).add(Aspect.ORDER, 3).add(Aspect.ENTROPY, 3);
        recipes.put("ADEPTWAND.1", TR_Recipes.addShapedArcaneRecipe("ADEPTWAND@1", new ItemStack(TR_Items.itemWand, 1, 1), 50, crystals, " CR", " WC", "C  ", Character.valueOf('C'), new ItemStack(TR_Items.itemWandCap), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('W'), new ItemStack(TR_Items.itemWand)));
        crystals = new AspectList().add(Aspect.WATER, 5).add(Aspect.ORDER, 2);
        recipes.put("AQUABUCKET.1", TR_Recipes.addShapedArcaneRecipe("AQUABUCKET@1", new ItemStack(TR_Items.itemTRBucket, 1, 0), 25, crystals, "I I", " I ", Character.valueOf('I'), new ItemStack(TR_Items.itemIngot, 1, 2)));
        crystals = new AspectList().add(Aspect.AIR, 5).add(Aspect.ORDER, 2).add(Aspect.ENTROPY, 2);
        recipes.put("PAVING_AER.1", TR_Recipes.addShapedArcaneRecipe("PAVING_AER@1", new ItemStack(TR_Blocks.blockPavingAer, 8, 0), 50, crystals, "SSS", "SIS", "SSS", Character.valueOf('S'), new ItemStack(BlocksTC.stoneArcane), Character.valueOf('I'), new ItemStack(TR_Items.itemIngot, 1, 0)));
        crystals = new AspectList().add(Aspect.EARTH, 5).add(Aspect.ENTROPY, 2);
        recipes.put("TERRAOBSIDIAN.1", TR_Recipes.addShapedArcaneRecipe("TERRAOBSIDIAN@1", new ItemStack(TR_Blocks.blockObsidian, 5), 25, crystals, "OIO", "IOI", "OIO", Character.valueOf('I'), new ItemStack(TR_Items.itemIngot, 1, 3), Character.valueOf('O'), new ItemStack(Blocks.field_150343_Z)));
        crystals = new AspectList().add(Aspect.AIR, 10).add(Aspect.FIRE, 10).add(Aspect.WATER, 10).add(Aspect.EARTH, 10).add(Aspect.ORDER, 10).add(Aspect.ENTROPY, 10);
        recipes.put("POTIONCRYSTALS.1", TR_Recipes.addShapedArcaneCrystalRecipe("POTIONCRYSTALS@1", new ItemStack(TR_Blocks.blockCrystal), 50, crystals, " C ", "CRC", "OOO", Character.valueOf('C'), new ItemStack(ItemsTC.crystalEssence), Character.valueOf('R'), new ItemStack(ItemsTC.visResonator), Character.valueOf('O'), new ItemStack(TR_Blocks.blockObsidian)));
    }

    private static void addInfusionRecipes() {
        AspectList aspects = new AspectList().add(Aspect.MAGIC, 32).add(Aspect.ENERGY, 24).add(Aspect.ORDER, 16).add(Aspect.AURA, 8);
        recipes.put("CRYSTALINFUSION.1", TR_Recipes.addInfusionRecipe("CRYSTALINFUSION@1", new ItemStack(TR_Blocks.blockInfuser), 6, new ItemStack(BlocksTC.pedestalArcane), aspects, new ItemStack(BlocksTC.metalBlockThaumium), new ItemStack(ItemsTC.salisMundus), new ItemStack(BlocksTC.metalBlockThaumium), new ItemStack(ItemsTC.salisMundus), new ItemStack(BlocksTC.metalBlockThaumium), new ItemStack(ItemsTC.salisMundus)));
        aspects = new AspectList().add(Aspect.MAGIC, 32).add(Aspect.ENERGY, 24).add(Aspect.AIR, 16).add(Aspect.AURA, 8);
        recipes.put("RECHARGER.1", TR_Recipes.addInfusionRecipe("RECHARGER@1", new ItemStack(TR_Blocks.blockAdvRechargePed), 6, new ItemStack(BlocksTC.rechargePedestal), aspects, new ItemStack(Blocks.field_150340_R), new ItemStack(Items.field_151166_bC), new ItemStack(BlocksTC.metalBlockThaumium), new ItemStack(ItemsTC.salisMundus), new ItemStack(BlocksTC.metalBlockThaumium), new ItemStack(Items.field_151166_bC)));
        aspects = new AspectList().add(Aspect.MAGIC, 64).add(Aspect.AIR, 64).add(Aspect.FIRE, 64).add(Aspect.WATER, 64).add(Aspect.EARTH, 64).add(Aspect.ORDER, 64).add(Aspect.ENTROPY, 64);
        recipes.put("MASTERWAND.1", TR_Recipes.addInfusionRecipe("MASTERWAND@1", new ItemStack(TR_Items.itemWand, 1, 2), 8, new ItemStack(TR_Items.itemWand, 1, 1), aspects, new ItemStack(Items.field_151156_bN), new ItemStack(TR_Items.itemIngot, 1, 0), new ItemStack(TR_Items.itemIngot, 1, 1), new ItemStack(TR_Items.itemIngot, 1, 2), new ItemStack(Items.field_151156_bN), new ItemStack(TR_Items.itemIngot, 1, 3), new ItemStack(TR_Items.itemIngot, 1, 4), new ItemStack(TR_Items.itemIngot, 1, 5)));
        aspects = new AspectList().add(Aspect.MAGIC, 30).add(Aspect.LIFE, 20).add(Aspect.PROTECT, 15).add(Aspect.ORDER, 10);
        recipes.put("WITHERRING.1", TR_Recipes.addInfusionRecipe("WITHERRING@1", new ItemStack(TR_Items.itemWitherRing), 5, new ItemStack(ItemsTC.baubles, 1, 1), aspects, new ItemStack(Items.field_151156_bN), new ItemStack(Items.field_151144_bL, 1, 1), new ItemStack(Items.field_151117_aB), new ItemStack(Items.field_151144_bL, 1, 1), new ItemStack(Items.field_151117_aB)));
    }

    private static void addCucibleRecipes() {
        AspectList aspects = new AspectList().add(Aspect.ENTROPY, 30).add(Aspect.DEATH, 20).add(Aspect.UNDEAD, 40).add(Aspect.DARKNESS, 20);
        recipes.put("TR_WITHER.1", TR_Recipes.addCrucibleRecipe("TR_WITHER", new ItemStack(Items.field_151144_bL, 1, 1), aspects, new ItemStack(Items.field_151144_bL, 1, 0)));
        aspects = new AspectList().add(Aspect.ORDER, 15).add(Aspect.MAGIC, 10).add(Aspect.VOID, 20).add(Aspect.DARKNESS, 10);
        recipes.put("TR_ENDER.1", TR_Recipes.addCrucibleRecipe("TR_ENDER", new ItemStack(Items.field_151079_bi, 2, 0), aspects, new ItemStack(Items.field_151079_bi, 1, 0)));
        aspects = new AspectList().add(Aspect.LIFE, 5).add(Aspect.MAGIC, 5).add(Aspect.MAN, 5).add(Aspect.ALCHEMY, 5);
        recipes.put("THAUMICTOAST.1", TR_Recipes.addCrucibleRecipe("THAUMICTOAST@1", new ItemStack(TR_Items.itemToast, 1, 0), aspects, new ItemStack(Items.field_151025_P, 1, 0)));
    }

    private static void addCrystalInfuserRecipes() {
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.AIR, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 0));
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.FIRE, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 1));
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.WATER, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 2));
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.EARTH, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 3));
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.ORDER, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 4));
        new RecipeCrystalInfusion("INFUSEDTHAUMIUM@1", Aspect.ENTROPY, new ItemStack(ItemsTC.ingots), new ItemStack(TR_Items.itemIngot, 1, 5));
    }

    private static void addWandTriggers() {
        for (IDustTrigger t : IDustTrigger.triggers) {
            IWandTrigger.registerWandTrigger(new WandTriggerDust(t));
        }
        IWandTrigger.registerWandTrigger(new WandTriggerSimple("WANDTRANS@1", Blocks.field_180398_cJ, new ItemStack(BlocksTC.amberBlock), 5));
        IWandTrigger.registerWandTrigger(new WandTriggerSimple("WANDTRANS@1", Blocks.field_150423_aK, new ItemStack(Blocks.field_150440_ba), 5));
        IWandTrigger.registerWandTrigger(new WandTriggerFire("WANDFIRE@1"));
    }

    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ModContainer activeContainer = Loader.instance().activeModContainer();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(activeContainer.getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(activeContainer.getModId(), baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    public static ResourceLocation addShapedOreRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, params);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
        return location;
    }

    public static ResourceLocation addShapelessOreRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
        return location;
    }

    public static ResourceLocation addShapedArcaneRecipe(String research, ItemStack output, int vis, AspectList crystals, Object ... input) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        ShapedArcaneRecipe recipe = new ShapedArcaneRecipe(location, research, vis, crystals, output, input);
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)location, (IArcaneRecipe)recipe);
        return location;
    }

    public static ResourceLocation addShapedArcaneCrystalRecipe(String research, ItemStack output, int vis, AspectList crystals, Object ... input) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        RecipeCrystal recipe = new RecipeCrystal(location, research, vis, crystals, output, input);
        ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)location, (IArcaneRecipe)recipe);
        return location;
    }

    public static ResourceLocation addInfusionRecipe(String research, ItemStack output, int instability, ItemStack catalyst, AspectList aspects, Object ... input) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        InfusionRecipe recipe = new InfusionRecipe(research, (Object)output, instability, aspects, (Object)catalyst, input);
        ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)location, (InfusionRecipe)recipe);
        return location;
    }

    public static ResourceLocation addCrucibleRecipe(String research, ItemStack output, AspectList aspects, Object input) {
        ResourceLocation location = TR_Recipes.getNameForRecipe(output);
        CrucibleRecipe recipe = new CrucibleRecipe(research, output, input, aspects);
        ThaumcraftApi.addCrucibleRecipe((ResourceLocation)location, (CrucibleRecipe)recipe);
        return location;
    }
}

