/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticalworld.item.metals;

import epicsquid.mysticallib.block.BlockBase;
import epicsquid.mysticallib.event.RegisterContentEvent;
import epicsquid.mysticallib.item.ItemBase;
import epicsquid.mysticalworld.MysticalWorld;
import epicsquid.mysticalworld.config.ConfigManager;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraftforge.oredict.OreDictionary;

public enum Metal {
    copper("Copper", 3.5f),
    silver("Silver", 5.0f);

    private Item ingot;
    private Item nugget;
    private Item dust;
    private Item dustTiny;
    private Block block;
    private Block ore;
    private final float hardness;
    private final String oredictNameSuffix;
    private final boolean isEmbers;

    private Metal(String oredictNameSuffix, float hardness, boolean isEmbers) {
        this.oredictNameSuffix = oredictNameSuffix;
        this.hardness = hardness;
        this.isEmbers = isEmbers;
    }

    private Metal(String oredictNameSuffix, float hardness) {
        this(oredictNameSuffix, hardness, false);
    }

    public float getHardness() {
        return this.hardness;
    }

    @Nonnull
    public String getOredictNameSuffix() {
        return this.oredictNameSuffix;
    }

    @Nullable
    public Item getIngot() {
        return this.ingot;
    }

    @Nonnull
    public Item setIngot(@Nonnull Item item) {
        this.ingot = item;
        return this.ingot;
    }

    @Nullable
    public Item getDust() {
        return this.dust;
    }

    @Nonnull
    public Item setDust(@Nonnull Item dust) {
        this.dust = dust;
        return this.dust;
    }

    @Nullable
    public Item getDustTiny() {
        return this.dustTiny;
    }

    @Nonnull
    public Item setDustTiny(@Nonnull Item dustTiny) {
        this.dustTiny = dustTiny;
        return this.dustTiny;
    }

    @Nullable
    public Block getBlock() {
        return this.block;
    }

    @Nonnull
    public Block setBlock(@Nonnull Block block) {
        this.block = block;
        return this.block;
    }

    @Nullable
    public Item getNugget() {
        return this.nugget;
    }

    @Nonnull
    public Item setNugget(@Nonnull Item nugget) {
        this.nugget = nugget;
        return this.nugget;
    }

    @Nullable
    public Block getOre() {
        return this.ore;
    }

    @Nonnull
    public Block setOre(@Nonnull Block ore) {
        this.ore = ore;
        return this.ore;
    }

    public boolean isEnabled() {
        if (this.isEmbers) {
            try {
                return ConfigManager.modules.embersModuleEnabled && ConfigManager.metals.getClass().getField("enable" + this.getOredictNameSuffix()).getBoolean(ConfigManager.metals);
            }
            catch (Exception e) {
                System.out.println("Error: Cannot find the specified metal in configs. Are you sure you added it?");
                return ConfigManager.modules.embersModuleEnabled;
            }
        }
        try {
            return ConfigManager.modules.mysticalWorldModuleEnabled && ConfigManager.metals.getClass().getField("enable" + this.getOredictNameSuffix()).getBoolean(ConfigManager.metals);
        }
        catch (Exception e) {
            System.out.println("Error: Cannot find the specified metal in configs. Are you sure you added it?");
            return ConfigManager.modules.mysticalWorldModuleEnabled;
        }
    }

    public boolean hasGrindables() {
        return true;
    }

    public boolean hasOre() {
        return true;
    }

    public static void registerMetals(@Nonnull RegisterContentEvent event) {
        for (Metal metal : Metal.values()) {
            if (!metal.isEnabled()) continue;
            if (ConfigManager.metals.enableIngots) {
                event.addItem(metal.setIngot(new ItemBase(metal.name() + "_ingot").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
            }
            if (ConfigManager.metals.enableNuggets) {
                event.addItem(metal.setNugget(new ItemBase(metal.name() + "_nugget").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
            }
            if (metal.hasGrindables()) {
                if (ConfigManager.metals.enableDusts) {
                    event.addItem(metal.setDust(new ItemBase(metal.name() + "_dust").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
                }
                if (ConfigManager.metals.enableTinyDusts) {
                    event.addItem(metal.setDustTiny(new ItemBase(metal.name() + "_dust_tiny").setModelCustom(true).func_77637_a(MysticalWorld.tab)));
                }
            }
            if (ConfigManager.metals.enableBlocks) {
                event.addBlock(metal.setBlock(new BlockBase(Material.field_151573_f, SoundType.field_185852_e, metal.getHardness(), metal.name() + "_block").setModelCustom(true).func_149647_a(MysticalWorld.tab)));
            }
            if (!metal.hasOre() || !ConfigManager.metals.enableOres) continue;
            event.addBlock(metal.setOre(new BlockBase(Material.field_151576_e, SoundType.field_185851_d, metal.getHardness(), metal.name() + "_ore").setModelCustom(true).func_149647_a(MysticalWorld.tab)));
        }
    }

    public static void registerOreDict() {
        for (Metal metal : Metal.values()) {
            if (!metal.isEnabled()) continue;
            if (ConfigManager.metals.enableIngots) {
                OreDictionary.registerOre((String)("ingot" + metal.getOredictNameSuffix()), (Item)metal.getIngot());
            }
            if (ConfigManager.metals.enableNuggets) {
                OreDictionary.registerOre((String)("nugget" + metal.getOredictNameSuffix()), (Item)metal.getNugget());
            }
            if (metal.hasGrindables()) {
                if (ConfigManager.metals.enableDusts) {
                    OreDictionary.registerOre((String)("dust" + metal.getOredictNameSuffix()), (Item)metal.getDust());
                }
                if (ConfigManager.metals.enableTinyDusts) {
                    OreDictionary.registerOre((String)("dustTiny" + metal.getOredictNameSuffix()), (Item)metal.getDustTiny());
                }
            }
            if (ConfigManager.metals.enableBlocks) {
                OreDictionary.registerOre((String)("block" + metal.getOredictNameSuffix()), (Block)metal.getBlock());
            }
            if (!metal.hasOre() || !ConfigManager.metals.enableOres) continue;
            OreDictionary.registerOre((String)("ore" + metal.getOredictNameSuffix()), (Block)metal.getOre());
        }
    }
}

