/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.entity;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.ISpellAcceptor;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.client.core.helper.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellGrenade;

public class EntitySpellProjectile
extends EntityThrowable {
    private static final String TAG_COLORIZER = "colorizer";
    private static final String TAG_BULLET = "bullet";
    private static final String TAG_TIME_ALIVE = "timeAlive";
    private static final String TAG_LAST_MOTION_X = "lastMotionX";
    private static final String TAG_LAST_MOTION_Y = "lastMotionY";
    private static final String TAG_LAST_MOTION_Z = "lastMotionZ";
    private static final DataParameter<ItemStack> COLORIZER_DATA = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> BULLET_DATA = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<String> CASTER_NAME = EntityDataManager.func_187226_a(EntitySpellProjectile.class, (DataSerializer)DataSerializers.field_187194_d);
    public SpellContext context;
    public int timeAlive;

    public EntitySpellProjectile(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntitySpellProjectile(World worldIn, EntityLivingBase throwerIn) {
        super(worldIn, throwerIn);
        this.func_184538_a((Entity)throwerIn, throwerIn.field_70125_A, throwerIn.field_70177_z, 0.0f, 1.5f, 1.0f);
        double speed = 1.5;
        this.field_70159_w *= speed;
        this.field_70181_x *= speed;
        this.field_70179_y *= speed;
    }

    public EntitySpellProjectile setInfo(EntityPlayer player, ItemStack colorizer, ItemStack bullet) {
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        this.field_70180_af.func_187227_b(CASTER_NAME, (Object)player.func_70005_c_());
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLORIZER_DATA, (Object)new ItemStack(Blocks.field_150348_b));
        this.field_70180_af.func_187214_a(BULLET_DATA, (Object)new ItemStack(Blocks.field_150348_b));
        this.field_70180_af.func_187214_a(CASTER_NAME, (Object)"");
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        NBTTagCompound colorizerCmp = new NBTTagCompound();
        ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
        if (!colorizer.func_190926_b()) {
            colorizer.func_77955_b(colorizerCmp);
        }
        tagCompound.func_74782_a(TAG_COLORIZER, (NBTBase)colorizerCmp);
        NBTTagCompound bulletCmp = new NBTTagCompound();
        ItemStack bullet = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA);
        if (!bullet.func_190926_b()) {
            bullet.func_77955_b(bulletCmp);
        }
        tagCompound.func_74782_a(TAG_BULLET, (NBTBase)bulletCmp);
        tagCompound.func_74768_a(TAG_TIME_ALIVE, this.timeAlive);
        tagCompound.func_74780_a(TAG_LAST_MOTION_X, this.field_70159_w);
        tagCompound.func_74780_a(TAG_LAST_MOTION_Y, this.field_70181_x);
        tagCompound.func_74780_a(TAG_LAST_MOTION_Z, this.field_70179_y);
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        NBTTagCompound colorizerCmp = tagCompound.func_74775_l(TAG_COLORIZER);
        ItemStack colorizer = new ItemStack(colorizerCmp);
        this.field_70180_af.func_187227_b(COLORIZER_DATA, (Object)colorizer);
        NBTTagCompound bulletCmp = tagCompound.func_74775_l(TAG_BULLET);
        ItemStack bullet = new ItemStack(bulletCmp);
        this.field_70180_af.func_187227_b(BULLET_DATA, (Object)bullet);
        EntityLivingBase thrower = this.func_85052_h();
        if (thrower instanceof EntityPlayer) {
            this.field_70180_af.func_187227_b(CASTER_NAME, (Object)thrower.func_70005_c_());
        }
        this.timeAlive = tagCompound.func_74762_e(TAG_TIME_ALIVE);
        double lastMotionX = tagCompound.func_74769_h(TAG_LAST_MOTION_X);
        double lastMotionY = tagCompound.func_74769_h(TAG_LAST_MOTION_Y);
        double lastMotionZ = tagCompound.func_74769_h(TAG_LAST_MOTION_Z);
        this.field_70159_w = lastMotionX;
        this.field_70181_x = lastMotionY;
        this.field_70179_y = lastMotionZ;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int timeAlive = this.field_70173_aa;
        if (timeAlive > this.getLiveTime()) {
            this.func_70106_y();
        }
        int colorVal = 1295871;
        ItemStack colorizer = (ItemStack)this.field_70180_af.func_187225_a(COLORIZER_DATA);
        if (!colorizer.func_190926_b() && colorizer.func_77973_b() instanceof ICADColorizer) {
            colorVal = Psi.proxy.getColorForColorizer(colorizer);
        }
        float r = (float)PsiRenderHelper.r(colorVal) / 255.0f;
        float g = (float)PsiRenderHelper.g(colorVal) / 255.0f;
        float b = (float)PsiRenderHelper.b(colorVal) / 255.0f;
        double x = this.field_70165_t;
        double y = this.field_70163_u;
        double z = this.field_70161_v;
        Vector3 lookOrig = new Vector3(this.field_70159_w, this.field_70181_x, this.field_70179_y).normalize();
        for (int i = 0; i < this.getParticleCount(); ++i) {
            Vector3 look = lookOrig.copy();
            double spread = 0.6;
            double dist = 0.15;
            if (this instanceof EntitySpellGrenade) {
                look.y += 1.0;
                dist = 0.05;
            }
            look.x += (Math.random() - 0.5) * spread;
            look.y += (Math.random() - 0.5) * spread;
            look.z += (Math.random() - 0.5) * spread;
            look.normalize().multiply(dist);
            Psi.proxy.sparkleFX(x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 1.2f, 12);
        }
    }

    public int getLiveTime() {
        return 600;
    }

    public int getParticleCount() {
        return 5;
    }

    protected void func_70184_a(@Nonnull RayTraceResult pos) {
        if (pos.field_72308_g instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)pos.field_72308_g;
            this.cast(context -> {
                if (context != null) {
                    context.attackedEntity = e;
                }
            });
        } else {
            this.cast();
        }
    }

    public void cast() {
        this.cast(null);
    }

    public void cast(Consumer<SpellContext> callback) {
        Spell spell;
        ItemStack spellContainer;
        EntityLivingBase thrower = this.func_85052_h();
        boolean canCast = false;
        if (thrower instanceof EntityPlayer && !(spellContainer = (ItemStack)this.field_70180_af.func_187225_a(BULLET_DATA)).func_190926_b() && ISpellAcceptor.isContainer(spellContainer) && (spell = ISpellAcceptor.acceptor(spellContainer).getSpell()) != null) {
            canCast = true;
            if (this.context == null) {
                this.context = new SpellContext().setPlayer((EntityPlayer)thrower).setFocalPoint((Entity)this).setSpell(spell);
            }
            this.context.setFocalPoint((Entity)this);
        }
        if (callback != null) {
            callback.accept(this.context);
        }
        if (canCast && this.context != null) {
            this.context.cspell.safeExecute(this.context);
        }
        this.func_70106_y();
    }

    public EntityLivingBase func_85052_h() {
        EntityLivingBase superThrower = super.func_85052_h();
        if (superThrower != null) {
            return superThrower;
        }
        String name = (String)this.field_70180_af.func_187225_a(CASTER_NAME);
        return this.func_130014_f_().func_72924_a(name);
    }

    protected float func_70185_h() {
        return 0.0f;
    }
}

