/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.gui;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import vazkii.arl.network.NetworkHandler;
import vazkii.arl.network.NetworkMessage;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketableCapability;
import vazkii.psi.api.cad.ISocketableController;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.client.core.helper.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.network.message.MessageChangeControllerSlot;
import vazkii.psi.common.network.message.MessageChangeSocketableSlot;

public class GuiSocketSelect
extends GuiScreen {
    private static final ResourceLocation[] signs = new ResourceLocation[]{new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 0)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 1)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 2)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 3)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 4)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 5)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 6)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 7)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 8)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 9)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 10)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 11)), new ResourceLocation(String.format("psi:textures/gui/signs/sign%d.png", 12))};
    int timeIn = 0;
    int slotSelected = -1;
    ItemStack controllerStack;
    ISocketableController controller;
    ItemStack[] controlledStacks;
    int controlSlot;
    ItemStack socketableStack;
    ISocketableCapability socketable;
    List<Integer> slots;

    public GuiSocketSelect(ItemStack stack) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.controllerStack = ItemStack.field_190927_a;
        this.socketableStack = ItemStack.field_190927_a;
        if (ISocketableCapability.isSocketable(stack)) {
            this.setSocketable(stack);
        } else if (stack.func_77973_b() instanceof ISocketableController) {
            this.controllerStack = stack;
            this.controller = (ISocketableController)stack.func_77973_b();
            this.controlledStacks = this.controller.getControlledStacks((EntityPlayer)this.field_146297_k.field_71439_g, stack);
            this.controlSlot = this.controller.getDefaultControlSlot(this.controllerStack);
            if (this.controlSlot >= this.controlledStacks.length) {
                this.controlSlot = 0;
            }
            this.setSocketable(this.controlledStacks.length == 0 ? ItemStack.field_190927_a : this.controlledStacks[this.controlSlot]);
        }
    }

    public void setSocketable(ItemStack stack) {
        this.slots = new ArrayList<Integer>();
        if (stack.func_190926_b()) {
            return;
        }
        this.socketableStack = stack;
        this.socketable = ISocketableCapability.socketable(stack);
        for (int i = 0; i < 12; ++i) {
            if (!this.socketable.showSlotInRadialMenu(i)) continue;
            this.slots.add(i);
        }
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        float radius;
        boolean mouseInSector;
        int seg;
        super.func_73863_a(mx, my, partialTicks);
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        int maxRadius = 80;
        double angle = GuiSocketSelect.mouseAngle(x, y, mx, my);
        int segments = this.slots.size();
        float step = (float)Math.PI / 180;
        float degPer = (float)Math.PI * 2 / (float)segments;
        ItemStack cadStack = PsiAPI.getPlayerCAD((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.slotSelected = -1;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buf = tess.func_178180_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        buf.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector) {
                radius *= 1.025f;
            }
            int gs = 64;
            if (seg % 2 == 0) {
                gs += 25;
            }
            int r = gs;
            int g = gs;
            int b = gs;
            int a = 102;
            if (seg == 0) {
                buf.func_181662_b((double)x, (double)y, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            }
            if (mouseInSector) {
                this.slotSelected = seg;
                if (!cadStack.func_190926_b()) {
                    int color = Psi.proxy.getColorForCAD(cadStack);
                    r = PsiRenderHelper.r(color);
                    g = PsiRenderHelper.g(color);
                    b = PsiRenderHelper.b(color);
                } else {
                    b = 255;
                    g = 255;
                    r = 255;
                }
            }
            for (float i = 0.0f; i < degPer + step / 2.0f; i += step) {
                float rad = i + (float)seg * degPer;
                float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
                float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
                if (i == 0.0f) {
                    buf.func_181662_b((double)xp, (double)yp, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                }
                buf.func_181662_b((double)xp, (double)yp, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            }
        }
        tess.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (seg = 0; seg < segments; ++seg) {
            mouseInSector = (double)(degPer * (float)seg) < angle && angle < (double)(degPer * (float)(seg + 1));
            radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            if (mouseInSector) {
                radius *= 1.025f;
            }
            float rad = ((float)seg + 0.5f) * degPer;
            float xp = (float)x + MathHelper.func_76134_b((float)rad) * radius;
            float yp = (float)y + MathHelper.func_76126_a((float)rad) * radius;
            ItemStack stack = this.socketable.getBulletInSocket(seg);
            if (stack.func_190926_b()) continue;
            float xsp = xp - 4.0f;
            float ysp = yp;
            String name = (mouseInSector ? TextFormatting.UNDERLINE : TextFormatting.RESET) + stack.func_82833_r();
            int width = this.field_146289_q.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            int ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.field_146297_k.func_175599_af().func_175042_a(stack, xdp - 8, ydp - 8);
            if (xsp < (float)x) {
                xsp -= (float)(width - 8);
            }
            if (ysp < (float)y) {
                ysp -= 9.0f;
            }
            this.field_146289_q.func_175063_a(name, xsp, ysp, 0xFFFFFF);
            mod = 0.8;
            xdp = (int)((double)(xp - (float)x) * mod + (double)x);
            ydp = (int)((double)(yp - (float)y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a(signs[seg]);
            GuiSocketSelect.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        float shift = Math.min(5.0f, (float)this.timeIn + partialTicks) / 5.0f;
        float scale = 3.0f * shift;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        if (this.controlledStacks != null && this.controlledStacks.length > 0) {
            int xs = this.field_146294_l / 2 - 18 * this.controlledStacks.length / 2;
            int ys = this.field_146295_m / 2;
            for (int i = 0; i < this.controlledStacks.length; ++i) {
                float yoff = 25.0f + (float)maxRadius;
                if (i == this.controlSlot) {
                    yoff += 5.0f;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(-yoff * shift), (float)0.0f);
                this.field_146297_k.func_175599_af().func_180450_b(this.controlledStacks[i], xs + i * 18, ys);
                GlStateManager.func_179121_F();
            }
        }
        if (!this.socketableStack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.field_146297_k.func_175599_af().func_180450_b(this.socketableStack, (int)((float)x / scale) - 8, (int)((float)y / scale) - 8);
            GlStateManager.func_179121_F();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (!this.controllerStack.func_190926_b() && this.controlledStacks.length > 0) {
            if (mouseButton == 0) {
                ++this.controlSlot;
                if (this.controlSlot >= this.controlledStacks.length) {
                    this.controlSlot = 0;
                }
            } else if (mouseButton == 1) {
                --this.controlSlot;
                if (this.controlSlot < 0) {
                    this.controlSlot = this.controlledStacks.length - 1;
                }
            }
            this.setSocketable(this.controlledStacks[this.controlSlot]);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.isKeyDown(KeybindHandler.keybind)) {
            this.field_146297_k.func_147108_a(null);
            if (this.slotSelected != -1) {
                int slot = this.slots.get(this.slotSelected);
                PlayerDataHandler.get((EntityPlayer)this.field_146297_k.field_71439_g).stopLoopcast();
                NetworkMessage message = !this.controllerStack.func_190926_b() ? new MessageChangeControllerSlot(this.controlSlot, slot) : new MessageChangeSocketableSlot(slot);
                NetworkHandler.INSTANCE.sendToServer((IMessage)message);
            }
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)this.isKeyDown(k));
        }
        ++this.timeIn;
    }

    public boolean isKeyDown(KeyBinding keybind) {
        int key = keybind.func_151463_i();
        if (key < 0) {
            int button = 100 + key;
            return Mouse.isButtonDown((int)button);
        }
        return Keyboard.isKeyDown((int)key);
    }

    public boolean func_73868_f() {
        return false;
    }

    private static double mouseAngle(int x, int y, int mx, int my) {
        return (MathHelper.func_181159_b((double)(my - y), (double)(mx - x)) + Math.PI * 2) % (Math.PI * 2);
    }
}

