/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.eyes;

import com.google.common.collect.Sets;
import gigaherz.eyes.ConfigData;
import gigaherz.eyes.InitiateJumpscare;
import gigaherz.eyes.entity.EntityEyes;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(modid="eyesinthedarkness", version="0.0.5", acceptedMinecraftVersions="[1.12.2]")
public class EyesInTheDarkness {
    public static final String MODID = "eyesinthedarkness";
    public static final String VERSION = "0.0.5";
    public static final Logger LOGGER = LogManager.getLogger((String)"eyesinthedarkness");
    @GameRegistry.ObjectHolder(value="eyesinthedarkness:eyes_laugh")
    public static SoundEvent eyes_laugh;
    @GameRegistry.ObjectHolder(value="eyesinthedarkness:eyes_disappear")
    public static SoundEvent eyes_disappear;
    @GameRegistry.ObjectHolder(value="eyesinthedarkness:eyes_jumpscare")
    public static SoundEvent eyes_jumpscare;
    private static final String CHANNEL = "eyesinthedarkness";
    public static SimpleNetworkWrapper channel;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.registerNetwork();
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new SoundEvent[]{(SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.laugh")).setRegistryName(EyesInTheDarkness.location("eyes_laugh")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.disappear")).setRegistryName(EyesInTheDarkness.location("eyes_disappear")), (SoundEvent)new SoundEvent(EyesInTheDarkness.location("mob.eyes.jumpscare")).setRegistryName(EyesInTheDarkness.location("eyes_jumpscare"))});
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        int entityId = 1;
        EntityEntryBuilder builder = EntityEntryBuilder.create().name("eyes").id(EyesInTheDarkness.location("eyes"), entityId++).entity(EntityEyes.class).factory(EntityEyes::new).tracker(80, 3, true).egg(0, 0x7F0000);
        if (ConfigData.EnableNaturalSpawn) {
            int currentWeight = ConfigData.OverrideWeight;
            if (currentWeight < 0) {
                int daysBefore = EyesInTheDarkness.getDaysUntilNextHalloween();
                int weightMin = 15;
                int weightMax = 150;
                currentWeight = weightMin + (weightMax - weightMin) * (30 - daysBefore) / 30;
            }
            if (currentWeight > 0) {
                Collection biomes = ForgeRegistries.BIOMES.getValuesCollection();
                if (ConfigData.BiomeWhitelist != null && ConfigData.BiomeWhitelist.length > 0) {
                    HashSet whitelist = Sets.newHashSet((Object[])ConfigData.BiomeBlacklist);
                    biomes = biomes.stream().filter(b -> whitelist.contains(b.getRegistryName().toString())).collect(Collectors.toList());
                } else if (ConfigData.BiomeBlacklist != null && ConfigData.BiomeBlacklist.length > 0) {
                    HashSet blacklist = Sets.newHashSet((Object[])ConfigData.BiomeBlacklist);
                    biomes = biomes.stream().filter(b -> !blacklist.contains(b.getRegistryName().toString())).collect(Collectors.toList());
                }
                builder = builder.spawn(EnumCreatureType.MONSTER, currentWeight, ConfigData.MinimumPackSize, ConfigData.MaximumPackSize, (Iterable)biomes);
            }
        }
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{builder.build()});
        LOGGER.debug("Next entity id: " + entityId);
    }

    private static int getDaysUntilNextHalloween() {
        Calendar nextHalloween;
        Calendar now = Calendar.getInstance();
        if (now.after(nextHalloween = new Calendar.Builder().setDate(now.get(1), 9, 31).setTimeOfDay(23, 59, 59, 999).build())) {
            nextHalloween.add(1, 1);
        }
        return (int)Math.min(ChronoUnit.DAYS.between(now.toInstant(), nextHalloween.toInstant()), 30L);
    }

    private void registerNetwork() {
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("eyesinthedarkness");
        int messageNumber = 0;
        channel.registerMessage(InitiateJumpscare.Handler.class, InitiateJumpscare.class, messageNumber++, Side.CLIENT);
        LOGGER.debug("Final message number: " + messageNumber);
    }

    @SubscribeEvent
    public static void entityInit(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        if (e instanceof EntityWolf) {
            EntityWolf wolf = (EntityWolf)e;
            wolf.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)wolf, EntityEyes.class, false));
        }
        if (e instanceof EntityOcelot) {
            EntityOcelot cat = (EntityOcelot)e;
            cat.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)cat, EntityEyes.class, 6.0f, 1.0, 1.2));
        }
    }

    public static ResourceLocation location(String location) {
        return new ResourceLocation("eyesinthedarkness", location);
    }
}

