/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.config.adapter;

import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.CompatForgeRegistry;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.CompatForgeRegistryEntry;
import com.therandomlabs.randomportals.repackage.com.therandomlabs.randomlib.config.adapter.TRLTypeAdapter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public final class ResourceLocationTypeAdapter
implements TRLTypeAdapter {
    private final Class<?> registryEntryClass;
    private final CompatForgeRegistry<?> registry;
    private final boolean isArray;

    public ResourceLocationTypeAdapter(Class<?> registryEntryClass, boolean isArray) {
        this.registryEntryClass = registryEntryClass;
        this.registry = CompatForgeRegistry.findRegistry(registryEntryClass);
        this.isArray = isArray;
    }

    @Override
    public Object getValue(Property property) {
        if (!this.isArray) {
            String location = property.getString();
            if (location.isEmpty()) {
                return null;
            }
            Object object = this.registry.getValue(new ResourceLocation(location.replaceAll("\\s", "")));
            return object == null ? this.registry.getValue(new ResourceLocation(property.getDefault())) : object;
        }
        String[] array = property.getStringList();
        ArrayList values = new ArrayList(array.length);
        for (String element : array) {
            Object object = this.registry.getValue(new ResourceLocation(element.replaceAll("\\s", "")));
            if (object == null) continue;
            values.add(object);
        }
        return values.toArray((Object[])Array.newInstance(this.registryEntryClass, 0));
    }

    @Override
    public String asString(Object value) {
        return value == null ? "" : new CompatForgeRegistryEntry(value).getRegistryName().toString();
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean shouldLoad() {
        return Loader.instance().hasReachedState(LoaderState.INITIALIZATION);
    }
}

