/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl;

import com.therandomlabs.randomportals.repackage.blue.endless.jankson.Jankson;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.JsonPrimitive;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl.ParserContext;
import com.therandomlabs.randomportals.repackage.blue.endless.jankson.impl.SyntaxError;

public class TokenParserContext
implements ParserContext<JsonPrimitive> {
    private String token = "";
    private boolean complete = false;

    public TokenParserContext(int firstCodePoint) {
        this.token = this.token + (char)firstCodePoint;
    }

    @Override
    public boolean consume(int codePoint, Jankson loader) throws SyntaxError {
        if (this.complete) {
            return false;
        }
        if (Character.isUnicodeIdentifierPart(codePoint)) {
            if (codePoint < 65535) {
                this.token = this.token + (char)codePoint;
                return true;
            }
            int temp = codePoint - 65536;
            int highSurrogate = (temp >>> 10) + 55296;
            int lowSurrogate = (temp & 0x3FF) + 56320;
            this.token = this.token + (char)highSurrogate;
            this.token = this.token + (char)lowSurrogate;
            return true;
        }
        this.complete = true;
        return false;
    }

    @Override
    public void eof() throws SyntaxError {
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public JsonPrimitive getResult() throws SyntaxError {
        return new JsonPrimitive(this.token);
    }
}

